/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   :  Platform-dependent definitions
 *                  This file is expected to be modified during porting
 *--------------------------------------------------------------------
 * MODULE        : Linux - SY
 * DEPENDENCIES  :
 ********************************************************************/
#ifndef _SYPLTFRM_H_
#define _SYPLTFRM_H_

#include "stdint.h"

/* accuracy (non-accuracy) of the system timer
   is defined in 100 nanosec units of the minimum time interval that this hardware may
   measure (clock tick) */

#define syGetTimeAccuracy() 556000L  /* 18 times in second for PC */

/*  SY_INT64 is used as native 64 bit INT and also as flag.  
    If SY_INT64 is defined the host machine supports 64 bit operations. 
    If SY_INT64 is blocked (commented) the host machine supports only 32 bit operations. */
#ifdef SY_INT32
#define SY_INT64  int64_t
#ifdef SY_INT64
#define SY_UINT64 uint64_t
#endif
#endif /* SY_INT32 */

/* byte order on the target machine */

#if defined(__LittleEndian) || defined(LittleEndian) || (defined(BYTE_ORDER) && defined(LITTLE_ENDIAN) && (BYTE_ORDER == LITTLE_ENDIAN))
#define SY_LITTLEENDIANHOST
#elif defined(__BigEndian) || defined(BigEndian) || (defined(BYTE_ORDER) && defined(BIG_ENDIAN) && (BYTE_ORDER == BIG_ENDIAN))
#define SY_BIGENDIANHOST
#else
#error "Target byte order has to be defined, check sypltfrm.h"
#endif /* (defined(__LittleEndian) || defined(LittleEndian)) */

#endif  /* _SYPLTFRM_H_ */
