/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : The internal definitions for this modules
 *--------------------------------------------------------------------
 * MODULE        : Network
 * DEPENDENCIES  :
 ********************************************************************/

#ifndef _NSCOMMON_H_
#define _NSCOMMON_H_

#include "nsapi.h"
#include "nsinsock.h"

/*
    Internal routines
 */

#ifdef UD_ND_INCLUDENBDAEMON
/* send ISALIVE message to the NetBIOS Daemon */

NQ_STATUS nsIsDaemonAlive(
     const CMNetBiosNameInfo* localName
     );

/* check whether NetBIOS Daemon in use */
NQ_BOOL nsIsDaemonInUse(
     void
     );
#endif /* UD_ND_INCLUDENBDAEMON */

/* send request to the Name Daemon */

NQ_STATUS                   /* NQ_FAIL or SUCESS */
nsSendRequestToND(
    SYSocketHandle socket,  /* socket to use */
    NQ_BYTE *msg,           /* message to send */
    NQ_UINT msgLen          /* message length */
    );

/* receive response from the Name Daemon */

NQ_STATUS                   /* NQ_FAIL or SUCESS */
nsReceiveResponseFromND(
    SYSocketHandle socket,  /* socket to use */
    void * addrEntry        /* buffer to place the response message */
    );

/* send request to the Name Daemon and get a response */

NQ_STATUS                   /* NQ_FAIL or SUCESS */
nsProceedRequestToND(
    NQ_BYTE *msg,           /* message to send */
    NQ_UINT msgLen,         /* message length */
    NQ_UINT32 timeout,      /* time out for response */
    void* responseBuf       /* buffer to place the response message */
    );

/* send request to the Datagram Daemon and get a response */

NQ_STATUS                   /* NQ_FAIL or SUCESS */
nsProceedRequestToDD(
    NQ_BYTE *msg,           /* message to send */
    NQ_UINT msgLen,         /* message length */
    const CMNetBiosName name, /* socket name to check the response */
    NQ_UINT32 timeout         /* time out for response */
    );

/* generate a special NetBIOS name. ND will recognize this name as a
   PID registration request */

void
nsCreateInternalName(
    CMNetBiosName  buf      /* buffer for name creation */
    );

#endif  /* _NSCOMMON_H_ */

