/*********************************************************************
*
*           Copyright (c) 2021 by Visuality Systems, Ltd.
*
*********************************************************************
* FILE NAME     : $Workfile:$
* ID            : $Header:$
* REVISION      : $Revision:$
*--------------------------------------------------------------------
* DESCRIPTION   : UUID (GUID)
*--------------------------------------------------------------------
* MODULE        : Common
* DEPENDENCIES  :
********************************************************************/

#ifndef _CMUUID_H_
#define _CMUUID_H_

#include "cmapi.h"
#include "cmbuf.h"

/* UUID (GUID) */
#define CMUuid NQ_Uuid

/* Generate random GUID */
void cmGenerateUuid(CMUuid *uuid);

/* Generate zero GUID */
void cmZeroUuid(CMUuid *uuid);

/* Compare UUIDs */
NQ_BOOL cmUuidIsEqual(const CMUuid *uuid1, const CMUuid *uuid2);

/* Dump UUID */
NQ_CHAR *cmUuidDump(const CMUuid *uuid);

/* UUID to string, caller must free the memory */
NQ_CHAR *cmUuidToString(const CMUuid *uuid);


#endif /* _CMUUID_H_ */
