/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : MD4 implementation
 *--------------------------------------------------------------------
 * MODULE        : Auth - AM
 * DEPENDENCIES  : None
 ********************************************************************/

#include "cmapi.h"

#define MD4_F(x,y,z) ((x&y)|((~x)&z))
#define MD4_G(x,y,z) ((x&y)|(x&z)|(y&z))
#define MD4_H(x,y,z) (x^y^z)
#define MD4_STEP1(a,b,c,d,k,s) a = lrotate(a + MD4_F(b,c,d) + in[k], s)
#define MD4_STEP2(a,b,c,d,k,s) a = lrotate(a + MD4_G(b,c,d) + in[k] + (NQ_UINT32)0x5A827999,s)
#define MD4_STEP3(a,b,c,d,k,s) a = lrotate(a + MD4_H(b,c,d) + in[k] + (NQ_UINT32)0x6ED9EBA1,s)

/* message digest context */
typedef struct
{
    NQ_UINT32 a;
    NQ_UINT32 b;
    NQ_UINT32 c;
    NQ_UINT32 d;
} MD4Context;

static NQ_UINT32 lrotate(
        NQ_UINT32 x,
        NQ_INT s
        )
{
    return ((x<<s)&0xFFFFFFFF) | (x>>(32-s));
}

static void copy64(
        NQ_UINT32 *M,
        NQ_BYTE *in
        )
{
    NQ_INT i;

    for (i=0;i<16;i++)
        M[i] = (NQ_UINT32)((in[i*4+3]<<24) | (in[i*4+2]<<16) | (in[i*4+1]<<8) | (in[i*4+0]<<0));
}

static void copy4(
        NQ_BYTE *out,
        NQ_UINT32 x
        )
{
    out[0] = (NQ_BYTE)(x&0xFF);
    out[1] = (NQ_BYTE)((x>>8)&0xFF);
    out[2] = (NQ_BYTE)((x>>16)&0xFF);
    out[3] = (NQ_BYTE)((x>>24)&0xFF);
}

static void MD4_Transform(
        MD4Context *ctx,
        NQ_BYTE *buffer
        )
{
    NQ_UINT32 A, B, C, D;
    NQ_UINT32 in[16];

    copy64(in, buffer);

    A = ctx->a;
    B = ctx->b;
    C = ctx->c;
    D = ctx->d;

    MD4_STEP1(A,B,C,D,  0,  3);  MD4_STEP1(D,A,B,C,  1,  7);
    MD4_STEP1(C,D,A,B,  2, 11);  MD4_STEP1(B,C,D,A,  3, 19);
    MD4_STEP1(A,B,C,D,  4,  3);  MD4_STEP1(D,A,B,C,  5,  7);
    MD4_STEP1(C,D,A,B,  6, 11);  MD4_STEP1(B,C,D,A,  7, 19);
    MD4_STEP1(A,B,C,D,  8,  3);  MD4_STEP1(D,A,B,C,  9,  7);
    MD4_STEP1(C,D,A,B, 10, 11);  MD4_STEP1(B,C,D,A, 11, 19);
    MD4_STEP1(A,B,C,D, 12,  3);  MD4_STEP1(D,A,B,C, 13,  7);
    MD4_STEP1(C,D,A,B, 14, 11);  MD4_STEP1(B,C,D,A, 15, 19);
    MD4_STEP2(A,B,C,D,  0,  3);  MD4_STEP2(D,A,B,C,  4,  5);
    MD4_STEP2(C,D,A,B,  8,  9);  MD4_STEP2(B,C,D,A, 12, 13);
    MD4_STEP2(A,B,C,D,  1,  3);  MD4_STEP2(D,A,B,C,  5,  5);
    MD4_STEP2(C,D,A,B,  9,  9);  MD4_STEP2(B,C,D,A, 13, 13);
    MD4_STEP2(A,B,C,D,  2,  3);  MD4_STEP2(D,A,B,C,  6,  5);
    MD4_STEP2(C,D,A,B, 10,  9);  MD4_STEP2(B,C,D,A, 14, 13);
    MD4_STEP2(A,B,C,D,  3,  3);  MD4_STEP2(D,A,B,C,  7,  5);
    MD4_STEP2(C,D,A,B, 11,  9);  MD4_STEP2(B,C,D,A, 15, 13);
    MD4_STEP3(A,B,C,D,  0,  3);  MD4_STEP3(D,A,B,C,  8,  9);
    MD4_STEP3(C,D,A,B,  4, 11);  MD4_STEP3(B,C,D,A, 12, 15);
    MD4_STEP3(A,B,C,D,  2,  3);  MD4_STEP3(D,A,B,C, 10,  9);
    MD4_STEP3(C,D,A,B,  6, 11);  MD4_STEP3(B,C,D,A, 14, 15);
    MD4_STEP3(A,B,C,D,  1,  3);  MD4_STEP3(D,A,B,C,  9,  9);
    MD4_STEP3(C,D,A,B,  5, 11);  MD4_STEP3(B,C,D,A, 13, 15);
    MD4_STEP3(A,B,C,D,  3,  3);  MD4_STEP3(D,A,B,C, 11,  9);
    MD4_STEP3(C,D,A,B,  7, 11);  MD4_STEP3(B,C,D,A, 15, 15);

    ctx->a += A;
    ctx->b += B;
    ctx->c += C;
    ctx->d += D;
}

void md4Internal(const NQ_BYTE * in, NQ_BYTE * out, NQ_COUNT n)
{
    MD4Context ctx;
    NQ_BYTE buffer[128];
    NQ_UINT32 M[16];
    NQ_UINT32 b = (NQ_UINT32)(n * 8);

    ctx.a = 0x67452301;
    ctx.b = 0xefcdab89;
    ctx.c = 0x98badcfe;
    ctx.d = 0x10325476;

    while (n > 64) {
        MD4_Transform(&ctx, (NQ_BYTE *)in);
        in += 64;
        n -= 64;
    }

    syMemset(buffer, 0, sizeof(buffer));
    syMemcpy(buffer, in, n);
    buffer[n] = 0x80;

    if (n <= 55) {
        copy4(buffer+56, b);
        MD4_Transform(&ctx, buffer);
    } else {
        copy4(buffer+120, b);
        MD4_Transform(&ctx, buffer);
        MD4_Transform(&ctx, buffer+64);
    }

    syMemset(buffer, 0, sizeof(buffer));
    copy64(M, buffer);
    copy4(out, ctx.a);
    copy4(out+4, ctx.b);
    copy4(out+8, ctx.c);
    copy4(out+12, ctx.d);

    syMemset(&ctx, 0, sizeof(ctx));
}

