/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Server parameters
 *--------------------------------------------------------------------
 * MODULE        : Server
 * DEPENDENCIES  :
 ********************************************************************/

#ifndef _CSPARAMS_H_
#define _CSPARAMS_H_

#include "cmnbfram.h"

/* value of the flags and flags2 field for a server response */
#define CS_SMBFLAGS   0x88                  /* case insensitive & response */
#define CS_SMBFLAGS2  cmHtol16(0x0001)      /* aware of long names */

#define CS_SUPPORTEDDIALECT   "NT LM 0.12"  /* supported dialect SMB1 */

#define CS_MAXNUMBERVC      1                                                       /* number of virtual connections to the same client */
#define CS_MAXBUFFERSIZE    (UD_NS_BUFFERSIZE - sizeof(CMNetBiosSessionMessage))    /* max SMB message length */
#define CS_MAXRAWSIZE       (1<<16)                                                 /* max size of the message for SMB_COM_WRITE_RAW or SMB_COM_READ_RAW */

#define CS_SESSIONACTION            0               /* in the session response */
#define CS_SESSIONACTION_GUEST      1               /* action in the session setup response: guest login */
#define CS_PASSWORDLEN              16              /* the exact length of the password */

#define CS_SMB2_SESSIONEXPIRATIONTIME  (10*3600)    /* maximal time (in seconds) for smb2 session (uid) to live */

#define CS_SMB2_MAX_READ_SIZE   (CS_MAXBUFFERSIZE - SMB2_HEADERSIZE - 16)   /* 16 = structure size of SMB2 Read command  */
#define CS_SMB2_MAX_WRITE_SIZE  (CS_MAXBUFFERSIZE - SMB2_HEADERSIZE - 48)   /* 48 = structure size of SMB2 Write command */

#define CS_SMB2_MAX_TRANSREADWRITE_SIZE_MULTICREDIT     (1024 * 1024)       /* 1Mbyte - max buffer size when multi crediting on for commands Query Info, Directory, Set Info */

#endif  /* _CSPARAMS_H_ */

