/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : CIFS pass-through authentication library
 *--------------------------------------------------------------------
 * MODULE        : Server
 * DEPENDENCIES  : None
 ********************************************************************/

#ifndef _CSAUTH_H_
#define _CSAUTH_H_

#include "csdataba.h"


/* This flag enables LM encryption method. */
#define CS_AUTH_ENCRYPTION_LM        0x1
/* This flag enables NTLM encryption method. */
#define CS_AUTH_ENCRYPTION_NTLM      0x2
/* This flag enables LMv2 encryption method. */
#define CS_AUTH_ENCRYPTION_LMV2      0x4
/* This flag enables NTLMv2 encryption method. */
#define CS_AUTH_ENCRYPTION_NTLMV2    0x8
/* This flag enables all encryption methods */
#define CS_AUTH_ENCRYPTION_ALL       (CS_AUTH_ENCRYPTION_LM | CS_AUTH_ENCRYPTION_NTLM | CS_AUTH_ENCRYPTION_LMV2 | CS_AUTH_ENCRYPTION_NTLMV2)

/*
  Pass-through authentication library initialization and shutdown
*/

NQ_BOOL
csAuthInit(
    void
    );

void
csAuthShutdown(
    void
    );

/*
 * Returns pointer to the PDC host name or NULL of not initialized
 */

const NQ_WCHAR*
csAuthGetPDCName(
    void
    );


/* Perform user authentication */
NQ_UINT32
csAuthenticateUser(
    const NQ_IOBufPos pReq,
    CSSession *pSession,
#ifdef UD_CS_INCLUDEEXTENDEDSECURITY
    NQ_IOBufPos pOutBlob,               /* place to generate response blob */
    NQ_COUNT* blobLength,               /* pointer to blob length */
#endif /* UD_CS_INCLUDEEXTENDEDSECURITY */
    NQ_BOOL unicodeRequired,
    CSUser** pUser,
    const NQ_BYTE** pOsName
    );


NQ_BOOL
csChangeAuthenticationEncryptionLevel(
        NQ_UINT mask
        );
#endif /* _CSAUTH_H_ */
