#
#  Config file for make
#

# mk files
export CMNMK = $(BUILD_ROOT)/common.mk
export OSDEFMK = $(BUILD_ROOT)/osdef.mk
export PATHDEFMK = $(BUILD_ROOT)/pathdef.mk

# Output Directories
# --------------------
BINDIR  		:= $(BUILD_ROOT)/..
DEPDIR  		:= $(BUILD_ROOT)/../dep
OBJDIR  		:= $(BUILD_ROOT)/../obj
LIBDIR  		:= $(BUILD_ROOT)/../lib

# YNQ Directories
# --------------------
NQDIR			:= $(BUILD_ROOT)/nq
AUTHAMDIR  		:= $(BUILD_ROOT)/service/auth/am
CMNDIR 			:= $(BUILD_ROOT)/service/common
NTWKDIR			:= $(BUILD_ROOT)/service/network
WSDDIR			:= $(NTWKDIR)/wsd
OSDIR			:= $(BUILD_ROOT)/service/os/$(TARGET_OS)
OSUDDIR  		:= $(OSDIR)/ud
OSSYDIR 		:= $(OSDIR)/sy
NBTDIR			:= $(BUILD_ROOT)/netbios
DRVDIR			:= $(OSDIR)/driver
CSCTRLDIR 		:= $(BUILD_ROOT)/csctrl
SRVDIR			:= $(BUILD_ROOT)/server
CCDIR  			:= $(BUILD_ROOT)/client
RPCCOREDIR		:= $(CCDIR)/rpc/rpccore
RPCDOMAINDIR	:= $(CCDIR)/rpc/domain
RPCBROWSINGDIR	:= $(CCDIR)/rpc/browsing
RPCSDDIR		:= $(CCDIR)/rpc/sd
LDAPDIR			:= $(BUILD_ROOT)/ldap

# Libraries
# --------------------
NTWKLIB			:= $(LIBDIR)/nqns.a
CMNLIB			:= $(LIBDIR)/nqcm.a
AUTHAMLIB		:= $(LIBDIR)/nqam.a
WSDLIB			:= $(LIBDIR)/nqwsd.a
OSSYLIB			:= $(LIBDIR)/sy.a
OSUDLIB			:= $(LIBDIR)/ud.a
NBTLIB			:= $(LIBDIR)/nqnd.a
OSLIB			:= $(LIBDIR)/nq$(TARGET_OS).a
DRVLIB			:= $(LIBDIR)/dr.a
CSCTRLLIB		:= $(LIBDIR)/csctrl.a
SRVLIB			:= $(LIBDIR)/nqcs.a
RPCCORELIB 		:= $(LIBDIR)/nqccrpccore.a
RPCDOMAINLIB	:= $(LIBDIR)/nqccdomain.a
RPCBROWSINGLIB  := $(LIBDIR)/nqccbrowsing.a
RPCSDLIB		:= $(LIBDIR)/nqccsd.a
CCLIB			:= $(LIBDIR)/nqcc.a
LDAPLIB			:= $(LIBDIR)/nqldap.a

# Binaries
# --------------------
NETBIOS 		:= $(BINDIR)/nqnd
CSCTRL			:= $(BINDIR)/nqcsctrl
SERVERCLIENT	:= $(BINDIR)/nqcs
NDSERVERCLIENT	:= $(BINDIR)/nqndcs

# Main Sources
# --------------------
NDSRC   		:= stndmain.c
CSSRC   		:= stcsmain.c
NDCSSRC			:= stndcsmain.c

# App Sources
# --------------------

# Includes
# --------------------
export INCPATH := \
	-I$(NBTDIR) -I$(OSDIR) -I$(OSSYDIR) -I$(OSUDDIR) \
	-I$(CMNDIR) -I$(NQDIR) -I$(NTWKDIR) -I$(AUTHAMDIR) -I$(WSDDIR) -I/usr/include/libxml2
INCPATH += -I$(SRVDIR)
INCPATH += -I$(CCDIR) -I$(RPCCOREDIR) -I$(RPCDOMAINDIR) -I$(RPCBROWSINGDIR) -I$(RPCSDDIR) -I$(DRVDIR)
INCPATH +=  -I$(LDAPDIR)
