/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *************************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : User define API
 *--------------------------------------------------------------------
 * MODULE        : NQ
 * DEPENDENCIES  :
 *************************************************************************/

#include <udparams.h>
#include <sycompil.h>

#ifndef _UDAPI_H_
#define _UDAPI_H_

/** @defgroup udapi User Defined */

/* Primitive data types */

typedef char                NQ_CHAR;
typedef unsigned char       NQ_BYTE;
typedef int                 NQ_INT;
typedef unsigned int        NQ_UINT;
typedef int                 NQ_BOOL;
typedef NQ_UINT             NQ_INDEX;
typedef NQ_UINT             NQ_COUNT;
typedef short               NQ_INT16;
#ifdef SY_INT32
typedef SY_INT32            NQ_INT32;
#else
typedef long                NQ_INT32;
#endif
typedef unsigned short      NQ_UINT16;
#ifdef SY_INT32
typedef unsigned SY_INT32   NQ_UINT32;
#else
typedef unsigned long       NQ_UINT32;
#endif
typedef NQ_UINT16           NQ_WCHAR;
typedef void                *NQ_HANDLE;
typedef NQ_INT              NQ_STATUS;
typedef NQ_UINT16           NQ_PORT;
typedef NQ_UINT32           NQ_IPADDRESS4;
typedef NQ_UINT16           NQ_IPADDRESS6[8];
typedef unsigned long       NQ_ULONG;
typedef float               NQ_FLOAT;

/* complex data types   */

#if defined(CM_NQ_STORAGE) || defined(DOXYGEN)
typedef struct {
    NQ_INT id;
    NQ_BYTE version;
    union
    {
        NQ_IPADDRESS6 v6;
        NQ_IPADDRESS4 v4;
    } addr;
} NQ_IPADDRESSVR;
#endif /* CM_NQ_STORAGE */

/** NQ_UINT64 type */
typedef struct {
    NQ_UINT32 low;      /**< low part */
    NQ_UINT32 high;     /**< high part */
} NQ_UINT64;

/** NQ_INT64 type */
typedef struct {
    NQ_UINT32 low;        /**< low part */
    NQ_UINT32 high;        /**< high part */
    NQ_INT32  sign;        /**< sign */
} NQ_INT64;

typedef NQ_UINT64           NQ_TIME;

#define UD_DNS_SERVERSTRINGSIZE (16 * sizeof(NQ_WCHAR) * UD_NQ_MAXDNSSERVERS * UD_NS_MAXADAPTERS)

/* IOVEC structures */

typedef struct {
    NQ_BYTE  *iov_base; /**< Starting address */
    NQ_COUNT iov_len;   /**< Number of bytes  */
}NQ_IOVEC;
typedef struct {
    NQ_IOVEC *iovec;            /**< IOVec array */
    NQ_COUNT iovSegmentCnt;     /**< Number of array elements */
}NQ_IOVECBUF;

#ifdef UD_NQ_USEIOVECS
#define NQ_IOBuf NQ_IOVECBUF*
#else
#define NQ_IOBuf NQ_BYTE*
#endif

#if defined(UD_NQ_USEIOVECS) || defined(DOXYGEN)
typedef struct
{
    NQ_IOVEC data[3];   /**< The iovec buffer. */
    NQ_COUNT len;       /**< Total data lenggh */
}NQ_IOVecBuffer;

/** Abstract data buffer
   According to compile-time parameters, this type may evaluate
   to one of the following:
     * Plain buffer. Data is placed as a contiguous array of
       bytes.
     * IOVEC scatter-gather structure.
   NQ manipulates this type the same manner regardless of its
   implementation.                                              */

#define NQ_IOBuffer NQ_IOVecBuffer *
#else
#define NQ_IOBuffer CMBlob *
#endif

#if defined(UD_NQ_USEIOVECS) || defined(DOXYGEN)
/** Description
   A wrapper around IOVEC buffer to represent a message.                 */
typedef struct {
    NQ_IOBuf data;      /**< IOVec buffer or byte *   */
    NQ_COUNT len;       /**< total packet length      */
}CMIOVecBlob;

#define CMIOBufBlob CMIOVecBlob
#else
#define CMIOBufBlob CMBlob
#endif

/** Structure describing NQ_IPADDRESS
   stores IP version and address */
typedef struct
{
    NQ_BYTE version; /**< IP version */
    union
    {
#if defined(UD_NQ_USETRANSPORTIPV6) || defined(DOXYGEN)
        NQ_IPADDRESS6 v6; /**< IP address */
#endif /* UD_NQ_USETRANSPORTIPV6 */
        NQ_IPADDRESS4 v4; /**< IP address */
#if defined(CM_NQ_STORAGE) || defined(DOXYGEN)
#if defined(UD_NQ_USETRANSPORTIPVR) || defined(DOXYGEN)
        NQ_IPADDRESSVR vr; /**< IP address */
#endif /* UD_NQ_USETRANSPORTIPVR */
#endif /* CM_NQ_STORAGE */
    } addr;
} NQ_IPADDRESS;

/* SMB Errors */

/**@defgroup SMB_errors SMB Errors
 * @ingroup udapi
    SMB error in "DOS" format consists of an error class and error code
  @{          */

#define SMB_DOSERR(_class, _code)   (((NQ_UINT32)_code << 16) | _class)

#define CLASS_ERR_MODULE(_code)   ((NQ_UINT32)_code << 16)

#ifndef IS_DOS_ERROR
#define IS_DOS_ERROR(err) ((err & CLASS_ERR_MODULE(1)) == CLASS_ERR_MODULE(1))
#endif

#define SMB_ERRsuccess              0x00000000

#define DOS_ERRbadfunc              SMB_DOSERR(1, 1)
#define DOS_ERRbadfile              SMB_DOSERR(1, 2)
#define DOS_ERRbadpath              SMB_DOSERR(1, 3)
#define DOS_ERRnofids               SMB_DOSERR(1, 4)
#define DOS_ERRnoaccess             SMB_DOSERR(1, 5)
#define DOS_ERRbadfid               SMB_DOSERR(1, 6)
#define DOS_ERRbadmcb               SMB_DOSERR(1, 7)
#define DOS_ERRnomem                SMB_DOSERR(1, 8)
#define DOS_ERRbadmem               SMB_DOSERR(1, 9)
#define DOS_ERRbadenv               SMB_DOSERR(1, 10)
#define DOS_ERRbadformat            SMB_DOSERR(1, 11)
#define DOS_ERRbadaccess            SMB_DOSERR(1, 12)
#define DOS_ERRbaddata              SMB_DOSERR(1, 13)
#define DOS_ERRbaddrive             SMB_DOSERR(1, 15)
#define DOS_ERRremcd                SMB_DOSERR(1, 16)
#define DOS_ERRdiffdevice           SMB_DOSERR(1, 17)
#define DOS_ERRnofiles              SMB_DOSERR(1, 18)
#define DOS_ERRbadshare             SMB_DOSERR(1, 32)
#define DOS_ERRlock                 SMB_DOSERR(1, 33)
#define DOS_ERRdontsupportipc       SMB_DOSERR(1, 66)
#define DOS_ERRnoshare              SMB_DOSERR(1, 67)
#define DOS_ERRfileexists           SMB_DOSERR(1, 80)
#define DOS_ERRbaddirectory         SMB_DOSERR(1, 87)
#define DOS_ERRinsufficientbuffer   SMB_DOSERR(1, 122)
#define DOS_ERRinvalidname          SMB_DOSERR(1, 123)
#define DOS_ERRdirnotempty          SMB_DOSERR(1, 145)
#define DOS_ERRalreadyexists        SMB_DOSERR(1, 183)
#define DOS_ERRbadpipe              SMB_DOSERR(1, 230)
#define DOS_ERRpipebusy             SMB_DOSERR(1, 231)
#define DOS_ERRpipeclosing          SMB_DOSERR(1, 232)
#define DOS_ERRnotconnected         SMB_DOSERR(1, 233)
#define DOS_ERRmoredata             SMB_DOSERR(1, 234)

#ifndef IS_SRV_ERROR
#define IS_SRV_ERROR(err) ((err & CLASS_ERR_MODULE(2)) == CLASS_ERR_MODULE(2))
#endif

#define SRV_ERRerror                SMB_DOSERR(2, 1)
#define SRV_ERRbadpw                SMB_DOSERR(2, 2)
#define SRV_ERRaccess               SMB_DOSERR(2, 4)
#define SRV_ERRinvtid               SMB_DOSERR(2, 5)
#define SRV_ERRinvnetname           SMB_DOSERR(2, 6)
#define SRV_ERRinvdevice            SMB_DOSERR(2, 7)
#define SRV_ERRqfull                SMB_DOSERR(2, 49)
#define SRV_ERRqtoobig              SMB_DOSERR(2, 50)
#define SRV_ERRqeof                 SMB_DOSERR(2, 51)
#define SRV_ERRinvfid               SMB_DOSERR(2, 52)
#define SRV_ERRsmbcmd               SMB_DOSERR(2, 64)
#define SRV_ERRsrverror             SMB_DOSERR(2, 65)
#define SRV_ERRfilespecs            SMB_DOSERR(2, 67)
#define SRV_ERRbadpermits           SMB_DOSERR(2, 69)
#define SRV_ERRsetattrmode          SMB_DOSERR(2, 71)
#define SRV_ERRpaused               SMB_DOSERR(2, 81)
#define SRV_ERRmsgoff               SMB_DOSERR(2, 82)
#define SRV_ERRnoroom               SMB_DOSERR(2, 83)
#define SRV_ERRrmuns                SMB_DOSERR(2, 87)
#define SRV_ERRtimeout              SMB_DOSERR(2, 88)
#define SRV_ERRnoresource           SMB_DOSERR(2, 89)
#define SRV_ERRtoomanyuids          SMB_DOSERR(2, 90)
#define SRV_ERRinvuid               SMB_DOSERR(2, 91)
#define SRV_ERRusempx               SMB_DOSERR(2, 250)
#define SRV_ERRusestd               SMB_DOSERR(2, 251)
#define SRV_ERRcontmpx              SMB_DOSERR(2, 252)
#define SRV_ERRnosupport            SMB_DOSERR(2, 65535)

#ifndef IS_HRD_ERROR
#define IS_HRD_ERROR(err) ((err & CLASS_ERR_MODULE(3)) == CLASS_ERR_MODULE(3))
#endif

#define HRD_ERRnowrite              SMB_DOSERR(3, 19)
#define HRD_ERRbadunit              SMB_DOSERR(3, 20)
#define HRD_ERRnotready             SMB_DOSERR(3, 21)
#define HRD_ERRbadcmd               SMB_DOSERR(3, 22)
#define HRD_ERRdata                 SMB_DOSERR(3, 23)
#define HRD_ERRbadreq               SMB_DOSERR(3, 24)
#define HRD_ERRseek                 SMB_DOSERR(3, 25)
#define HRD_ERRbadmedia             SMB_DOSERR(3, 26)
#define HRD_ERRbadsector            SMB_DOSERR(3, 27)
#define HRD_ERRnopaper              SMB_DOSERR(3, 28)
#define HRD_ERRwrite                SMB_DOSERR(3, 29)
#define HRD_ERRread                 SMB_DOSERR(3, 30)
#define HRD_ERRgeneral              SMB_DOSERR(3, 31)
#define HRD_ERRbadshare             SMB_DOSERR(3, 32)
#define HRD_ERRlock                 SMB_DOSERR(3, 33)
#define HRD_ERRwrongdisk            SMB_DOSERR(3, 34)
#define HRD_ERRFCBUnavail           SMB_DOSERR(3, 35)
#define HRD_ERRsharebufexc          SMB_DOSERR(3, 36)
#define HRD_ERRdiskfull             SMB_DOSERR(3, 39)

/** @} end of group SMB_errors SMB Errors*/

/* SMB Error Codes */

/** @defgroup SMB_error_code SMB Error Codes
 * @ingroup udapi
 * @{ */
#define SMB_STATUS_OK                                   0xc0000000
#define SMB_STATUS_INVALID                              0xffffffff

#define SMB_STATUS_SUCCESS                              0x00000000
#define SMB_STATUS_ENUMDIR                              0x0000010c
#define SMB_STATUS_PENDING                              0x00000103
#define SMB_STATUS_MORE_ENTRIES                         0x00000105
#define SMB_STATUS_SOME_UNMAPPED                        0x00000107
#define SMB_STATUS_NOTIFY_CLEANUP                       0x0000010b
#define SMB_STATUS_INSUFFICIENT_BUFFER                  0x0000007a
#define SMB_STATUS_UNKNOWN_PRINTER_DRIVER               0x00000705
#define SMB_STATUS_INVALID_DATATYPE                     0x0000070c

#define SMB_STATUS_BUFFER_OVERFLOW                      0x80000005
#define SMB_STATUS_NO_MORE_FILES                        0x80000006
#define SMB_STATUS_DEVICE_OFF_LINE                      0x80000010
#define SMB_STATUS_NO_MORE_ENTRIES                      0x8000001a
#define SMB_STATUS_STOPPED_ON_SYMLINK                   0x8000002D

#define SMB_STATUS_UNSUCCESSFUL                         0xc0000001
#define SMB_STATUS_NOT_IMPLEMENTED                      0xc0000002
#define SMB_STATUS_INVALID_INFO_CLASS                   0xc0000003
#define SMB_STATUS_INFO_LENGTH_MISMATCH                 0xc0000004
#define SMB_STATUS_ACCESS_VIOLATION                     0xc0000005
#define SMB_STATUS_IN_PAGE_ERROR                        0xc0000006
#define SMB_STATUS_PAGEFILE_QUOTA                       0xc0000007
#define SMB_STATUS_INVALID_HANDLE                       0xc0000008
#define SMB_STATUS_BAD_INITIAL_STACK                    0xc0000009
#define SMB_STATUS_BAD_INITIAL_PC                       0xc000000a
#define SMB_STATUS_INVALID_CID                          0xc000000b
#define SMB_STATUS_TIMER_NOT_CANCELED                   0xc000000c
#define SMB_STATUS_INVALID_PARAMETER                    0xc000000d
#define SMB_STATUS_NO_SUCH_DEVICE                       0xc000000e
#define SMB_STATUS_NO_SUCH_FILE                         0xc000000f
#define SMB_STATUS_INVALID_DEVICE_REQUEST               0xc0000010
#define SMB_STATUS_END_OF_FILE                          0xc0000011
#define SMB_STATUS_WRONG_VOLUME                         0xc0000012
#define SMB_STATUS_NO_MEDIA_IN_DEVICE                   0xc0000013
#define SMB_STATUS_UNRECOGNIZED_MEDIA                   0xc0000014
#define SMB_STATUS_NONEXISTENT_SECTOR                   0xc0000015
#define SMB_STATUS_MORE_PROCESSING_REQUIRED             0xc0000016
#define SMB_STATUS_NO_MEMORY                            0xc0000017
#define SMB_STATUS_CONFLICTING_ADDRESSES                0xc0000018
#define SMB_STATUS_NOT_MAPPED_VIEW                      0xc0000019
#define SMB_STATUS_UNABLE_TO_FREE_VM                    0xc000001a
#define SMB_STATUS_UNABLE_TO_DELETE_SECTION             0xc000001b
#define SMB_STATUS_INVALID_SYSTEM_SERVICE               0xc000001c
#define SMB_STATUS_ILLEGAL_INSTRUCTION                  0xc000001d
#define SMB_STATUS_INVALID_LOCK_SEQUENCE                0xc000001e
#define SMB_STATUS_INVALID_VIEW_SIZE                    0xc000001f
#define SMB_STATUS_INVALID_FILE_FOR_SECTION             0xc0000020
#define SMB_STATUS_ALREADY_COMMITTED                    0xc0000021
#define SMB_STATUS_ACCESS_DENIED                        0xc0000022
#define SMB_STATUS_BUFFER_TOO_SMALL                     0xc0000023
#define SMB_STATUS_OBJECT_TYPE_MISMATCH                 0xc0000024
#define SMB_STATUS_NONCONTINUABLE_EXCEPTION             0xc0000025
#define SMB_STATUS_INVALID_DISPOSITION                  0xc0000026
#define SMB_STATUS_UNWIND                               0xc0000027
#define SMB_STATUS_BAD_STACK                            0xc0000028
#define SMB_STATUS_INVALID_UNWIND_TARGET                0xc0000029
#define SMB_STATUS_NOT_LOCKED                           0xc000002a
#define SMB_STATUS_PARITY_ERROR                         0xc000002b
#define SMB_STATUS_UNABLE_TO_DECOMMIT_VM                0xc000002c
#define SMB_STATUS_NOT_COMMITTED                        0xc000002d
#define SMB_STATUS_INVALID_PORT_ATTRIBUTES              0xc000002e
#define SMB_STATUS_PORT_MESSAGE_TOO_LONG                0xc000002f
#define SMB_STATUS_INVALID_PARAMETER_MIX                0xc0000030
#define SMB_STATUS_INVALID_QUOTA_LOWER                  0xc0000031
#define SMB_STATUS_DISK_CORRUPT_ERROR                   0xc0000032
#define SMB_STATUS_OBJECT_NAME_INVALID                  0xc0000033
#define SMB_STATUS_OBJECT_NAME_NOT_FOUND                0xc0000034
#define SMB_STATUS_OBJECT_NAME_COLLISION                0xc0000035
#define SMB_STATUS_HANDLE_NOT_WAITABLE                  0xc0000036
#define SMB_STATUS_PORT_DISCONNECTED                    0xc0000037
#define SMB_STATUS_DEVICE_ALREADY_ATTACHED              0xc0000038
#define SMB_STATUS_OBJECT_PATH_INVALID                  0xc0000039
#define SMB_STATUS_OBJECT_PATH_NOT_FOUND                0xc000003a
#define SMB_STATUS_OBJECT_PATH_SYNTAX_BAD               0xc000003b
#define SMB_STATUS_DATA_OVERRUN                         0xc000003c
#define SMB_STATUS_DATA_LATE_ERROR                      0xc000003d
#define SMB_STATUS_DATA_ERROR                           0xc000003e
#define SMB_STATUS_CRC_ERROR                            0xc000003f
#define SMB_STATUS_SECTION_TOO_BIG                      0xc0000040
#define SMB_STATUS_PORT_CONNECTION_REFUSED              0xc0000041
#define SMB_STATUS_INVALID_PORT_HANDLE                  0xc0000042
#define SMB_STATUS_SHARING_VIOLATION                    0xc0000043
#define SMB_STATUS_QUOTA_EXCEEDED                       0xc0000044
#define SMB_STATUS_INVALID_PAGE_PROTECTION              0xc0000045
#define SMB_STATUS_MUTANT_NOT_OWNED                     0xc0000046
#define SMB_STATUS_SEMAPHORE_LIMIT_EXCEEDED             0xc0000047
#define SMB_STATUS_PORT_ALREADY_SET                     0xc0000048
#define SMB_STATUS_SECTION_NOT_IMAGE                    0xc0000049
#define SMB_STATUS_SUSPEND_COUNT_EXCEEDED               0xc000004a
#define SMB_STATUS_THREAD_IS_TERMINATING                0xc000004b
#define SMB_STATUS_BAD_WORKING_SET_LIMIT                0xc000004c
#define SMB_STATUS_INCOMPATIBLE_FILE_MAP                0xc000004d
#define SMB_STATUS_SECTION_PROTECTION                   0xc000004e
#define SMB_STATUS_EAS_NOT_SUPPORTED                    0xc000004f
#define SMB_STATUS_EA_TOO_LARGE                         0xc0000050
#define SMB_STATUS_NONEXISTENT_EA_ENTRY                 0xc0000051
#define SMB_STATUS_NO_EAS_ON_FILE                       0xc0000052
#define SMB_STATUS_EA_CORRUPT_ERROR                     0xc0000053
#define SMB_STATUS_FILE_LOCK_CONFLICT                   0xc0000054
#define SMB_STATUS_LOCK_NOT_GRANTED                     0xc0000055
#define SMB_STATUS_DELETE_PENDING                       0xc0000056
#define SMB_STATUS_CTL_FILE_NOT_SUPPORTED               0xc0000057
#define SMB_STATUS_UNKNOWN_REVISION                     0xc0000058
#define SMB_STATUS_REVISION_MISMATCH                    0xc0000059
#define SMB_STATUS_INVALID_OWNER                        0xc000005a
#define SMB_STATUS_INVALID_PRIMARY_GROUP                0xc000005b
#define SMB_STATUS_NO_IMPERSONATION_TOKEN               0xc000005c
#define SMB_STATUS_CANT_DISABLE_MANDATORY               0xc000005d
#define SMB_STATUS_NO_LOGON_SERVERS                     0xc000005e
#define SMB_STATUS_NO_SUCH_LOGON_SESSION                0xc000005f
#define SMB_STATUS_NO_SUCH_PRIVILEGE                    0xc0000060
#define SMB_STATUS_PRIVILEGE_NOT_HELD                   0xc0000061
#define SMB_STATUS_INVALID_ACCOUNT_NAME                 0xc0000062
#define SMB_STATUS_USER_EXISTS                          0xc0000063
#define SMB_STATUS_NO_SUCH_USER                         0xc0000064
#define SMB_STATUS_GROUP_EXISTS                         0xc0000065
#define SMB_STATUS_NO_SUCH_GROUP                        0xc0000066
#define SMB_STATUS_MEMBER_IN_GROUP                      0xc0000067
#define SMB_STATUS_MEMBER_NOT_IN_GROUP                  0xc0000068
#define SMB_STATUS_LAST_ADMIN                           0xc0000069
#define SMB_STATUS_WRONG_PASSWORD                       0xc000006a
#define SMB_STATUS_ILL_FORMED_PASSWORD                  0xc000006b
#define SMB_STATUS_PASSWORD_RESTRICTION                 0xc000006c
#define SMB_STATUS_LOGON_FAILURE                        0xc000006d
#define SMB_STATUS_ACCOUNT_RESTRICTION                  0xc000006e
#define SMB_STATUS_INVALID_LOGON_HOURS                  0xc000006f
#define SMB_STATUS_INVALID_WORKSTATION                  0xc0000070
#define SMB_STATUS_PASSWORD_EXPIRED                     0xc0000071
#define SMB_STATUS_ACCOUNT_DISABLED                     0xc0000072
#define SMB_STATUS_NONE_MAPPED                          0xc0000073
#define SMB_STATUS_TOO_MANY_LUIDS_REQUESTED             0xc0000074
#define SMB_STATUS_LUIDS_EXHAUSTED                      0xc0000075
#define SMB_STATUS_INVALID_SUB_AUTHORITY                0xc0000076
#define SMB_STATUS_INVALID_ACL                          0xc0000077
#define SMB_STATUS_INVALID_SID                          0xc0000078
#define SMB_STATUS_INVALID_SECURITY_DESCR               0xc0000079
#define SMB_STATUS_PROCEDURE_NOT_FOUND                  0xc000007a
#define SMB_STATUS_INVALID_IMAGE_FORMAT                 0xc000007b
#define SMB_STATUS_NO_TOKEN                             0xc000007c
#define SMB_STATUS_BAD_INHERITANCE_ACL                  0xc000007d
#define SMB_STATUS_RANGE_NOT_LOCKED                     0xc000007e
#define SMB_STATUS_DISK_FULL                            0xc000007f
#define SMB_STATUS_SERVER_DISABLED                      0xc0000080
#define SMB_STATUS_SERVER_NOT_DISABLED                  0xc0000081
#define SMB_STATUS_TOO_MANY_GUIDS_REQUESTED             0xc0000082
#define SMB_STATUS_GUIDS_EXHAUSTED                      0xc0000083
#define SMB_STATUS_INVALID_ID_AUTHORITY                 0xc0000084
#define SMB_STATUS_AGENTS_EXHAUSTED                     0xc0000085
#define SMB_STATUS_INVALID_VOLUME_LABEL                 0xc0000086
#define SMB_STATUS_SECTION_NOT_EXTENDED                 0xc0000087
#define SMB_STATUS_NOT_MAPPED_DATA                      0xc0000088
#define SMB_STATUS_RESOURCE_DATA_NOT_FOUND              0xc0000089
#define SMB_STATUS_RESOURCE_TYPE_NOT_FOUND              0xc000008a
#define SMB_STATUS_RESOURCE_NAME_NOT_FOUND              0xc000008b
#define SMB_STATUS_ARRAY_BOUNDS_EXCEEDED                0xc000008c
#define SMB_STATUS_FLOAT_DENORMAL_OPERAND               0xc000008d
#define SMB_STATUS_FLOAT_DIVIDE_BY_ZERO                 0xc000008e
#define SMB_STATUS_FLOAT_INEXACT_RESULT                 0xc000008f
#define SMB_STATUS_FLOAT_INVALID_OPERATION              0xc0000090
#define SMB_STATUS_FLOAT_OVERFLOW                       0xc0000091
#define SMB_STATUS_FLOAT_STACK_CHECK                    0xc0000092
#define SMB_STATUS_FLOAT_UNDERFLOW                      0xc0000093
#define SMB_STATUS_INTEGER_DIVIDE_BY_ZERO               0xc0000094
#define SMB_STATUS_INTEGER_OVERFLOW                     0xc0000095
#define SMB_STATUS_PRIVILEGED_INSTRUCTION               0xc0000096
#define SMB_STATUS_TOO_MANY_PAGING_FILES                0xc0000097
#define SMB_STATUS_FILE_INVALID                         0xc0000098
#define SMB_STATUS_ALLOTTED_SPACE_EXCEEDED              0xc0000099
#define SMB_STATUS_INSUFFICIENT_RESOURCES               0xc000009a
#define SMB_STATUS_DFS_EXIT_PATH_FOUND                  0xc000009b
#define SMB_STATUS_DEVICE_DATA_ERROR                    0xc000009c
#define SMB_STATUS_DEVICE_NOT_CONNECTED                 0xc000009d
#define SMB_STATUS_DEVICE_POWER_FAILURE                 0xc000009e
#define SMB_STATUS_FREE_VM_NOT_AT_BASE                  0xc000009f
#define SMB_STATUS_MEMORY_NOT_ALLOCATED                 0xc00000a0
#define SMB_STATUS_WORKING_SET_QUOTA                    0xc00000a1
#define SMB_STATUS_MEDIA_WRITE_PROTECTED                0xc00000a2
#define SMB_STATUS_DEVICE_NOT_READY                     0xc00000a3
#define SMB_STATUS_INVALID_GROUP_ATTRIBUTES             0xc00000a4
#define SMB_STATUS_BAD_IMPERSONATION_LEVEL              0xc00000a5
#define SMB_STATUS_CANT_OPEN_ANONYMOUS                  0xc00000a6
#define SMB_STATUS_BAD_VALIDATION_CLASS                 0xc00000a7
#define SMB_STATUS_BAD_TOKEN_TYPE                       0xc00000a8
#define SMB_STATUS_BAD_MASTER_BOOT_RECORD               0xc00000a9
#define SMB_STATUS_INSTRUCTION_MISALIGNMENT             0xc00000aa
#define SMB_STATUS_INSTANCE_NOT_AVAILABLE               0xc00000ab
#define SMB_STATUS_PIPE_NOT_AVAILABLE                   0xc00000ac
#define SMB_STATUS_INVALID_PIPE_STATE                   0xc00000ad
#define SMB_STATUS_PIPE_BUSY                            0xc00000ae
#define SMB_STATUS_ILLEGAL_FUNCTION                     0xc00000af
#define SMB_STATUS_PIPE_DISCONNECTED                    0xc00000b0
#define SMB_STATUS_PIPE_CLOSING                         0xc00000b1
#define SMB_STATUS_PIPE_CONNECTED                       0xc00000b2
#define SMB_STATUS_PIPE_LISTENING                       0xc00000b3
#define SMB_STATUS_INVALID_READ_MODE                    0xc00000b4
#define SMB_STATUS_IO_TIMEOUT                           0xc00000b5
#define SMB_STATUS_FILE_FORCED_CLOSED                   0xc00000b6
#define SMB_STATUS_PROFILING_NOT_STARTED                0xc00000b7
#define SMB_STATUS_PROFILING_NOT_STOPPED                0xc00000b8
#define SMB_STATUS_COULD_NOT_INTERPRET                  0xc00000b9
#define SMB_STATUS_FILE_IS_A_DIRECTORY                  0xc00000ba
#define SMB_STATUS_NOT_SUPPORTED                        0xc00000bb
#define SMB_STATUS_REMOTE_NOT_LISTENING                 0xc00000bc
#define SMB_STATUS_DUPLICATE_NAME                       0xc00000bd
#define SMB_STATUS_BAD_NETWORK_PATH                     0xc00000be
#define SMB_STATUS_NETWORK_BUSY                         0xc00000bf
#define SMB_STATUS_DEVICE_DOES_NOT_EXIST                0xc00000c0
#define SMB_STATUS_TOO_MANY_COMMANDS                    0xc00000c1
#define SMB_STATUS_ADAPTER_HARDWARE_ERROR               0xc00000c2
#define SMB_STATUS_INVALID_NETWORK_RESPONSE             0xc00000c3
#define SMB_STATUS_UNEXPECTED_NETWORK_ERROR             0xc00000c4
#define SMB_STATUS_BAD_REMOTE_ADAPTER                   0xc00000c5
#define SMB_STATUS_PRINT_QUEUE_FULL                     0xc00000c6
#define SMB_STATUS_NO_SPOOL_SPACE                       0xc00000c7
#define SMB_STATUS_PRINT_CANCELLED                      0xc00000c8
#define SMB_STATUS_NETWORK_NAME_DELETED                 0xc00000c9
#define SMB_STATUS_NETWORK_ACCESS_DENIED                0xc00000ca
#define SMB_STATUS_BAD_DEVICE_TYPE                      0xc00000cb
#define SMB_STATUS_BAD_NETWORK_NAME                     0xc00000cc
#define SMB_STATUS_TOO_MANY_NAMES                       0xc00000cd
#define SMB_STATUS_TOO_MANY_SESSIONS                    0xc00000ce
#define SMB_STATUS_SHARING_PAUSED                       0xc00000cf
#define SMB_STATUS_REQUEST_NOT_ACCEPTED                 0xc00000d0
#define SMB_STATUS_REDIRECTOR_PAUSED                    0xc00000d1
#define SMB_STATUS_NET_WRITE_FAULT                      0xc00000d2
#define SMB_STATUS_PROFILING_AT_LIMIT                   0xc00000d3
#define SMB_STATUS_NOT_SAME_DEVICE                      0xc00000d4
#define SMB_STATUS_FILE_RENAMED                         0xc00000d5
#define SMB_STATUS_VIRTUAL_CIRCUIT_CLOSED               0xc00000d6
#define SMB_STATUS_NO_SECURITY_ON_OBJECT                0xc00000d7
#define SMB_STATUS_CANT_WAIT                            0xc00000d8
#define SMB_STATUS_PIPE_EMPTY                           0xc00000d9
#define SMB_STATUS_CANT_ACCESS_DOMAIN_INFO              0xc00000da
#define SMB_STATUS_CANT_TERMINATE_SELF                  0xc00000db
#define SMB_STATUS_INVALID_SERVER_STATE                 0xc00000dc
#define SMB_STATUS_INVALID_DOMAIN_STATE                 0xc00000dd
#define SMB_STATUS_INVALID_DOMAIN_ROLE                  0xc00000de
#define SMB_STATUS_NO_SUCH_DOMAIN                       0xc00000df
#define SMB_STATUS_DOMAIN_EXISTS                        0xc00000e0
#define SMB_STATUS_DOMAIN_LIMIT_EXCEEDED                0xc00000e1
#define SMB_STATUS_OPLOCK_NOT_GRANTED                   0xc00000e2
#define SMB_STATUS_INVALID_OPLOCK_PROTOCOL              0xc00000e3
#define SMB_STATUS_INTERNAL_DB_CORRUPTION               0xc00000e4
#define SMB_STATUS_INTERNAL_ERROR                       0xc00000e5
#define SMB_STATUS_GENERIC_NOT_MAPPED                   0xc00000e6
#define SMB_STATUS_BAD_DESCRIPTOR_FORMAT                0xc00000e7
#define SMB_STATUS_INVALID_USER_BUFFER                  0xc00000e8
#define SMB_STATUS_UNEXPECTED_IO_ERROR                  0xc00000e9
#define SMB_STATUS_UNEXPECTED_MM_CREATE_ERR             0xc00000ea
#define SMB_STATUS_UNEXPECTED_MM_MAP_ERROR              0xc00000eb
#define SMB_STATUS_UNEXPECTED_MM_EXTEND_ERR             0xc00000ec
#define SMB_STATUS_NOT_LOGON_PROCESS                    0xc00000ed
#define SMB_STATUS_LOGON_SESSION_EXISTS                 0xc00000ee
#define SMB_STATUS_INVALID_PARAMETER_1                  0xc00000ef
#define SMB_STATUS_INVALID_PARAMETER_2                  0xc00000f0
#define SMB_STATUS_INVALID_PARAMETER_3                  0xc00000f1
#define SMB_STATUS_INVALID_PARAMETER_4                  0xc00000f2
#define SMB_STATUS_INVALID_PARAMETER_5                  0xc00000f3
#define SMB_STATUS_INVALID_PARAMETER_6                  0xc00000f4
#define SMB_STATUS_INVALID_PARAMETER_7                  0xc00000f5
#define SMB_STATUS_INVALID_PARAMETER_8                  0xc00000f6
#define SMB_STATUS_INVALID_PARAMETER_9                  0xc00000f7
#define SMB_STATUS_INVALID_PARAMETER_10                 0xc00000f8
#define SMB_STATUS_INVALID_PARAMETER_11                 0xc00000f9
#define SMB_STATUS_INVALID_PARAMETER_12                 0xc00000fa
#define SMB_STATUS_REDIRECTOR_NOT_STARTED               0xc00000fb
#define SMB_STATUS_REDIRECTOR_STARTED                   0xc00000fc
#define SMB_STATUS_STACK_OVERFLOW                       0xc00000fd
#define SMB_STATUS_NO_SUCH_PACKAGE                      0xc00000fe
#define SMB_STATUS_BAD_FUNCTION_TABLE                   0xc00000ff
#define SMB_STATUS_DIRECTORY_NOT_EMPTY                  0xc0000101
#define SMB_STATUS_FILE_CORRUPT_ERROR                   0xc0000102
#define SMB_STATUS_NOT_A_DIRECTORY                      0xc0000103
#define SMB_STATUS_BAD_LOGON_SESSION_STATE              0xc0000104
#define SMB_STATUS_LOGON_SESSION_COLLISION              0xc0000105
#define SMB_STATUS_NAME_TOO_LONG                        0xc0000106
#define SMB_STATUS_FILES_OPEN                           0xc0000107
#define SMB_STATUS_CONNECTION_IN_USE                    0xc0000108
#define SMB_STATUS_MESSAGE_NOT_FOUND                    0xc0000109
#define SMB_STATUS_PROCESS_IS_TERMINATING               0xc000010a
#define SMB_STATUS_INVALID_LOGON_TYPE                   0xc000010b
#define SMB_STATUS_NO_GUID_TRANSLATION                  0xc000010c
#define SMB_STATUS_CANNOT_IMPERSONATE                   0xc000010d
#define SMB_STATUS_IMAGE_ALREADY_LOADED                 0xc000010e
#define SMB_STATUS_ABIOS_NOT_PRESENT                    0xc000010f
#define SMB_STATUS_ABIOS_LID_NOT_EXIST                  0xc0000110
#define SMB_STATUS_ABIOS_LID_ALREADY_OWNED              0xc0000111
#define SMB_STATUS_ABIOS_NOT_LID_OWNER                  0xc0000112
#define SMB_STATUS_ABIOS_INVALID_COMMAND                0xc0000113
#define SMB_STATUS_ABIOS_INVALID_LID                    0xc0000114
#define SMB_STATUS_ABIOS_SELECTOR_NOT_AVAILABLE         0xc0000115
#define SMB_STATUS_ABIOS_INVALID_SELECTOR               0xc0000116
#define SMB_STATUS_NO_LDT                               0xc0000117
#define SMB_STATUS_INVALID_LDT_SIZE                     0xc0000118
#define SMB_STATUS_INVALID_LDT_OFFSET                   0xc0000119
#define SMB_STATUS_INVALID_LDT_DESCRIPTOR               0xc000011a
#define SMB_STATUS_INVALID_IMAGE_NE_FORMAT              0xc000011b
#define SMB_STATUS_RXACT_INVALID_STATE                  0xc000011c
#define SMB_STATUS_RXACT_COMMIT_FAILURE                 0xc000011d
#define SMB_STATUS_MAPPED_FILE_SIZE_ZERO                0xc000011e
#define SMB_STATUS_TOO_MANY_OPENED_FILES                0xc000011f
#define SMB_STATUS_CANCELLED                            0xc0000120
#define SMB_STATUS_CANNOT_DELETE                        0xc0000121
#define SMB_STATUS_INVALID_COMPUTER_NAME                0xc0000122
#define SMB_STATUS_FILE_DELETED                         0xc0000123
#define SMB_STATUS_SPECIAL_ACCOUNT                      0xc0000124
#define SMB_STATUS_SPECIAL_GROUP                        0xc0000125
#define SMB_STATUS_SPECIAL_USER                         0xc0000126
#define SMB_STATUS_MEMBERS_PRIMARY_GROUP                0xc0000127
#define SMB_STATUS_FILE_CLOSED                          0xc0000128
#define SMB_STATUS_TOO_MANY_THREADS                     0xc0000129
#define SMB_STATUS_THREAD_NOT_IN_PROCESS                0xc000012a
#define SMB_STATUS_TOKEN_ALREADY_IN_USE                 0xc000012b
#define SMB_STATUS_PAGEFILE_QUOTA_EXCEEDED              0xc000012c
#define SMB_STATUS_COMMITMENT_LIMIT                     0xc000012d
#define SMB_STATUS_INVALID_IMAGE_LE_FORMAT              0xc000012e
#define SMB_STATUS_INVALID_IMAGE_NOT_MZ                 0xc000012f
#define SMB_STATUS_INVALID_IMAGE_PROTECT                0xc0000130
#define SMB_STATUS_INVALID_IMAGE_WIN_16                 0xc0000131
#define SMB_STATUS_LOGON_SERVER_CONFLICT                0xc0000132
#define SMB_STATUS_TIME_DIFFERENCE_AT_DC                0xc0000133
#define SMB_STATUS_SYNCHRONIZATION_REQUIRED             0xc0000134
#define SMB_STATUS_DLL_NOT_FOUND                        0xc0000135
#define SMB_STATUS_OPEN_FAILED                          0xc0000136
#define SMB_STATUS_IO_PRIVILEGE_FAILED                  0xc0000137
#define SMB_STATUS_ORDINAL_NOT_FOUND                    0xc0000138
#define SMB_STATUS_ENTRYPOINT_NOT_FOUND                 0xc0000139
#define SMB_STATUS_CONTROL_C_EXIT                       0xc000013a
#define SMB_STATUS_LOCAL_DISCONNECT                     0xc000013b
#define SMB_STATUS_REMOTE_DISCONNECT                    0xc000013c
#define SMB_STATUS_REMOTE_RESOURCES                     0xc000013d
#define SMB_STATUS_LINK_FAILED                          0xc000013e
#define SMB_STATUS_LINK_TIMEOUT                         0xc000013f
#define SMB_STATUS_INVALID_CONNECTION                   0xc0000140
#define SMB_STATUS_INVALID_ADDRESS                      0xc0000141
#define SMB_STATUS_DLL_INIT_FAILED                      0xc0000142
#define SMB_STATUS_MISSING_SYSTEMFILE                   0xc0000143
#define SMB_STATUS_UNHANDLED_EXCEPTION                  0xc0000144
#define SMB_STATUS_APP_INIT_FAILURE                     0xc0000145
#define SMB_STATUS_PAGEFILE_CREATE_FAILED               0xc0000146
#define SMB_STATUS_NO_PAGEFILE                          0xc0000147
#define SMB_STATUS_INVALID_LEVEL                        0xc0000148
#define SMB_STATUS_WRONG_PASSWORD_CORE                  0xc0000149
#define SMB_STATUS_ILLEGAL_FLOAT_CONTEXT                0xc000014a
#define SMB_STATUS_PIPE_BROKEN                          0xc000014b
#define SMB_STATUS_REGISTRY_CORRUPT                     0xc000014c
#define SMB_STATUS_REGISTRY_IO_FAILED                   0xc000014d
#define SMB_STATUS_NO_EVENT_PAIR                        0xc000014e
#define SMB_STATUS_UNRECOGNIZED_VOLUME                  0xc000014f
#define SMB_STATUS_SERIAL_NO_DEVICE_INITED              0xc0000150
#define SMB_STATUS_NO_SUCH_ALIAS                        0xc0000151
#define SMB_STATUS_MEMBER_NOT_IN_ALIAS                  0xc0000152
#define SMB_STATUS_MEMBER_IN_ALIAS                      0xc0000153
#define SMB_STATUS_ALIAS_EXISTS                         0xc0000154
#define SMB_STATUS_LOGON_NOT_GRANTED                    0xc0000155
#define SMB_STATUS_TOO_MANY_SECRETS                     0xc0000156
#define SMB_STATUS_SECRET_TOO_LONG                      0xc0000157
#define SMB_STATUS_INTERNAL_DB_ERROR                    0xc0000158
#define SMB_STATUS_FULLSCREEN_MODE                      0xc0000159
#define SMB_STATUS_TOO_MANY_CONTEXT_IDS                 0xc000015a
#define SMB_STATUS_LOGON_TYPE_NOT_GRANTED               0xc000015b
#define SMB_STATUS_NOT_REGISTRY_FILE                    0xc000015c
#define SMB_STATUS_NT_CROSS_ENCRYPTION_REQUIRED         0xc000015d
#define SMB_STATUS_DOMAIN_CTRLR_CONFIG_ERROR            0xc000015e
#define SMB_STATUS_FT_MISSING_MEMBER                    0xc000015f
#define SMB_STATUS_ILL_FORMED_SERVICE_ENTRY             0xc0000160
#define SMB_STATUS_ILLEGAL_CHARACTER                    0xc0000161
#define SMB_STATUS_UNMAPPABLE_CHARACTER                 0xc0000162
#define SMB_STATUS_UNDEFINED_CHARACTER                  0xc0000163
#define SMB_STATUS_FLOPPY_VOLUME                        0xc0000164
#define SMB_STATUS_FLOPPY_ID_MARK_NOT_FOUND             0xc0000165
#define SMB_STATUS_FLOPPY_WRONG_CYLINDER                0xc0000166
#define SMB_STATUS_FLOPPY_UNKNOWN_ERROR                 0xc0000167
#define SMB_STATUS_FLOPPY_BAD_REGISTERS                 0xc0000168
#define SMB_STATUS_DISK_RECALIBRATE_FAILED              0xc0000169
#define SMB_STATUS_DISK_OPERATION_FAILED                0xc000016a
#define SMB_STATUS_DISK_RESET_FAILED                    0xc000016b
#define SMB_STATUS_SHARED_IRQ_BUSY                      0xc000016c
#define SMB_STATUS_FT_ORPHANING                         0xc000016d
#define SMB_STATUS_PARTITION_FAILURE                    0xc0000172
#define SMB_STATUS_INVALID_BLOCK_LENGTH                 0xc0000173
#define SMB_STATUS_DEVICE_NOT_PARTITIONED               0xc0000174
#define SMB_STATUS_UNABLE_TO_LOCK_MEDIA                 0xc0000175
#define SMB_STATUS_UNABLE_TO_UNLOAD_MEDIA               0xc0000176
#define SMB_STATUS_EOM_OVERFLOW                         0xc0000177
#define SMB_STATUS_NO_MEDIA                             0xc0000178
#define SMB_STATUS_NO_SUCH_MEMBER                       0xc000017a
#define SMB_STATUS_INVALID_MEMBER                       0xc000017b
#define SMB_STATUS_KEY_DELETED                          0xc000017c
#define SMB_STATUS_NO_LOG_SPACE                         0xc000017d
#define SMB_STATUS_TOO_MANY_SIDS                        0xc000017e
#define SMB_STATUS_LM_CROSS_ENCRYPTION_REQUIRED         0xc000017f
#define SMB_STATUS_KEY_HAS_CHILDREN                     0xc0000180
#define SMB_STATUS_CHILD_MUST_BE_VOLATILE               0xc0000181
#define SMB_STATUS_DEVICE_CONFIGURATION_ERROR           0xc0000182
#define SMB_STATUS_DRIVER_INTERNAL_ERROR                0xc0000183
#define SMB_STATUS_INVALID_DEVICE_STATE                 0xc0000184
#define SMB_STATUS_IO_DEVICE_ERROR                      0xc0000185
#define SMB_STATUS_DEVICE_PROTOCOL_ERROR                0xc0000186
#define SMB_STATUS_BACKUP_CONTROLLER                    0xc0000187
#define SMB_STATUS_LOG_FILE_FULL                        0xc0000188
#define SMB_STATUS_TOO_LATE                             0xc0000189
#define SMB_STATUS_NO_TRUST_LSA_SECRET                  0xc000018a
#define SMB_STATUS_NO_TRUST_SAM_ACCOUNT                 0xc000018b
#define SMB_STATUS_TRUSTED_DOMAIN_FAILURE               0xc000018c
#define SMB_STATUS_TRUSTED_RELATIONSHIP_FAILURE         0xc000018d
#define SMB_STATUS_EVENTLOG_FILE_CORRUPT                0xc000018e
#define SMB_STATUS_EVENTLOG_CANT_START                  0xc000018f
#define SMB_STATUS_TRUST_FAILURE                        0xc0000190
#define SMB_STATUS_MUTANT_LIMIT_EXCEEDED                0xc0000191
#define SMB_STATUS_NETLOGON_NOT_STARTED                 0xc0000192
#define SMB_STATUS_ACCOUNT_EXPIRED                      0xc0000193
#define SMB_STATUS_POSSIBLE_DEADLOCK                    0xc0000194
#define SMB_STATUS_NETWORK_CREDENTIAL_CONFLICT          0xc0000195
#define SMB_STATUS_REMOTE_SESSION_LIMIT                 0xc0000196
#define SMB_STATUS_EVENTLOG_FILE_CHANGED                0xc0000197
#define SMB_STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT    0xc0000198
#define SMB_STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT    0xc0000199
#define SMB_STATUS_NOLOGON_SERVER_TRUST_ACCOUNT         0xc000019a
#define SMB_STATUS_DOMAIN_TRUST_INCONSISTENT            0xc000019b
#define SMB_STATUS_FS_DRIVER_REQUIRED                   0xc000019c
#define SMB_STATUS_INVALID_LOCK_RANGE                   0xc00001a1
#define SMB_STATUS_NO_USER_SESSION_KEY                  0xc0000202
#define SMB_STATUS_USER_SESSION_DELETED                 0xc0000203
#define SMB_STATUS_RESOURCE_LANG_NOT_FOUND              0xc0000204
#define SMB_STATUS_INSUFF_SERVER_RESOURCES              0xc0000205
#define SMB_STATUS_INVALID_BUFFER_SIZE                  0xc0000206
#define SMB_STATUS_INVALID_ADDRESS_COMPONENT            0xc0000207
#define SMB_STATUS_INVALID_ADDRESS_WILDCARD             0xc0000208
#define SMB_STATUS_TOO_MANY_ADDRESSES                   0xc0000209
#define SMB_STATUS_ADDRESS_ALREADY_EXISTS               0xc000020a
#define SMB_STATUS_ADDRESS_CLOSED                       0xc000020b
#define SMB_STATUS_CONNECTION_DISCONNECTED              0xc000020c
#define SMB_STATUS_CONNECTION_RESET                     0xc000020d
#define SMB_STATUS_TOO_MANY_NODES                       0xc000020e
#define SMB_STATUS_TRANSACTION_ABORTED                  0xc000020f
#define SMB_STATUS_TRANSACTION_TIMED_OUT                0xc0000210
#define SMB_STATUS_TRANSACTION_NO_RELEASE               0xc0000211
#define SMB_STATUS_TRANSACTION_NO_MATCH                 0xc0000212
#define SMB_STATUS_TRANSACTION_RESPONDED                0xc0000213
#define SMB_STATUS_TRANSACTION_INVALID_ID               0xc0000214
#define SMB_STATUS_TRANSACTION_INVALID_TYPE             0xc0000215
#define SMB_STATUS_NOT_SERVER_SESSION                   0xc0000216
#define SMB_STATUS_NOT_CLIENT_SESSION                   0xc0000217
#define SMB_STATUS_CANNOT_LOAD_REGISTRY_FILE            0xc0000218
#define SMB_STATUS_DEBUG_ATTACH_FAILED                  0xc0000219
#define SMB_STATUS_SYSTEM_PROCESS_TERMINATED            0xc000021a
#define SMB_STATUS_DATA_NOT_ACCEPTED                    0xc000021b
#define SMB_STATUS_NO_BROWSER_SERVERS_FOUND             0xc000021c
#define SMB_STATUS_VDM_HARD_ERROR                       0xc000021d
#define SMB_STATUS_DRIVER_CANCEL_TIMEOUT                0xc000021e
#define SMB_STATUS_REPLY_MESSAGE_MISMATCH               0xc000021f
#define SMB_STATUS_MAPPED_ALIGNMENT                     0xc0000220
#define SMB_STATUS_IMAGE_CHECKSUM_MISMATCH              0xc0000221
#define SMB_STATUS_LOST_WRITEBEHIND_DATA                0xc0000222
#define SMB_STATUS_CLIENT_SERVER_PARAMETERS_INVALID     0xc0000223
#define SMB_STATUS_PASSWORD_MUST_CHANGE                 0xc0000224
#define SMB_STATUS_NOT_FOUND                            0xc0000225
#define SMB_STATUS_NOT_TINY_STREAM                      0xc0000226
#define SMB_STATUS_RECOVERY_FAILURE                     0xc0000227
#define SMB_STATUS_STACK_OVERFLOW_READ                  0xc0000228
#define SMB_STATUS_FAIL_CHECK                           0xc0000229
#define SMB_STATUS_DUPLICATE_OBJECTID                   0xc000022a
#define SMB_STATUS_OBJECTID_EXISTS                      0xc000022b
#define SMB_STATUS_CONVERT_TO_LARGE                     0xc000022c
#define SMB_STATUS_RETRY                                0xc000022d
#define SMB_STATUS_FOUND_OUT_OF_SCOPE                   0xc000022e
#define SMB_STATUS_ALLOCATE_BUCKET                      0xc000022f
#define SMB_STATUS_PROPSET_NOT_FOUND                    0xc0000230
#define SMB_STATUS_MARSHALL_OVERFLOW                    0xc0000231
#define SMB_STATUS_INVALID_VARIANT                      0xc0000232
#define SMB_STATUS_DOMAIN_CONTROLLER_NOT_FOUND          0xc0000233
#define SMB_STATUS_ACCOUNT_LOCKED_OUT                   0xc0000234
#define SMB_STATUS_HANDLE_NOT_CLOSABLE                  0xc0000235
#define SMB_STATUS_CONNECTION_REFUSED                   0xc0000236
#define SMB_STATUS_GRACEFUL_DISCONNECT                  0xc0000237
#define SMB_STATUS_ADDRESS_ALREADY_ASSOCIATED           0xc0000238
#define SMB_STATUS_ADDRESS_NOT_ASSOCIATED               0xc0000239
#define SMB_STATUS_CONNECTION_INVALID                   0xc000023a
#define SMB_STATUS_CONNECTION_ACTIVE                    0xc000023b
#define SMB_STATUS_NETWORK_UNREACHABLE                  0xc000023c
#define SMB_STATUS_HOST_UNREACHABLE                     0xc000023d
#define SMB_STATUS_PROTOCOL_UNREACHABLE                 0xc000023e
#define SMB_STATUS_PORT_UNREACHABLE                     0xc000023f
#define SMB_STATUS_REQUEST_ABORTED                      0xc0000240
#define SMB_STATUS_CONNECTION_ABORTED                   0xc0000241
#define SMB_STATUS_BAD_COMPRESSION_BUFFER               0xc0000242
#define SMB_STATUS_USER_MAPPED_FILE                     0xc0000243
#define SMB_STATUS_AUDIT_FAILED                         0xc0000244
#define SMB_STATUS_TIMER_RESOLUTION_NOT_SET             0xc0000245
#define SMB_STATUS_CONNECTION_COUNT_LIMIT               0xc0000246
#define SMB_STATUS_LOGIN_TIME_RESTRICTION               0xc0000247
#define SMB_STATUS_LOGIN_WKSTA_RESTRICTION              0xc0000248
#define SMB_STATUS_IMAGE_MP_UP_MISMATCH                 0xc0000249
#define SMB_STATUS_INSUFFICIENT_LOGON_INFO              0xc0000250
#define SMB_STATUS_BAD_DLL_ENTRYPOINT                   0xc0000251
#define SMB_STATUS_BAD_SERVICE_ENTRYPOINT               0xc0000252
#define SMB_STATUS_LPC_REPLY_LOST                       0xc0000253
#define SMB_STATUS_IP_ADDRESS_CONFLICT1                 0xc0000254
#define SMB_STATUS_IP_ADDRESS_CONFLICT2                 0xc0000255
#define SMB_STATUS_REGISTRY_QUOTA_LIMIT                 0xc0000256
#define SMB_STATUS_PATH_NOT_COVERED                     0xc0000257
#define SMB_STATUS_NO_CALLBACK_ACTIVE                   0xc0000258
#define SMB_STATUS_LICENSE_QUOTA_EXCEEDED               0xc0000259
#define SMB_STATUS_PWD_TOO_SHORT                        0xc000025a
#define SMB_STATUS_PWD_TOO_RECENT                       0xc000025b
#define SMB_STATUS_PWD_HISTORY_CONFLICT                 0xc000025c
#define SMB_STATUS_PLUGPLAY_NO_DEVICE                   0xc000025e
#define SMB_STATUS_UNSUPPORTED_COMPRESSION              0xc000025f
#define SMB_STATUS_INVALID_HW_PROFILE                   0xc0000260
#define SMB_STATUS_INVALID_PLUGPLAY_DEVICE_PATH         0xc0000261
#define SMB_STATUS_DRIVER_ORDINAL_NOT_FOUND             0xc0000262
#define SMB_STATUS_DRIVER_ENTRYPOINT_NOT_FOUND          0xc0000263
#define SMB_STATUS_RESOURCE_NOT_OWNED                   0xc0000264
#define SMB_STATUS_TOO_MANY_LINKS                       0xc0000265
#define SMB_STATUS_QUOTA_LIST_INCONSISTENT              0xc0000266
#define SMB_STATUS_FILE_IS_OFFLINE                      0xc0000267
#define SMB_STATUS_DFS_UNAVAILABLE                      0xc000026d
#define SMB_STATUS_VOLUME_DISMOUNTED                    0xC000026e
#define SMB_STATUS_NOT_A_REPARSE_POINT                  0xc0000275
#define SMB_STATUS_IO_REPARSE_TAG_NOT_HANDLED           0xc0000279
#define SMB_STATUS_NETWORK_SESSION_EXPIRED              0xC000035C
#define SMB_STATUS_INVALID_TOKEN                        0xc0000465
#define SMB_STATUS_SERVER_UNAVAILABLE                   0xC0000466
#define SMB_STATUS_FILE_NOT_AVAILABLE                   0xc0000467
#define SMB_STATUS_SHARE_UNAVAILABLE                    0xC0000480
#define SMB_STATUS_NO_SUCH_JOB                          0xc0000ede
#define SMB_STATUS_NO_PREAUTH_INTEGRITY_HASH_OVERLAP    0xC05D0000

/** @} end of group SMB_error_code SMB Error Codes */

/* Custom (internal) NT statuses */

/** @defgroup NT_statuses  Internal NT Statuses
 * @ingroup udapi
 * @{ */
#define SMB_STATUS_DISCONNECT                           0xe0000001
#define SMB_STATUS_INTERNAL_RELEASE_REQUEST_RESPONSE    0xe0000002
#define SMB_STATUS_INTERNAL_BUFFER_TOO_SMALL            0xe0000004
#define SMB_STATUS_DONOTRELEASERESPONSE                 0xe0000005

/** @} end of group NT_statuses  Internal NT Statuses */

/*
    NQ Return codes
    ---------------
 */

/** @defgroup NQ_return NQ Error Codes
 * @ingroup udapi
  @{ */

#define NQ_ERR_MODULE   (NQ_INT)(255u << 24)     /**< This module defines the NQ error subset */
#ifndef IS_NQ_ERROR
#define IS_NQ_ERROR(err) ((err & NQ_ERR_MODULE) == NQ_ERR_MODULE)
#endif
/* *** Errors ****/
#define NQ_ERR_OK               (0)                      /**< Success */
#define NQ_ERR_BADPARAM         (NQ_ERR_MODULE | 3)      /**< Parameter error */
#define NQ_ERR_GETDATA          (NQ_ERR_MODULE | 18)     /**< Error retrieving data */
#define NQ_ERR_INVALIDMODE      (NQ_ERR_MODULE | 19)     /**< Invalid open mode */
#define NQ_ERR_NOSERVERMAC      (NQ_ERR_MODULE | 20)     /**< Server doesn't support MAC signing */
#define NQ_ERR_SIGNATUREFAIL    (NQ_ERR_MODULE | 21)     /**< MAC signature in incoming packet was broken */
#define NQ_ERR_OBJEXISTS        (NQ_ERR_MODULE | 22)     /**< Database object already exists and cannot be created */
#define NQ_ERR_MOUNTERROR       (NQ_ERR_MODULE | 23)     /**< Mount failed for a reason other than authentication */
#define NQ_ERR_UNABLETODISPOSE  (NQ_ERR_MODULE | 24)     /**< Unable to dispose resources */
#define NQ_ERR_INVALIDHANDLE    (NQ_ERR_MODULE | 25)     /**< Invalid handle passed */
#define NQ_ERR_NEGOTIATEFAILED  (NQ_ERR_MODULE | 26)     /**< SMB negotiation failed */
#define NQ_ERR_PATHNOTCOVERED   (NQ_ERR_MODULE | 27)     /**< Path should be resolved over DFS */
#define NQ_ERR_DFSCACHEOVERFLOW (NQ_ERR_MODULE | 28)     /**< DFS cache overflow */
#define NQ_ERR_ACCOUNTLOCKEDOUT (NQ_ERR_MODULE | 29)     /**< Account locked out */
#define NQ_ERR_USEREXISTS       (NQ_ERR_MODULE | 30)     /**< Account already exists */
#define NQ_ERR_USERNOTFOUND     (NQ_ERR_MODULE | 31)     /**< Account name not mapped */
#define NQ_ERR_NOTFOUND         (NQ_ERR_MODULE | 32)     /**< Not found */
#define NQ_ERR_LOGONFAILURE     (NQ_ERR_MODULE | 33)     /**< Logon failure */
#define NQ_ERR_VOLUMEDISMOUNTED (NQ_ERR_MODULE | 34)     /**< Volume not mounted */
#define NQ_ERR_NETWORKERROR     (NQ_ERR_MODULE | 35)     /**< Network error: unreachable, busy, name deleted */
#define NQ_ERR_BADCONNECTION    (NQ_ERR_MODULE | 36)     /**< Connection error: refused, disconnected, reset */
#define NQ_ERR_SHARINGPAUSED    (NQ_ERR_MODULE | 37)     /**< File sharing error: has been temporarily paused */
#define NQ_ERR_BADDFS           (NQ_ERR_MODULE | 38)     /**< DFS error: DFS not available on a server */
#define NQ_ERR_IOTIMEOUT        (NQ_ERR_MODULE | 39)     /**< IO error: time-out period expired */
#define NQ_ERR_TRYAGAIN         (NQ_ERR_MODULE | 40)     /**< Connection changed: possibly reconnect occurred - retry */
#define NQ_ERR_ACCOUNTEXPIRED   (NQ_ERR_MODULE | 41)     /**< Account expired */
#define NQ_ERR_INVALIDLOGONHOURS (NQ_ERR_MODULE | 42)    /**< Invalid logon hours */
#define NQ_ERR_ACCOUNTDISABLED  (NQ_ERR_MODULE | 43)     /**< Account is disabled */
#define NQ_ERR_SESSIONREAUTHREQUIRED (NQ_ERR_MODULE | 44) /**< session reauthentication is required */
#define NQ_ERR_USERRELOGONFAILED (NQ_ERR_MODULE | 45)    /**< user relog failed */
#define NQ_ERR_SERVERUNAVAILABLE (NQ_ERR_MODULE | 46)    /**< the file server is temporarily unavailable */
#define NQ_ERR_SHAREUNAVAILABLE (NQ_ERR_MODULE | 47)     /**< the share is temporarily unavailable */
#define NQ_ERR_OUTOFMEMORY      (NQ_ERR_MODULE | 901)    /**< Failed to allocate memory block */

#define NQ_ERR_BADFUNC          (NQ_ERR_MODULE | 1001)   /**< Invalid function. The server did not recognize or could not perform a system call generated by the server, e.g. set the DIRECTORY attribute on a data file, invalid seek mode. */
#define NQ_ERR_BADFILE          (NQ_ERR_MODULE | 1002)   /**< File not found. The last component of a file's pathname could not be found. */
#define NQ_ERR_BADPATH          (NQ_ERR_MODULE | 1003)   /**< Directory invalid. A directory component in a pathname could not be found. */
#define NQ_ERR_NOFIDS           (NQ_ERR_MODULE | 1004)   /**< Too many open files. The server has no file handles available. */
#define NQ_ERR_NOACCESS         (NQ_ERR_MODULE | 1005)   /**< Access denied, the client's context does not permit the requested function. This includes the following conditions: invalid rename command, write to a file open for read only, read on a file open for write only, attempt to delete a non-empty directory. */
#define NQ_ERR_BADFID           (NQ_ERR_MODULE | 1006)   /**< Invalid file handle. The file handle specified was not recognized by the server. */
#define NQ_ERR_BADMCB           (NQ_ERR_MODULE | 1007)   /**< Memory control blocks destroyed */
#define NQ_ERR_NOMEM            (NQ_ERR_MODULE | 1008)   /**< Insufficient server memory to perform the requested function */
#define NQ_ERR_BADMEM           (NQ_ERR_MODULE | 1009)   /**< Invalid memory block address */
#define NQ_ERR_BADENV           (NQ_ERR_MODULE | 1010)   /**< Invalid environment */
#define NQ_ERR_BADFORMAT        (NQ_ERR_MODULE | 1011)   /**< Invalid format */
#define NQ_ERR_BADACCESS        (NQ_ERR_MODULE | 1012)   /**< Invalid access */
#define NQ_ERR_BADDATA          (NQ_ERR_MODULE | 1013)   /**< Invalid data (generated only by IOCTL calls within the server) */
#define NQ_ERR_BADDRIVE         (NQ_ERR_MODULE | 1015)   /**< Invalid drive specified */
#define NQ_ERR_REMCD            (NQ_ERR_MODULE | 1016)   /**< A Delete Directory request attempted to remove the server's current directory */
#define NQ_ERR_DIFFDEVICE       (NQ_ERR_MODULE | 1017)   /**< Not the same device (e.g. a cross volume rename was attempted) */
#define NQ_ERR_NOFILES          (NQ_ERR_MODULE | 1018)   /**< A File Search command can find no more files matching the specified criteria. */
#define NQ_ERR_WRONGDIALECT     (NQ_ERR_MODULE | 1019)   /**< Dialect revision does not present in Client's active dialects list */
#define NQ_ERR_BADSHARE         (NQ_ERR_MODULE | 1032)   /**< The network path cannot be located. */
#define NQ_ERR_LOCK             (NQ_ERR_MODULE | 1033)   /**< A Lock request conflicted with an existing lock or specified an invalid mode, or an Unlock requested attempted to remove a lock held by another process. */
#define NQ_ERR_DONTSUPPORTIPC   (NQ_ERR_MODULE | 1066)   /**< Server does not support IPC pseudo-filesystem, so that RPC operations are not available. */
#define NQ_ERR_SHARINGVIOLATION (NQ_ERR_MODULE | 1067)   /**< The sharing mode specified for Open conflicts with existing opens on the file. */
#define NQ_ERR_FILEXISTS        (NQ_ERR_MODULE | 1080)   /**< The file named in the request already exists. */
#define NQ_ERR_BADDIRECTORY     (NQ_ERR_MODULE | 1087)   /**< The file specified is not a directory while directory expected. */
#define NQ_ERR_INSUFFICIENTBUFFER (NQ_ERR_MODULE | 1122) /**< Server compose a response due to constraints applied on the request. */
#define NQ_ERR_INVALIDNAME      (NQ_ERR_MODULE | 1123)   /**< File name or path contains invalid characters. */
#define NQ_ERR_DIRNOTEMPTY      (NQ_ERR_MODULE | 1145)   /**< Directory not empty. */
#define NQ_ERR_ALREADYEXISTS    (NQ_ERR_MODULE | 1183)   /**< Object already exists. Returned on an attempt to create file or directory which already exists on the server. */
#define NQ_ERR_BADPIPE          (NQ_ERR_MODULE | 1230)   /**< RPC request specifies invalid handle or a handle that does correspond to an RPC pipe. */
#define NQ_ERR_PIPEBUSY         (NQ_ERR_MODULE | 1231)   /**< Server cannot currently perform the required RPC operation. Client can try again later. */
#define NQ_ERR_PIPECLOSING      (NQ_ERR_MODULE | 1232)   /**< RPC pipe is being closed. */
#define NQ_ERR_NOTCONNECTED     (NQ_ERR_MODULE | 1233)   /**< Connection to server lost. */
#define NQ_ERR_MOREDATA         (NQ_ERR_MODULE | 1234)   /**< The entire payload does not fit in the response. */
#define NQ_ERR_INVALIDNAMELEN   (NQ_ERR_MODULE | 1235)   /**< Invalid name length. */

#define NQ_ERR_ERROR            (NQ_ERR_MODULE | 2001)   /**< Non-specific error code, returned when none of specific error codes is applicable. */
#define NQ_ERR_BADPW            (NQ_ERR_MODULE | 2002)   /**< Invalid password - name/password pair. */
#define NQ_ERR_ACCESS           (NQ_ERR_MODULE | 2004)   /**< The client does not have the necessary access rights within the specified context for the requested function. */
#define NQ_ERR_INVTID           (NQ_ERR_MODULE | 2005)   /**< The TID specified in a command was invalid. */
#define NQ_ERR_INVNETNAME       (NQ_ERR_MODULE | 2006)   /**< Invalid network name (host name) specified. */
#define NQ_ERR_INVDEVICE        (NQ_ERR_MODULE | 2007)   /**< Invalid device - printer request made to non-printer connection or non-printer request made to printer connection. */
#define NQ_ERR_QFULL            (NQ_ERR_MODULE | 2049)   /**< Print queue full (files) -- returned by open print file. */
#define NQ_ERR_QTOOBIG          (NQ_ERR_MODULE | 2050)   /**< Print queue full -- no space . */
#define NQ_ERR_QEOF             (NQ_ERR_MODULE | 2051)   /**< End of file. */
#define NQ_ERR_INVFID           (NQ_ERR_MODULE | 2052)   /**< Invalid file handle. */
#define NQ_ERR_SMBCMD           (NQ_ERR_MODULE | 2064)   /**< The server did not recognize the command received. */
#define NQ_ERR_SRVERROR         (NQ_ERR_MODULE | 2065)   /**< The server encountered an internal error, e.g. system file unavailable. */
#define NQ_ERR_FILESPECS        (NQ_ERR_MODULE | 2067)   /**< The file handle and pathname parameters contained an invalid combination of values. */
#define NQ_ERR_BADPERMITS       (NQ_ERR_MODULE | 2069)   /**< The access permissions specified for a file or directory are not a valid combination. The server cannot set the requested attribute. */
#define NQ_ERR_SETATTRMODE      (NQ_ERR_MODULE | 2071)   /**< The attribute mode in the Set File Attribute request is invalid. */
#define NQ_ERR_PAUSED           (NQ_ERR_MODULE | 2081)   /**< Server paused (reserved for messaging). */
#define NQ_ERR_MSGOFF           (NQ_ERR_MODULE | 2082)   /**< Not receiving messages (reserved for messaging). */
#define NQ_ERR_NOROOM           (NQ_ERR_MODULE | 2083)   /**< No room to buffer message (reserved for messaging). */
#define NQ_ERR_RMUNS            (NQ_ERR_MODULE | 2087)   /**< Too many remote user names (reserved for messaging). */
#define NQ_ERR_TIMEOUT          (NQ_ERR_MODULE | 2088)   /**< Operation timed out. */
#define NQ_ERR_NORESOURCE       (NQ_ERR_MODULE | 2089)   /**< No resources currently available for request. */
#define NQ_ERR_TOOMANYUIDS      (NQ_ERR_MODULE | 2090)   /**< Too many users active on this session. */
#define NQ_ERR_INVUID           (NQ_ERR_MODULE | 2091)   /**< The UID is not known as a valid user identifier on this session. */
#define NQ_ERR_USEMPX           (NQ_ERR_MODULE | 2250)   /**< Temporarily unable to support Raw, use MPX mode. */
#define NQ_ERR_USESTD           (NQ_ERR_MODULE | 2251)   /**< Temporarily unable to support Raw, use standard read/write. */
#define NQ_ERR_CONTMPX          (NQ_ERR_MODULE | 2252)   /**< Continue in MPX mode. */
#define NQ_ERR_NOSUPPORT        (NQ_ERR_MODULE | 2999)   /**< Function not supported. */

#define NQ_ERR_NOWRITE          (NQ_ERR_MODULE | 3019)   /**< Attempt to write on write-protected media. */
#define NQ_ERR_BADUNIT          (NQ_ERR_MODULE | 3020)   /**< Unknown unit. */
#define NQ_ERR_NOTREADY         (NQ_ERR_MODULE | 3021)   /**< Drive not ready. */
#define NQ_ERR_BADCMD           (NQ_ERR_MODULE | 3022)   /**< Unknown command. */
#define NQ_ERR_DATA             (NQ_ERR_MODULE | 3023)   /**< Data error (CRC). */
#define NQ_ERR_BADREQ           (NQ_ERR_MODULE | 3024)   /**< Bad request structure length. */
#define NQ_ERR_SEEK             (NQ_ERR_MODULE | 3025)   /**< Seek error. */
#define NQ_ERR_BADMEDIA         (NQ_ERR_MODULE | 3026)   /**< Unknown media type. */
#define NQ_ERR_BADSECTOR        (NQ_ERR_MODULE | 3027)   /**< Sector not found. */
#define NQ_ERR_NOPAPER          (NQ_ERR_MODULE | 3028)   /**< Printer out of paper. */
#define NQ_ERR_WRITE            (NQ_ERR_MODULE | 3029)   /**< Write fault. */
#define NQ_ERR_READ             (NQ_ERR_MODULE | 3030)   /**< Read fault. */
#define NQ_ERR_GENERAL          (NQ_ERR_MODULE | 3031)   /**< General hardware failure. */
#define NQ_ERR_WRONGDISK        (NQ_ERR_MODULE | 3034)   /**< The wrong disk was found in a drive. */
#define NQ_ERR_FCBUNAVAIL       (NQ_ERR_MODULE | 3035)   /**< No FCBs are available to process request. */
#define NQ_ERR_SHAREBUFEXC      (NQ_ERR_MODULE | 3036)   /**< A sharing buffer has been exceeded. */
#define NQ_ERR_DISKFULL         (NQ_ERR_MODULE | 3039)   /**< The disk is full. */

/** @} end of group NQ_return NQ Error Codes */

/* TCP and NetBIOS layer error codes */

/** @defgroup TCP_NetBIOS_errors TCP and NetBIOS Layer Error Codes
 * @ingroup udapi
 * @{ */
#define NQ_ERR_NBILLEGALSOCKETSLOT          (NQ_ERR_MODULE | 4000)  /**< Internal error */
#define NQ_ERR_NBNOTNETBIOSNAME             (NQ_ERR_MODULE | 4001)  /**< NetBIOS name has illegal format */
#define NQ_ERR_NBTIMEOUT                    (NQ_ERR_MODULE | 4002)  /**< Select timeout on NBT/TCP layer */
#define NQ_ERR_NBNEGATIVERESPONSE           (NQ_ERR_MODULE | 4003)  /**< Negative NetBIOS response received */
#define NQ_ERR_NBHOSTNAMENOTRESOLVED        (NQ_ERR_MODULE | 4004)  /**< NQ failed to resolve host over NetBIOS */
#define NQ_ERR_NBCANCELLISTENFAIL           (NQ_ERR_MODULE | 4005)  /**< Unable to cancel a listen operation */
#define NQ_ERR_NBSOCKETOVERFLOW             (NQ_ERR_MODULE | 4006)  /**< Too many sockets in use */
#define NQ_ERR_NBNOBINDBEFORELISTEN         (NQ_ERR_MODULE | 4007)  /**< Listen attempt on a socket that was not bound yet */
#define NQ_ERR_NBILLEGALDATAGRAMSOURCE      (NQ_ERR_MODULE | 4008)  /**< Source name has illegal format */
#define NQ_ERR_NBILLEGALDATAGRAMDESTINATION (NQ_ERR_MODULE | 4009)  /**< Destination name has illegal format */
#define NQ_ERR_NBINVALIDPARAMETER           (NQ_ERR_MODULE | 4010)  /**< Invalid parameter */
#define NQ_ERR_NBINTERNALERROR              (NQ_ERR_MODULE | 4011)  /**< Internal error */
#define NQ_ERR_NBILLEGALDATAGRAMTYPE        (NQ_ERR_MODULE | 4012)  /**< Unexpected datagram type */
#define NQ_ERR_NBDDCOMMUNICATIONERROR       (NQ_ERR_MODULE | 4013)  /**< NQ failed to communicate with NetbIOS daemon */
#define NQ_ERR_NBBUFFEROVERFLOW             (NQ_ERR_MODULE | 4014)  /**< Internal buffer size exceeded */
#define NQ_ERR_NBRELEASENAMEFAIL            (NQ_ERR_MODULE | 4015)  /**< NQ failed to release a registered name */
#define NQ_ERR_NBLISTENFAIL                 (NQ_ERR_MODULE | 4016)  /**< NQ failed to listen */

#define NQ_ERR_SOCKETCREATE                 (NQ_ERR_MODULE | 5000)  /**< Socket failed to create */
#define NQ_ERR_SOCKETBIND                   (NQ_ERR_MODULE | 5001)  /**< Socket failed to bind */
#define NQ_ERR_SOCKETNAME                   (NQ_ERR_MODULE | 5002)  /**< Socket failed to get name */
#define NQ_ERR_SOCKETSEND                   (NQ_ERR_MODULE | 5003)  /**< Socket failed to send */
#define NQ_ERR_SOCKETSETOPTION              (NQ_ERR_MODULE | 5004)  /**< Socket failed to set options */
#define NQ_ERR_SOCKETADDRESS                (NQ_ERR_MODULE | 5005)  /**< Failed to get socket address */

#define NQ_ERR_CAPTUREZERO                  (NQ_ERR_MODULE | 6000)  /**< Error used when packet in internal capture should be zeroed */
#define NQ_ERR_INVALIDUINT32SIZE            (NQ_ERR_MODULE | 6001)  /**< Invalid NQ_UINT32 size */
#define NQ_ERR_RECONNECTREQUIRED            (NQ_ERR_MODULE | 6002)  /**< Error used when send fails and reconnect is required */
#define NQ_ERR_SIZEERROR                    (NQ_ERR_MODULE | 6003)  /**< Error requesting file size */
#define NQ_ERR_SEEKERROR                    (NQ_ERR_MODULE | 6004)  /**< Invalid seek result */
#define NQ_ERR_ATTRERROR                    (NQ_ERR_MODULE | 6005)  /**< Error requesting file attributes */

#define NQ_ERR_KERBEROSERROR                (NQ_ERR_MODULE | 7000)  /**< Kerberos general error */

#define NQ_ERR_RAPGENERALERROR              (NQ_ERR_MODULE | 8000)  /**< RAP general error */
#define NQ_ERR_RAPACCESSDENIED              (NQ_ERR_MODULE | 8001)  /**< RAP user has insufficient privilege */
#define NQ_ERR_RAPMOREDATA                  (NQ_ERR_MODULE | 8002)  /**< RAP additional data is available */
#define NQ_ERR_RAPSERVERNOTSTARTED          (NQ_ERR_MODULE | 8003)  /**< RAP the server service on the remote computer is not running */
#define NQ_ERR_RAPBADTRANSACTCONFIG         (NQ_ERR_MODULE | 8004)  /**< RAP the server is not configured for transactions, IPC$ is not shared */
#define NQ_ERR_RAPSERVICENOTINSTALLED       (NQ_ERR_MODULE | 8005)  /**< RAP the service has not been started */
#define NQ_ERR_RAPDEVICENOTCONNECTED        (NQ_ERR_MODULE | 8006)  /**< RAP the device is not connected */
#define NQ_ERR_RAPNOTACTIVEINDOMAIN         (NQ_ERR_MODULE | 8007)  /**< RAP the computer is not active in this domain */
#define NQ_ERR_RAPNOBROWSERSERVERSFOUND     (NQ_ERR_MODULE | 8008)  /**< RAP the list of servers for this workgroup is not currently available */

#define NQ_ERR_ICONVERROR                   (NQ_ERR_MODULE | 9000)  /**< iconv failed to convert */
#define NQ_ERR_ICONVOPEN                    (NQ_ERR_MODULE | 9001)  /**< iconv_open failed to allocate a conversion descriptor*/

/* Password Length*/

#define UD_NQ_MAXPWDLEN  257    /**< password buffer length */

/** @} end of group TCP_NetBIOS_errors TCP and NetBIOS Layer Error Codes */

/* udGetPassword() return codes */

/** @defgroup auth_status Authentication Statuses
 * @ingroup udapi
 *  udGetPassword() return codes
 *  @{ */

/**                                One of the possible values returned by the udGetPassword() Function.
                                   User name was found and the password is returned as both LM and NTLM hash.*/

#define NQ_CS_PWDFOUND  0        /**< password was found for the user, the same as 3 */

/**                                One of the possible values returned by the udGetPassword() Function.
                                   User authenticated without checking password.*/

#define NQ_CS_PWDNOAUTH 1        /**< authentication is not required */

/**                                One of the possible values returned by the udGetPassword() Function.
                                   No such user.*/

#define NQ_CS_PWDNOUSER 2       /**< no such user */

/**                                One of the possible values returned by the udGetPassword() Function.
                                   User name was found and the password is LM hash.*/

#define NQ_CS_PWDLMHASH 3       /**< password found for the user and it is LM hash */

/**                                One of the possible values returned by the udGetPassword() Function.
                                   User name was found and the password is returned as both LM and NTLM hash.*/

#define NQ_CS_PWDANY    4       /**< password found for the user and its encryption is reported */

/** @} end of group auth_status Authentication Statuses */

/* Initialization */

/** @defgroup functions Functions
 * @ingroup udapi
  @{ */

/**
   Initialize UD module.

   The project level code must call this function on startup
   before calling <i>nqStart()</i>.
   @return
   <i>NQ_SUCCESS</i> on success or <i>NQ_FAIL</i> on error.         */
NQ_STATUS udInit(void);

/**
   Stop UD module.

   The project level must call this function after calling <i>nqStop()</i>.
                                                                         */
void udStop(void);

/**
   Reset server parameters

   This function reset the value of server parameters that was loaded from
   server configuration file, it should be called during server restart.
                                                                         */
void udResetServerParams(void);

#if defined(UD_NQ_INCLUDECIFSSERVER) || defined(DOXYGEN)
/**
   NQ signals to the project level of the server startup
   complete. Now NQ Server is ready to accept incoming
   connections.

   The default implementation of this function prints a message
   on console. Integrators may modify it to take measures on the
   server startup.
                                                        */
void udCifsServerStarted(void);

/**
   NQ signals to the project level of the server shutdown.
   Now NQ Server does not accept anymore incoming connections.

   The default implementation of this function prints a message
   on console. Integrators may modify it to take measures on the
   server shutdown.
                                                   */
void udCifsServerClosed(void);
#endif /* UD_NQ_INCLUDECIFSSERVER */

/**
   NQ signals to the project level of NetBIOS Daemon
   readiness.

   The default implementation of this function is empty.
   Integrators may modify it to take measures on the daemon
   startup.
                                        */
void udNetBiosDaemonStarted(void);

/**
   NQ signals to the project level of NetBIOS Daemon
   shutdown.

   The default implementation of this function is empty.
   Integrators may modify it to take measures on the daemon
   shutdown.
                                  */
void udNetBiosDaemonClosed(void);

/**
 Obtain the system's Scope ID for NetBIOS.
 Parameters
 @param buffer Buffer for the result of at least 16 bytes.
 */
void udGetScopeID(NQ_WCHAR * buffer);

/**
   Obtain wins addresses information.

   This function allows to obtain the default WINS addresses. To
   add more WINS addresses, use <i>cmNetBiosSetWins()</i> or <i>cmNetBiosSetWinsA()</i>.
   @param pServers  OUT A semicolon\-delimited list of WINS servers.
   @note
   Returns WINS servers as supplied by User Defined level (for example cm_cfg.txt).
                                                    */
void udGetWins(NQ_WCHAR * pServers);

/**
 Get the default domain or workgroup name.

 NQ calls this function once on startup. The domain name may be modified later by calling the <i>cmDnsSetDomain()</i> functions.

 @param buffer Buffer for the result of at least 16 bytes.
 @param isWorkgroup: <i>TRUE</i> for a workgroup name, <i>FALSE</i> for a domain name.
 */
void udGetDomain(NQ_WCHAR * buffer, NQ_BOOL * isWorkgroup);

#if defined(UD_NQ_USETRANSPORTIPV4) || defined(UD_NQ_USETRANSPORTIPV6) || defined(DOXYGEN)

/**
   Get DNS initialization parameters (DNS addresses and domain)

   This function is called by NQ on startup. It must bring the
   default list of DNS servers. More DNS servers may be added
   later by calling the <i>cmDnsSetServers()</i> function.

   @param domain   The default domain target belongs to.
   @param servers  A semicolon\-delimited list of DNS servers.
   @note
   Returns DNS servers as supplied by User Defined level (for example cm_cfg.txt)   */
void udGetDnsParams(NQ_WCHAR * domain, NQ_WCHAR * servers);

#endif /* defined(UD_NQ_USETRANSPORTIPV4) || defined(UD_NQ_USETRANSPORTIPV6) */

/**
 Get authentication parameters for connecting domain controllers.

 NQ uses embedded SMB client for domain authentication, joining domain and domain logon.
 The credentials used during these transactions should be sufficient.

    @param resource URI of the destination to connect to.
    @param userName Buffer for user name. This buffer is 256 wide characters at least.
    @param password Buffer for password. This buffer is 256 wide characters at least.
    @param domain Buffer for domain name. This buffer is 256 wide characters at least.
 @returns
 <i>TRUE</i> when credentials were obtained, <i>FALSE</i> on failure.
 */
NQ_BOOL udGetCredentials(const void * resource, NQ_WCHAR * userName, NQ_WCHAR * password, NQ_WCHAR * domain);

/**
   Check password for a specific user.

   NQ Server calls this function on SMB logon (session setup) to
   authenticate a local user. This function is called in the
   following cases:
     \* No domain Controller was detected and, therefore, domain
       logon is not available.
     \* Domain logon failed for any reason.
   NQ calls this function to obtain the password for the user
   being authenticated. When this function returns with a
   password, NQ compares it with the values received from the
   client over SMB. On match user becomes authenticated with NQ.
   Since the password received over the wire is hashed, NQ
   requires hashed passwords.

   Plain text passwords are deprecated.

   The default implementation of this function reads passwords
   froma configuration file.

   @param userName      User name as a null-terminated string in
                  UTF-16LE.
   @param password     Buffer for user's password. This password must
                  be hashed. Plain text passwords are deprecated.
   @param pwdIsHashed  Buffer for password has flag as: <i>TRUE</i>
                  when password is hashed, <i>FALSE</i> when
                  password is plain text. Plain text passwords
                  are deprecated.
   @param userNumber   Unique user ID (RID).
   @returns
   One of the following:
     \* NQ_CS_PWDFOUND : User name was found and the password is
       returned as both LM and NTLM hash.
     \* NQ_CS_PWDNOAUTH : User was authenticated without checking
       password.
     \* NQ_CS_PWDNOUSER : No such user.
     \* NQ_CS_PWDLMHASH : User name was found and the password is
       LM hash.
     \* NQ_CS_PWDANY : User name was found and the password is
       returned as both LM and NTLM hash.                         */
NQ_INT udGetPassword(const NQ_WCHAR* userName, NQ_CHAR* password, NQ_INT* pwdIsHashed, NQ_UINT32* userNumber);

/**
 This function reads last system error and attempts to convert it into an SMB error.

 This function may implement a customized error code conversion. If this conversion fails (a zero value is returned) NQ will use the default conversion. Its default implementation always returns zero.
 @param sysErr system error code to convert
 @returns
 SMB error or zero to use the default conversion.
 */
NQ_UINT32
udGetSmbError(
    NQ_UINT32 sysErr
    );

/**
   This function converts an internal NQ error into the system
   error code.

   NQ calls this function at the very end of a client
   transaction processing to map internal error on system error.

   @param nqErr  NQ internal error code to convert. These error
            numbers are defined in <i>udapi.h.</i>
   @returns
   System error or 0 (then the system-dependent conversion will
   be taken).                                                    */
NQ_UINT32 udNqToSystemError(NQ_STATUS nqErr);

/**
 Get transport priority.

 NQ Client uses this function to determine in which sequence it attempts to connect to the server. NQ Client can use three transports:
 * NetBIOS over TCP port 139.
 * TCP over IPv4 port 445.
 * TCP over IPv6 port 445.
 The order in which NQ tries the above transports, depends on the priorities assigned by the function being described. NQ calls this function on each new connection and it
 does it once for each transport that was included in <i>udparams.h</i>.
 @param transport The transport number as:
                     \* NS_TRANSPORT_NETBIOS - NetBIOS.
                     \* NS_TRANSPORT_IPV4 - IPv4.
                     \* NS_TRANSPORT_IPV6 - IPv6.
 @returns
 A priority assigned to the provided transport as:
     \* 0 - the transport isn't used
     \* 1..3 - the bigger number is highest priority
 If more then one transport has same priority
 built in order is used: IPv6, IPv4, NetBIOS.
 */
NQ_INT udGetTransportPriority(NQ_UINT transport);

/**
 Get server comment string.

 NQ Server uses this string in several information responses.

 @param   buffer Buffer for the result of 256 characters at least.
 */
void udGetServerComment(NQ_WCHAR * buffer);

/**
 Project-level processing on incoming data to NetBios Daemon.

 NQ calls this function when NetBIOS daemon receives a message. The default implementation of this function is empty.
 */
void udNetBiosDataIn(void);

/**
 Project-level processing on incoming data to NQ Server.

 NQ calls this function when SMB engine receives a message. The default implementation of this function is empty.
 */
void udServerDataIn(void);

/**
 Project-level processing on client connection to a share.

 NQ calls this function when SMB engine receives a tree connect request (Tree Connect). The default implementation of this function is empty.

 @param share Name of the share being connected.
 */
void udServerShareConnect(const NQ_WCHAR * share);

/**
 Project-level processing on client disconnect from a share.

  NQ calls this function when SMB engine receives a tree disconnect request (Tree Disconnect). The default implementation of this function is empty.

 @param  share Name of the share being disconnected.
 */
void udServerShareDisconnect(const NQ_WCHAR * share);

#if defined(UD_NQ_INCLUDECODEPAGE) || defined(DOXYGEN)

/**
 Get current code page number.

 NQ uses code pages when conversion from UTF-16LE to ANSI characters or vice versa happens. This may happen for host and domain names through NetBIOS and DNS.
 @returns
 Code page number according to IANA.
 */
NQ_INT udGetCodePage(void);

/**
 Set current code page number.

 NQ uses code pages when conversion from UTF-16LE to ANSI characters or vice versa happens. This may happen for host and domain names through NetBIOS and DNS.

 @param codePage Code page number.
 */
void udSetCodePage(NQ_INT codePage);

#endif /* UD_NQ_INCLUDECODEPAGE */

/**
 Redefine port number.

 NQ uses the following ports:
    \* Port 137 - NetBIOS Naming Service listener
    \* Port 138 - NetBIOS Datagram Service listener
    \* Port 139 - NetBIOS Session Service listener
    \* Internal ports used for communication between NQ Server and NetBIOS daemon.
 For coexistence with other network components NQ allows to redefine any of those ports by means of this function.
 NQ calls it each time a port is about to use, providing it with a default value. NQ uses the return value as an actual port number.
 The default implementation simply returns the default value thus no redefinition is performed.
 For redefining a port, modify this function so that it will return an alternate port number for the default port of the interest.
 For other ports that should not be alternated this function should continue to return its only argument.

 @param port The default port number in the host byte order.
 @returns
 Redefined port number in the host byte order. By default this is the same number that is provided on the call.
 */
NQ_PORT udGetPort(NQ_PORT port);

#if defined(UD_CS_INCLUDESECURITYDESCRIPTORS) || defined(UD_CC_INCLUDESECURITYDESCRIPTORS) || defined (UD_CC_INCLUDEDOMAINMEMBERSHIP) || defined(UD_CS_INCLUDEPASSTHROUGH) || defined(DOXYGEN)

/**
 Get unique ID for the current machine.
 The returned 12-byte value should be:
    \* "Statistically unique" for the given machine.
    \* Persistently the same for each call.
 Recommended methods are:
    \* MAC address of the default adapter.
    \* Product serial number when available.

 @param     buf A 12 - byte buffer to be filled with a unique value.
 */
void udGetComputerId(NQ_BYTE * buf);

#if defined(UD_CS_INCLUDELOCALUSERMANAGEMENT) || defined(DOXYGEN)

/**
 Get number of local users.
 @returns
 Number of local user accounts.
 */
NQ_COUNT udGetUserCount(void);

/**
 Get local user ID by name.

 It is developer's responsibility to implement a particular user management mechanism. Persistent user management may keep a list of users in a file.
 User RID (relative ID) should be a number unique through over the local user database.

 @param  name User name as a UTF-16LE string.
 @param  rid Buffer for user's unique ID (RID).
 @returns
 <i>TRUE</i> when user was found and <i>FALSE</i> for a non-existing user.
 */
NQ_BOOL udGetUserRidByName(const NQ_WCHAR * name, NQ_UINT32 * rid);

/**
 Get local user name by ID.

 User RID (relative ID) should be a number unique through over the local user database. User name (i.e., - account name) should be also unique in the local account database.
 Full user name should not be necessarily unique.

 @param rid  A unique ID.
 @param nameBuffer  Pointer to a buffer of 256 wide characters for user account name (short name). When the given RID corresponds to a local user the function fills this buffer with the account name.
 @param fullNameBuffer  Pointer to a buffer of 256 wide characters for a full user name. When the given RID corresponds to a local user the function fills this buffer with a user-friendly name to be displayed on the client.
 @returns
 <i>TRUE</i> when the ID was identified as a local user ID and <i>FALSE</i> for a non-existing user.
 */
NQ_BOOL udGetUserNameByRid(NQ_UINT32 rid, NQ_WCHAR * nameBuffer, NQ_WCHAR * fullNameBuffer);

/**
 Enumerate local users.

 The order of accounts is undefined, but all accounts should have indices from 0 to N where N is the number of users.

 @param index Zero-based index of user accounts in the database.
 @param rid Buffer for RID for the index's user.
 @param name Pointer to a buffer of 256 wide characters for user account name (short name). When the given RID corresponds to a local user the function fills this buffer with the account name.
 @param fullName Pointer to a buffer of 256 wide characters for a full user name. When the given RID corresponds to a local user the function fills this buffer with the name to be displayed on the client.
 @param description Pointer to a buffer of 256 wide characters for account description. When the given RID corresponds to a local user the function fills this buffer with account description to be displayed on the client.
 @returns
 <i>TRUE</i> when a user with the given index is available or <i>FALSE</i> for the end of enumeration.
 */
NQ_BOOL udGetUserInfo(NQ_UINT index, NQ_UINT32 * rid, NQ_WCHAR * name, NQ_WCHAR * fullName, NQ_WCHAR * description);

/**
 Set user administrative rights.

 NQ Server supports two local user groups: Users and Administrators. Any user is a member of the Users group.
 This function allows to make user a member in the Administrators group or to cancel user's membership in this group.

 @param   rid  A unique account ID.
 @param   isAdmin  <i>TRUE</i> to set a local user as an administrator, <i>FALSE</i> to remove user from the Administrators group.
 @returns
 TRUE when operation has succeeded, <i>FALSE</i> on error.
 */
NQ_BOOL udSetUserAsAdministrator(NQ_UINT32 rid, NQ_BOOL isAdmin);

/**
   Add or modify a local user account.

   It is recommended that this function return FALSE when there
   is another user with the same account name. It is recommended
   to save password in an encrypted form. Use the following code
   fragment to encrypt a plain text Unicode password into an MD4
   hash:

       @code
       cmUnicodeToAnsi(asciiPassword, password);

       cmHashPassword(asciiPassword,encryptedPassword);

       cmMD4(encryptedPassword+16, (NQ_BYTE*)password);

       cmWStrlen(password)*sizeof(NQ_WCHAR) );
       @endcode

   @param rid       A unique account ID.
   @param name      New account name of up to 256 wide characters.
   @param fullName  New full (user-friendly) user name of up to 256
               wide characters.
   @param descr     New account description of up to 256 wide characters.
   @param password  New password. The password is plain text UTF-16LE.
   @returns
   TRUE when operation has succeeded, <i>FALSE</i> on error.       */
NQ_BOOL udSetUserInfo(NQ_UINT32 rid, const NQ_WCHAR * name, const NQ_WCHAR* fullName, const NQ_WCHAR* descr, const NQ_WCHAR* password);

/**
 Add a local user.

 It is recommended that this function return FALSE when there is another user with the same account name.
 A new user may be created with an empty or a random password. An expected immediate call to udSetUserInfo() (see above) will set new password.

   @param name       New account name of up to 256 wide characters.
   @param fullName   New full (user-friendly) user name of up to 256
               wide characters.
   @param description      New account description of up to 256 wide characters.
   @returns
   TRUE when operation has succeeded, <i>FALSE</i> on error. */
NQ_BOOL udCreateUser(const NQ_WCHAR* name, const NQ_WCHAR* fullName, const NQ_WCHAR* description);

/**
 Description
 Remove a local user.

 @param rid       A unique account ID.
 @returns
   TRUE when operation has succeeded, <i>FALSE</i> on error. */
NQ_BOOL udDeleteUserByRid(NQ_UINT32 rid);

#endif /* UD_CS_INCLUDELOCALUSERMANAGEMENT */

#endif /* defined(UD_CS_INCLUDESECURITYDESCRIPTORS) || defined(UD_CC_INCLUDESECURITYDESCRIPTORS) || defined (UD_CC_INCLUDEDOMAINMEMBERSHIP) || defined(UD_CS_INCLUDEPASSTHROUGH)*/

#if defined(UD_CS_INCLUDERPC_SRVSVC_EXTENSION) || defined(DOXYGEN)

/** modify/create share information in a persistent store
 *
 *  @param name share to modify or NULL for a new share
 *  @param newName new share name
 *  @param newMap new share path
 *  @param newDescription new share description
 *  @return TRUE on success, FALSE on failure
 *  @note   user-level should return TRUE in the following cases:
 *          \* new share was perisistently stored
 *          \* existing share was peristently modified
 *          \* new share was not persistently stored but it should
 *             be exposed until server shutdown
 *          \* share was not persistently modified but this modification
 *             should be exposed until server shutdown
 *          user-level should return FALSE when a new share should not
 *          be created or an existing share should not be modified */
NQ_BOOL
udSaveShareInformation(
    const NQ_WCHAR* name,
    const NQ_WCHAR* newName,
    const NQ_WCHAR* newMap,
    const NQ_WCHAR* newDescription
    );

/** remove share from the persistent store
 *  @param  name share to remove
 *  @return TRUE on success, FALSE on failure
 *  */
NQ_BOOL
udRemoveShare(
    const NQ_WCHAR* name
    );

#endif /* UD_CS_INCLUDERPC_SRVSVC_EXTENSION */


/**
    Report to the project level about a NetBIOS error.
    Parameters
    @param cause  Error code as:
             \* CM_NBERR_NOTNETBIOSNAME
             \* CM_NBERR_TIMEOUT
             \* CM_NBERR_NEGATIVERESPONSE
             \* CM_NBERR_HOSTNAMENOTRESOLVED
             \* CM_NBERR_CANCELLISTENFAIL
             \* CN_NBERR_SOCKETOVERFLOW
             \* CM_NBERR_NOBINDBEFORELISTEN
             \* CM_NBERR_ILLEGALDATAGRAMSOURCE
             \* CM_NBERR_ILLEGALDATAGRAMDESTINATION
             \* CM_NBERR_INVALIDPARAMETER
             \* CM_NBERR_INTERNALERROR
             \* CM_NBERR_ILLEGALDATAGRAMTYPE
             \* CM_NBERR_DDCOMMUNICATIONERROR
             \* CM_NBERR_BUFFEROVERFLOW
             \* CM_NBERR_RELEASENAMEFAIL
   Right now only CM_NBERR_NEGATIVERESPONSE is used while others are reserved for a future use.
   @param name The NetBIOS name that caused the error.
 */
void udNetBiosError(NQ_STATUS cause, const NQ_CHAR * name);

#if defined(UD_CC_INCLUDEDOMAINMEMBERSHIP) || defined(DOXYGEN)

/**
   Read computer secret.

   Computer secret is a binary array of 16 bytes that NQ
   receives from Domain Controller after joining a domain. NQ
   uses this array for subsequent logon into the domain.

   @param secret   Buffer for a secret pointer. If a value inside that
             buffer is non-NULL, this function should fill this
             buffer with a pointer to computer secret. If it is
             NULL, the function should check for computer secret
             without setting a pointer to it.
   @returns
   <i>TRUE</i> if the computer secret is available. <i>FALSE</i>
   means that the computer secret is not available for one of
   the following reasons:
     \* NQ did not join the domain yet.
     \* The computer secret was not properly saved.
     \* The computer secret is not accessible.
   @note
   NQ assumes that computer secret is persistent and was stored
   in a call to the udSetComputerSecret() Function. */
NQ_BOOL udGetComputerSecret(NQ_BYTE ** secret);

/**
   Read computer secret by domain.

   Computer secret is a binary array of 16 bytes that NQ
   receives from Domain Controller after joining a domain. NQ
   uses this array for subsequent logon into the domain.
   Parameters
   @param secret   Buffer for a secret pointer. If a value inside that
             buffer is non-NULL, this function should fill this
             buffer with a pointer to computer secret.
   @param domainDNS  Domain name DNS
   @param domainNB  Domain name NetBIOS. If it is NULL, the function
              checks for computer secret which refers only to domainDNS.

   @returns
   <i>TRUE</i> if the computer secret is available and (if the <i>secret</i>
   parameter was not NULL) was copied into the buffer. <i>FALSE</i>
   means that the computer secret is not available for one of
   the following reasons:
     \* NQ did not join the domain yet.
     \* The computer secret was not properly saved.
     \* The computer secret is not accessible.
   Buffer domainNB is populated with domain NetBIOS name.
   @note
   NQ assumes that computer secret is persistent and was stored
   in a call to the udSetComputerSecretByDomain() Function. */
NQ_BOOL udGetComputerSecretByDomain(NQ_BYTE *secret, const NQ_WCHAR *domainDNS, NQ_WCHAR *domainNB);

/**
   Save computer secret.

   Computer secret is a binary array of 16 bytes that NQ
   receives from Domain Controller after joining a domain. NQ
   uses this array for subsequent logon into the domain.

   @param secret   Computer secret pointer.
   @note
   NQ assumes that computer secret is persistent and after this
   call it will be available through a call to the udGetComputerSecret Function(). */
void udSetComputerSecret(NQ_BYTE * secret);

/**
   Save computer secret per domain.

   Computer secret is a binary array of 16 bytes that NQ
   receives from Domain Controller after joining a domain. NQ
   uses this array for subsequent logon into the domain.

   @param secret  Computer secret pointer.
   @param domainDNS  Domain name DNS
   @param domainNB  Domain name NetBIOS. If it is NULL, the function
              saves computer secret which refers only to domainDNS.
   @note
   NQ assumes that computer secret is persistent and after this
   call it will be available through a call to the udGetComputerSecretByDomain() Function. */
void udSetComputerSecretByDomain(const NQ_BYTE *secret, const NQ_WCHAR *domainDNS, const NQ_WCHAR *domainNB);

#endif /* UD_CC_INCLUDEDOMAINMEMBERSHIP */

/**
 Determine the file system name for the given share.

 This function uses either share name or share path to determine the type of the target file system.
 Then it copies the name of this file system into the provided buffer. The name should not be longer than 100 characters.

 @param shareName Pointer to the share name.
 @param sharePath  Pointer to the share path.
 @param fileSystemName  Pointer to buffer for the file system name.
 */
void udGetFileSystemName(const NQ_WCHAR* shareName, const NQ_WCHAR* sharePath, NQ_WCHAR* fileSystemName);

/** @} end of group functions Functions */

#ifndef CM_NQ_STORAGE


#if defined(UD_NQ_INCLUDEEVENTLOG) || defined(DOXYGEN)

/*
    Event log constants
    -------------------
 */

/** @defgroup Event_log_const Event Log Constants
 * @ingroup udapi
   @{ */

/* event triggering module */
#define UD_LOG_MODULE_CS        1   /**< Designates NQ CIFS Server as the event origin */
#define UD_LOG_MODULE_CC        2   /**< Designates NQ CIFS Client as the event origin */
/* event class for server */
#define UD_LOG_CLASS_GEN        1   /**< Event class for start and stop events */
#define UD_LOG_CLASS_FILE       2   /**< Event class for file/directory access events */
#define UD_LOG_CLASS_SHARE      3   /**< Event class for share connect/disconnect events */
#define UD_LOG_CLASS_USER       4   /**< Event class for user */
#define UD_LOG_CLASS_CONNECTION 5   /**< Event class for connections */

/* start/stop evemts */
#define UD_LOG_GEN_START        1   /**< Start event type */
#define UD_LOG_GEN_STOP         2   /**< Stop event type */
#define UD_LOG_GEN_NAMECONFLICT 3   /**< Name Conflict has occured*/
#define UD_LOG_GEN_NAMEREGFAIL  4   /**< Name Registration Failed */

/* file access events */
#define UD_LOG_FILE_CREATE      1   /**< File/directory create event type */
#define UD_LOG_FILE_OPEN        2   /**< File/directory open event type */
#define UD_LOG_FILE_CLOSE       3   /**< File/directory close event type */
#define UD_LOG_FILE_DELETE      4   /**< File/directory delete event type */
#define UD_LOG_FILE_RENAME      5   /**< File/directory rename event type */
#define UD_LOG_FILE_ATTRIBGET   6   /**< File/directory query attributes event type */
#define UD_LOG_FILE_ATTRIBSET   7   /**< File/directory change attributes event type */
#define UD_LOG_FILE_SIZESET     8   /**< File turncate/extend event type */
#define UD_LOG_FILE_VOLUMEINFO  9   /**< Volume information query event type*/
#define UD_LOG_FILE_QUERYDIRECTORY 10 /**< folder enumeration event type*/
#define UD_LOG_FILE_SEEK        11  /**< File position change event type*/
#define UD_LOG_FILE_LOCK        12  /**< File range lock event type */
#define UD_LOG_FILE_UNLOCK      13  /**< File range unlock event type*/

/* share access events */
#define UD_LOG_SHARE_CONNECT    1   /**< Share connection event type */
#define UD_LOG_SHARE_DISCONNECT 2   /**< Share disconnection event type */
/* user access events*/
#define UD_LOG_USER_LOGON       1   /**< User connection event type */
#define UD_LOG_USER_LOGOFF  2   /**< User disconnection event type */
/* connection access events */
#define UD_LOG_CONNECTION_CONNECT 1 /**< New connection connected [SYN]*/
#define UD_LOG_CONNECTION_DISCONNECT 2  /**< disconnected connection [FIN]*/

/** @} end of group Event_log_const Event Log Constants */

/*
    Event log structures
    -------------------
 */

/** Data structure for an event from File/Directory Access class.
   Depending on the event type, some members of this structure may be undefined */

typedef struct {
    const NQ_WCHAR* fileName;   /**< file to access */
    const NQ_WCHAR* newName;    /**< new file name for rename operation */
    NQ_UINT32 access;           /**< this value is has different meaning for different events:
                                   for UD_LOG_FILE_CREATE, UD_LOG_FILE_DELETE and UD_LOG_FILE_RENAME - no meaning.
                                   for UD_LOG_FILE_OPEN and UD_LOG_FILE_CLOSE:
                                    0x0 - read
                                    0x1 - write
                                    0x2 - read/write
                                    0x3 - execute
                                    0x8000 - delete
                                    0xF - all
                                   for UD_LOG_FILE_ATTRIB:
                                    0x1 - readonly
                                    0x2 - hidden
                                    0x4 - system
                                    0x8 - volume
                                    0x10 - directory
                                    0x20  - archive
                                    0x80 - normal
                                 */
    NQ_BOOL   before;           /**< whether event taken before of after the operation */
    NQ_UINT32 rid;              /**< Unique user ID */
    NQ_UINT32 tid;              /** <Unique tree ID */
    NQ_UINT32 sizeLow;          /**< First 32 bits of file size or range size*/
    NQ_UINT32 sizeHigh;         /**< Last 32 bits of file size or range size*/
    NQ_UINT32 offsetLow;        /**< First 32 bits of a position in file*/
    NQ_UINT32 offsetHigh;       /**< Last 32 bits of a position in file*/
    NQ_UINT32 infoLevel;        /**< Information lever for query and set info*/
}
UDFileAccessEvent;

/** Data structure for an event from Share Access class.
   Depending on the event type, some members of this structure may be undefined */

typedef struct {
    const NQ_WCHAR* shareName;      /**< name of the share being accessed */
    NQ_BOOL         ipc;            /**< TRUE for IPC share */
    NQ_BOOL         printQueue;     /**< TRUE for a printer queue share */
    NQ_UINT32       rid;            /**< Unique user ID */
    NQ_UINT32       tid;            /**< Unique tree ID */
}
UDShareAccessEvent;

/** Data structure for an event from User Access class.
   Defined user ID */

typedef struct{
    NQ_UINT32         rid;          /**< Unique user ID */
}
UDUserAccessEvent;

/** @ingroup functions

    Event log function
 */
void
udEventLog (
    NQ_UINT module,                 /**< NQ module that originated this event */
    NQ_UINT eventClass,              /**< event class */
    NQ_UINT type,                   /**< event type */
    const NQ_WCHAR* userName,       /**< name of the user */
    const NQ_IPADDRESS* pIp,        /**< next side IP address */
    NQ_UINT32 status,               /**< zero if the operation has succeeded or error code on failure
                                       for server event this code is the same that will be transmitted
                                       to the client
                                       for an NQ CIFS client event this value is the same
                                       that will be installed as system error */
    const NQ_BYTE* parameters       /**< pointer to a structure that is filled with event data
                                       actual structure depends on event type */
    );

#endif /* UD_NQ_INCLUDEEVENTLOG */

/** @addtogroup functions
 * @{
 */

/**
 * allocate buffer in the user space
 * @param idx buffer index zero based
 * @param numBufs total number of buffers to be allocated
 * @param bufferSize buffer size in bytes
 * @return pointer to the buffer
 */
NQ_BYTE*
udAllocateBuffer(
    NQ_INT idx,
    NQ_COUNT numBufs,
    NQ_UINT bufferSize
    );

/**
 * release buffer in the user space
 * @param idx buffer index zero based
 * @param numBufs total number of buffers to be released
 * @param buffAddr buffer address
 * @param bufferSize buffer size in bytes
 */
void
udReleaseBuffer(
    NQ_INT idx,
    NQ_COUNT numBufs,
    NQ_BYTE* buffAddr,
    NQ_UINT bufferSize
    );



/**
 * query user-defined security descriptor
 *
 * @param file ID of an opened file
 * @param information descriptor to get
 * @param buffer output buffer
 * @return
 * descriptor length
 */
NQ_INT
udGetSecurityDescriptor(
    NQ_INT file,
    NQ_UINT32 information,
    void* buffer
    );


/**
 * write user-defined security descriptor
 *
 * @param file ID of an opened file
 * @param information descriptor to set
 * @param buffer input buffer
 * @param len descriptor length
 * @return
 * NQ_SUCCESS or error code
 */
NQ_STATUS
udSetSecurityDescriptor(
    NQ_INT file,
    NQ_UINT32 information,
    const void* buffer,
    NQ_UINT32 len
    );

/**
 * Get persistent security descriptor for share
 *
 * @param shareName share name
 * @param buffer buffer to read SD in
 * @param bufferLen buffer length
 * @return
 * SD length or zero on error
 */
NQ_COUNT
udLoadShareSecurityDescriptor(
    const NQ_WCHAR* shareName,
    NQ_BYTE* buffer,
    NQ_COUNT bufferLen
    );

/**
 * Save persistent security descriptor for share
 *
 * @param shareName share name
 * @param sd pointer to SD
 * @param sdLen SD length
 */
void
udSaveShareSecurityDescriptor(
    const NQ_WCHAR* shareName,
    const NQ_BYTE* sd,
    NQ_COUNT sdLen
    );

/**
   Get next share in the list of shares for CS (extended).
   
   @param name       Pointer to the share name buffer.
   @param map        Pointer to the share map buffer.
   @param isPrinter  0 for file system, 1 for print queue.
   @param description buffer for the share description
   @param isEncrypted 0 for regular share, 1 for encrypted share (SMB3)

   @return <i>TRUE</i> - a share read <i>FALSE</i> - no more shares                                                                                                                     */
NQ_BOOL
udGetNextShareEx(
    NQ_WCHAR* name,
    NQ_WCHAR* map,
    NQ_BOOL* isPrinter,
    NQ_WCHAR* description,
    NQ_BOOL* isEncrypted
    );

/**
   Get next mount in the list of mounted volumes for Client.

   @param name       Pointer to the share name buffer.
   @param map        Pointer to the share map buffer.
   @return <i>TRUE</i> - more volumes in the list <i>FALSE</i> - no more volumes                                             */
NQ_BOOL
udGetNextMount(
    NQ_WCHAR* name,
    NQ_WCHAR* map
    );

/**
 Get message signing policy CS.
 Values: 0 - disabled, 1 - enabled, 2 - required.

 @param policy  Pointer to policy.
 @returns
  <i>TRUE</i> when implemented <i>FALSE</i> not implemented (use CS default)
 */
NQ_BOOL
udGetMessageSigningPolicy(
        NQ_INT* policy
        );


/**
 Get server global encryption.

 @returns
  <i>TRUE</i> global encryption on  <i>FALSE</i> global encryption off
 */
NQ_BOOL
udGetGlobalEncryption(
        void
        );


#if defined(UD_NQ_INCLUDESMBCAPTURE) || defined(DOXYGEN)
/**
 Determine whether to use internal capture.

 @returns
  <i>TRUE</i> or  <i>FALSE</i>
 */
NQ_BOOL
udGetInternalCapture(
        void
        );

/**
 Get base folder path of internal capture file

 @param buffer  buffer for the path
 @param size  the size of that buffer
 */
void
udGetCaptureFileBaseFolder(
        NQ_CHAR* buffer,
        NQ_UINT  size
        );
#endif /* UD_NQ_INCLUDESMBCAPTURE */

/**
 Determine whether to use internal trace.

 @returns
  <i>TRUE</i> or  <i>FALSE</i>
 */
NQ_BOOL
udGetInternalTrace(
        void
        );

#endif /* ifndef CM_NQ_STORAGE */

/**
 Get task priorities.

 @returns
 Task priority value.
 */
NQ_INT
udGetTaskPriorities(
    void
    );

/**
 Get CIFS driver name.

 @param buffer  Buffer for name
 */
void
udGetDriverName(
    NQ_CHAR* buffer
    );

/**
 Get host name.

 @param buffer  Buffer for name
 @param length  Length to be returned (not null terminated)
 */
void
udGetHostName(
    NQ_CHAR* buffer,
    NQ_UINT length
    );

/**
 Get base folder path of log file

 @param buffer  Buffer for the path
 @param size  The size of that buffer
 */
void
udGetLogFileBaseFolder(
    NQ_CHAR* buffer,
    NQ_UINT  size
    );

/**
 Get disk size limit for shares

 @param size Pointer to size limit
 */
void
udGetMaxDiskSize(
    NQ_UINT32 *size
    );

/** @} end of group functions Functions */

#endif /* _UDAPI_H_ */


