/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : API definition for system-dependent library
 *--------------------------------------------------------------------
 * MODULE        : NQ
 * DEPENDENCIES  :
 ********************************************************************/

#ifndef _SYAPI_H_
#define _SYAPI_H_

#include "udapi.h"      /* project dependent definitions */
#include "sycommon.h"   /* independent definitions */
#include <syinclud.h>   /* system includes here */
#include <sypltfrm.h>   /* platform-dependent definitions   */
#include <syopsyst.h>   /* OS-dependent definitions */
#ifdef UD_CS_INCLUDERPC_SPOOLSS
#include <syprintr.h>   /* printing API */
#endif
#include <sytrace.h>    /* tracing */
#if defined(UD_CC_INCLUDEEXTENDEDSECURITY_KERBEROS) || defined(UD_NQ_INCLUDEKERBEROS)
#include <sysasl.h>     /* GSASL interface */
#endif
#ifdef UD_CC_INCLUDELDAP
/*#include "syldap.h" */    /* ldap */
#endif

/** @defgroup syapi System API
 * @{
 */

/** Initialize SY module.
   @returns
   <i>TRUE</i> on success or <i>FALSE</i> on failure. */
NQ_BOOL syInit(void);

/**
    Shutdown SY module.
 */
void syStop(void);

/** @} end of group syapi System API*/

#endif  /* _SYAPI_H_ */

