/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : CIFS Client configuration definitions
 *--------------------------------------------------------------------
 * MODULE        : Client
 * DEPENDENCIES  : None
 ********************************************************************/

#ifndef _CCCONFIG_H_
#define _CCCONFIG_H_

#include "ccapi.h"
#include "amapi.h"

/* -- Constants -- */
/* Number of reconnects. 
   Description
   This value defines how many times NQ attempts to reestablish a server connection. 
   NQ applies this count when it detects the following combination of conditions:
   * SMB operation failed;
   * Socket becomes disconnected;  
 */
#ifdef UD_CC_CLIENTRETRYCOUNT
#define CC_CONFIG_RETRYCOUNT UD_CC_CLIENTRETRYCOUNT
#else
#define CC_CONFIG_RETRYCOUNT 3
#endif

#ifdef UD_CC_BROWSERETRYCOUNT
#define CC_BROWSE_RETRYCOUNT UD_CC_BROWSERETRYCOUNT
#else
#ifdef CM_NQ_STORAGE
#define CC_BROWSE_RETRYCOUNT 3
#else
#define CC_BROWSE_RETRYCOUNT 1
#endif

#endif

/* max number of credits for client to request */
#ifdef CM_NQ_STORAGE
#define SMB2_CLIENT_MAX_CREDITS_TO_REQUEST 8
#else
#define SMB2_CLIENT_MAX_CREDITS_TO_REQUEST 128
#endif

/* extends the timeout period when STATUS PENDING is sent (multiplies the timeout time by this define) */
#define PENDING_TIMEOUT_EXTENTION 2

/* #define CC_SEARCH_SKIPFILESIFCONTAINSLASHES */ /* skip file if its name contain path separator */


#define CC_MOUNT_NAME_LENGTH   UD_FS_MAXSHARELEN
#define CC_SHARE_PATH_LENGTH   UD_FS_MAX_SHARE_NET_PATH_LEN

/* -- API functions -- */

/* Description
   Initialize this module.
   Returns 
   None.
 */
void ccConfigInit(void);

/* Description
   Release resources used by this module.
   Returns 
   None.
 */
void ccConfigShutdown(void);

#endif /* _CCCONFIG_H_ */
