/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : CIFS Client Initialization
 *--------------------------------------------------------------------
 * MODULE        : Client
 * DEPENDENCIES  : None
 ********************************************************************/

#include "ccmount.h"
#include "ccserver.h"
#include "ccshare.h"
#include "ccfile.h"
#include "ccsearch.h"
#include "ccdfscache.h"
#include "ccdfs.h"
#include "ccutils.h"
#include "cctransport.h"
#include "ccparams.h"
#include "cccifs.h"
#include "ccwrite.h"
#include "ccread.h" 
#ifdef UD_CC_INCLUDERPC
#include "ccdcerpc.h"
#include "ccsrvsvc.h"
#include "ccnetwrk.h"
#ifdef UD_CC_INCLUDESECURITYDESCRIPTORS
#include "ccsdescr.h"
#endif /* UD_CC_INCLUDESECURITYDESCRIPTORS */
#ifdef UD_CC_INCLUDEDOMAINMEMBERSHIP
#include "ccdomain.h"
#endif /* UD_CC_INCLUDEDOMAINMEMBERSHIP */
#endif /* UD_CC_INCLUDERPC */
#include "ccsmb10.h"
#include "ccsmb20.h"
#include "ccsmb30.h"
#include "ccsmb311.h"
#include "ccsecure.h"
#include "nqapi.h"
#include "nsapi.h"
#ifdef UD_CC_INCLUDELDAP
#include "ldapi.h"
#endif /* UD_CC_INCLUDELDAP */
#ifdef UD_CM_INCLUDEWSDCLIENT
#include "wsdclient.h"
#endif /* UD_CM_INCLUDEWSDCLIENT */
#ifdef UD_CC_INCLUDERPCOVERTCP
#include "ccrpc.h"
#endif /* UD_CC_INCLUDERPCOVERTCP */

#ifdef UD_NQ_INCLUDECIFSCLIENT

/* static data */

static NQ_BOOL sCcIsInitialized = FALSE;

/*
 *====================================================================
 * PURPOSE: client module initialization
 *--------------------------------------------------------------------
 * PARAMS:  IN  pointer to handle error notification handler
 *
 * RETURNS: TRUE if succeeded, FALSE otherwise
 *
 * NOTES:  Application can examine the error code for the failure reason
 *====================================================================
 */

NQ_BOOL ccInit(void (*fsdNotify)(NQ_INT eventId, NQ_ULONG param))
{
    NQ_BOOL result = FALSE;
    NQ_INT error = NQ_ERR_OK;

    LOGFB(CM_TRC_LEVEL_FUNC_COMMON, "fsdNotify:%p", fsdNotify);

    if (FALSE == sCcIsInitialized)
    {
        ccConfigInit();

        if (NQ_SUCCESS != nsInit(TRUE, NQ_CLIENT))
        {
            error = (NQ_INT)syGetLastError();
            goto Exit;
        }

        if (   !ccUtilsStart()
            || !ccTransportStart()
            || !ccMountStart()
            || !ccServerStart()
            || !ccUserStart()
            || !ccShareStart()
#ifdef UD_NQ_INCLUDESMB1
            || !ccSmb10Start()
#endif /* UD_NQ_INCLUDESMB1 */
#ifdef UD_NQ_INCLUDESMB2
            || !ccSmb20Start()
#ifdef UD_NQ_INCLUDESMB3
            || !ccSmb30Start()
#ifdef UD_NQ_INCLUDESMB311
            || !ccSmb311Start()
#endif /* UD_NQ_INCLUDESMB311 */
#endif /* UD_NQ_INCLUDESMB3 */
#endif /* UD_NQ_INCLUDESMB2 */
            || !ccCifsStart()
            || !ccFileStart()
            || !ccSecureStart()
            || !ccDfsCacheStart()
            || !amStart()
            || !ccDfsStart()
            || !ccSearchStart()
            || !ccWriteStart()
            || !ccReadStart()
#ifdef UD_CC_INCLUDERPC
            || !ccDcerpcStart()
#ifdef UD_CC_INCLUDERPCOVERTCP
            || !ccDcerpcOverTcpStart()
#endif /* UD_CC_INCLUDERPCOVERTCP */
#ifdef UD_CC_INCLUDESECURITYDESCRIPTORS
            || !ccSdescrStart()
#endif /* UD_CC_INCLUDESECURITYDESCRIPTORS */
            || !ccSrvsvcStart()
#ifdef UD_CC_INCLUDEBROWSING
            || !ccNetworkStart()
#endif /* UD_CC_INCLUDEBROWSING */
#ifdef UD_CC_INCLUDEDOMAINMEMBERSHIP
            || !ccDomainStart()
#endif /* UD_CC_INCLUDEDOMAINMEMBERSHIP */
#endif /* UD_CC_INCLUDERPC */
#ifdef UD_CC_INCLUDELDAP
            || NQ_SUCCESS != ldStart()
#endif /* UD_CC_INCLUDELDAP */
#ifdef UD_CM_INCLUDEWSDCLIENT
            || !wsdClientStart()
#endif /* UD_CM_INCLUDEWSDCLIENT */
            )
        {
            error = (NQ_INT)syGetLastError();
            ccShutdown();
            goto Exit;
        }
 
        sCcIsInitialized = TRUE;
    }
    result = TRUE;

Exit:
    sySetLastError(error);
    LOGFE(CM_TRC_LEVEL_FUNC_COMMON, "result:%s error:0x%x", result ? "TRUE" : "FALSE", syGetLastError());
    return result;
}

/*
 *====================================================================
 * PURPOSE: client module shutdown
 *--------------------------------------------------------------------
 * PARAMS:  NONE
 *
 * RETURNS: NONE
 *
 * NOTES:
 *====================================================================
 */

void ccShutdown(void)
{
    LOGFB(CM_TRC_LEVEL_FUNC_COMMON);

    amShutdown();
#ifdef UD_CC_INCLUDERPC
#ifdef UD_CC_INCLUDEDOMAINMEMBERSHIP
    ccDomainShutdown();
#endif /* UD_CC_INCLUDEDOMAINMEMBERSHIP */
#endif /* UD_CC_INCLUDERPC */
    ccSearchShutdown();
    ccMountShutdown();
    ccServerShutdown();
    ccUserShutdown();
    ccShareShutdown();
    ccCifsShutdown();
    ccUtilsShutdown();
    ccTransportShutdown();
    ccFileShutdown();
    ccDfsShutdown();
    ccDfsCacheShutdown();
#ifdef UD_CC_INCLUDEBROWSING
    ccNetworkShutdown();
#endif /* UD_CC_INCLUDEBROWSING */
    ccWriteShutdown();
    ccReadShutdown();
#ifdef UD_CC_INCLUDERPC
    ccDcerpcShutdown();
#ifdef UD_CC_INCLUDERPCOVERTCP
    ccDcerpcOverTcpShutdown();
#endif /* UD_CC_INCLUDERPCOVERTCP */
#ifdef UD_CC_INCLUDESECURITYDESCRIPTORS
    ccSdescrShutdown();
#endif /* UD_CC_INCLUDESECURITYDESCRIPTORS */
    ccSrvsvcShutdown();
#endif /* UD_CC_INCLUDERPC */
#ifdef UD_NQ_INCLUDESMB1
    ccSmb10Shutdown();
#endif /* UD_NQ_INCLUDESMB1 */
#ifdef UD_NQ_INCLUDESMB2
    ccSmb20Shutdown();
#ifdef UD_NQ_INCLUDESMB3
    ccSmb30Shutdown();
#endif /* UD_NQ_INCLUDESMB3 */
#ifdef UD_NQ_INCLUDESMB311
    ccSmb311Shutdown();
#endif /* UD_NQ_INCLUDESMB3 */
#endif /* UD_NQ_INCLUDESMB2 */
    ccSecureShutdown();
    ccConfigShutdown();
#ifdef UD_CM_INCLUDEWSDCLIENT
    wsdClientShutdown();
#endif /* UD_CM_INCLUDEWSDCLIENT */

    nsExit(TRUE, NQ_CLIENT);
    sCcIsInitialized = FALSE;

    LOGFE(CM_TRC_LEVEL_FUNC_COMMON);
}

/*
 *====================================================================
 * PURPOSE: check if the client module initialized
 *--------------------------------------------------------------------
 * PARAMS:  NONE
 *
 * RETURNS: TRUE if initialized, FALSE otherwise
 *
 * NOTES:
 *====================================================================
 */

NQ_BOOL ccIsInitialized(void)
{
    return sCcIsInitialized;
}

/*
 *====================================================================
 * PURPOSE: dump client module data tables
 *--------------------------------------------------------------------
 * PARAMS:  NONE
 *
 * RETURNS: NONE
 *
 * NOTES:
 *====================================================================
 */

void ccDump(void)
{
#ifdef UD_NQ_INCLUDETRACE
    if (sCcIsInitialized)
    {
        ccMountDump();
    }
#endif /* UD_NQ_INCLUDETRACE */
}

#endif /* UD_NQ_INCLUDECIFSCLIENT */
