/*********************************************************************
*
*           Copyright (c) 2021 by Visuality Systems, Ltd.
*
*********************************************************************
* FILE NAME     : $Workfile:$
* ID            : $Header:$
* REVISION      : $Revision:$
*--------------------------------------------------------------------
* DESCRIPTION   : UUID
*--------------------------------------------------------------------
* MODULE        : Common
* DEPENDENCIES  :
********************************************************************/

#include "cmuuid.h"

#define CMUUID_MAXSTRLENGTH 128

void cmZeroUuid(CMUuid *uuid)
{
    syMemset(uuid, 0, sizeof(*uuid));
}

void cmGenerateUuid(CMUuid *uuid)
{
    cmCreateRandomByteSequence((NQ_BYTE *)uuid, sizeof(*uuid));
}

NQ_BOOL cmUuidIsEqual(const CMUuid *uuid1, const CMUuid *uuid2)
{
    return  ((cmGetSUint16(uuid1->timeHiVersion) == cmGetSUint16(uuid2->timeHiVersion)) &&
            (cmGetSUint32(uuid1->timeLow) == cmGetSUint32(uuid2->timeLow)) && (cmGetSUint16(uuid1->timeMid) == cmGetSUint16(uuid2->timeMid)) &&
            (syMemcmp(uuid1->clockSeq, uuid2->clockSeq, sizeof(uuid1->clockSeq)) == 0) &&
            (syMemcmp(uuid1->node, uuid2->node, sizeof(uuid1->node)) == 0)
            );
}

NQ_CHAR *cmUuidDump(const CMUuid *uuid)
{
    static NQ_CHAR buffer[CMUUID_MAXSTRLENGTH] = {0};

    sySprintf(buffer, "timeLow:0x%x timeMid:0x%x timeHiVersion:0x%x clockSeq:0x%x 0x%x node:0x%x 0x%x 0x%x 0x%x 0x%x 0x%x", cmGetSUint32(uuid->timeLow), cmGetSUint16(uuid->timeMid), cmGetSUint16(uuid->timeHiVersion),
            uuid->clockSeq[0], uuid->clockSeq[1], uuid->node[0], uuid->node[1], uuid->node[2], uuid->node[3], uuid->node[4], uuid->node[5]);
    return buffer;
}

/* UUID to string, caller must free the memory */
NQ_CHAR *cmUuidToString(const CMUuid *uuid)
{
    NQ_CHAR *uuidStr = NULL;

    if (NULL == uuid)
    {
        goto Exit;
    }
    uuidStr = cmMemoryAllocate(CMUUID_MAXSTRLENGTH);
    if (NULL == uuidStr)
    {
        goto Exit;
    }
    sySprintf(uuidStr, "%08x-%04x-%04x-%02x%02x-%02x%02x%02x%02x%02x%02x", cmGetSUint32(uuid->timeLow), cmGetSUint16(uuid->timeMid), cmGetSUint16(uuid->timeHiVersion),
            uuid->clockSeq[0], uuid->clockSeq[1], uuid->node[0], uuid->node[1], uuid->node[2], uuid->node[3], uuid->node[4], uuid->node[5]);

Exit:
    return uuidStr;
}
