/*************************************************************************
 * Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *                     All Rights Reserved
 *
 * This item is the property of Visuality Systems, Ltd., and contains
 * confidential, proprietary, and trade-secret information. It may not
 * be transferred from the custody or control of Visuality Systems, Ltd.,
 * except as expressly authorized in writing by an officer of Visuality
 * Systems, Ltd. Neither this item nor the information it contains may
 * be used, transferred, reproduced, published, or disclosed, in whole
 * or in part, and directly or indirectly, except as expressly authorized
 * by an officer of Visuality Systems, Ltd., pursuant to written agreement.
 *
 *************************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Parsing delimited string
 *--------------------------------------------------------------------
 * MODULE        : Common
 * DEPENDENCIES  :
 *************************************************************************/

#ifndef _CMSTRPARSE_H_
#define _CMSTRPARSE_H_

#include "udapi.h"
#include "cmapi.h"
#include "cmunicod.h"
#include "syapi.h"

typedef struct{
    CMItem  item;
    void    *source;
    void    *nextEntry;
    void    *delimiter;
    NQ_BOOL isUnicode;
    NQ_BOOL isParseFinished;
} CMParsingdata;

NQ_BOOL cmSpStart(void);
void cmSpShutdown(void);
NQ_HANDLE cmSpStartParsing(void * source, void * delimiter, NQ_BOOL isUnicode, void ** firstString, NQ_BOOL findFirstString);
void *cmSpGetNextString(NQ_HANDLE parseHandle);
void cmSpTerminateParsing(NQ_HANDLE parseHandle);

#endif /* _CMMEMORY_H_ */
