/*************************************************************************
 * Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *                     All Rights Reserved
 *
 * This item is the property of Visuality Systems, Ltd., and contains
 * confidential, proprietary, and trade-secret information. It may not
 * be transferred from the custody or control of Visuality Systems, Ltd.,
 * except as expressly authorized in writing by an officer of Visuality
 * Systems, Ltd. Neither this item nor the information it contains may
 * be used, transferred, reproduced, published, or disclosed, in whole
 * or in part, and directly or indirectly, except as expressly authorized
 * by an officer of Visuality Systems, Ltd., pursuant to written agreement.
 *
 *************************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Common repository operations
 *--------------------------------------------------------------------
 * MODULE        : Common
 * DEPENDENCIES  :
 *************************************************************************/

#ifndef _CMREPOSITORY_H_
#define _CMREPOSITORY_H_

#include "cmlist.h"
#include "cmthread.h"

/* repository flags */

/*#define REPOSITORY_DEBUG*/
/*#define REPOSITORY_SIZE_TUNING*/
/*#define REPOSITRY_ZERO_SIZE*/   /* for running with valgrind. each item will be released immidietly and allocated when required */
/*#define REPOSITORY_STATISTICS*/
#ifdef UD_NQ_INCLUDETRACE
#define REPO_MESSAGE_THROTTLING 20
#else
#define REPO_MESSAGE_THROTTLING 100
#endif


#define CM_REPOSITORY_RELEASE_IMMEDIATELY  0x0001  /* used for very large buffers, to be released instead of being returned to repository */

/*
 * if key size is 0 then object is not initialized.
 *
 * */

typedef void (* CMRepositoryItemInit)(CMItem * pItem);
typedef void (* CMRepositoryItemDispose)(CMItem * pItem);

typedef struct {
#if defined (REPOSITORY_DEBUG) || defined (REPOSITORY_SIZE_TUNING) || defined (REPOSITORY_STATISTICS) || (defined(UD_NQ_INCLUDETRACE) && !defined(UD_NQ_DYNAMICALLOCATION))
    NQ_CHAR *   name;
    NQ_UINT32   initialNumItems;
    NQ_UINT32   finalNumItems;
#endif
#ifdef REPOSITORY_DEBUG
    NQ_COUNT    numConsecutiveFails;
    NQ_UINT32   numOfGetNew;
#endif
#if defined (REPOSITORY_DEBUG) || (defined(UD_NQ_INCLUDETRACE) && !defined(UD_NQ_DYNAMICALLOCATION))
    NQ_UINT32   numOfFailed;
    NQ_UINT32   numOfWaitedItems;
#endif /* defined (REPOSITORY_DEBUG) || (defined(UD_NQ_INCLUDETRACE) && !defined(UD_NQ_DYNAMICALLOCATION)) */
    NQ_UINT     numItemsReadyForUse;
    NQ_UINT     numUsedItems;
    NQ_UINT     itemSize;
    CMRepositoryItemInit doInit;
    CMRepositoryItemDispose doDispose;
    SYMutex *   guard;
    CMList      usedItemlist; /* one list */
    CMList      itemPool;
    NQ_BOOL     isUsed;
    NQ_COUNT    numThreadSWaitingForItemRelease; /* when no items, thread will increment and wait, when waiting thread is locking repo and taking item, it will decrement */
    NQ_COUNT    numThreadSWaitingForSignal; /* when no items, thread will increment and wait, when > 0 a releasing thread should signal and decrease. but notice - actual take item by waiting rhread might take a while . */
    NQ_UINT16   flags;
    NQ_BOOL     extend;
    CMThreadCond resoCond;
#ifdef REPOSITORY_STATISTICS
    NQ_UINT32   totalTimeWaited;
    NQ_UINT32   maxTimeWaited;
#endif /* REPOSITORY_STATISTICS */
} CMRepository;

/* */
typedef struct {
    CMItem item;
#ifdef REPOSITORY_DEBUG
    NQ_UINT     DebugData1;
    NQ_UINT     DebugData2;
#endif /* REPOSITORY_DEBUG */
}CMRepoItem;

void cmSetDynamicAllocation(NQ_BOOL value);
NQ_BOOL cmGetDynamicAllocation(void);

NQ_BOOL cmRepositoryInit(
        CMRepository * pRepo,
        NQ_UINT16 flags,
        CMRepositoryItemInit doInit,
        CMRepositoryItemDispose doDispose,
        const NQ_CHAR *repoName);

NQ_BOOL cmRepositoryItemPoolAlloc(CMRepository * pRepo , NQ_UINT preallocateNum , NQ_UINT size);

/*Key size is 0, dynamically allocated table is freed with all of its items */
void cmRepositoryShutdown(CMRepository * pRepo);

CMItem *cmRepositoryGetNewItem(CMRepository * pRepo);

#ifdef REPOSITORY_DEBUG
void cmRepositoryAddDebugData(CMItem *_pItem, NQ_UINT debugData1, NQ_UINT debugData2);
#endif /* REPOSITORY_DEBUG */

NQ_BOOL cmRepositoryAddItem(CMRepository * pRepo , CMRepoItem * pItem , NQ_BYTE * key , NQ_BOOL (*callback)(CMItem * pItem) );

NQ_BOOL cmRepositoryReleaseItem(CMRepository * pRepo , CMItem * pItem );

void cmRepositoryIteratorStart(CMRepository * pRepo , CMIterator * iterator);

void cmRepositoryIteratorTerminate(CMRepository * pRepo , CMIterator * iterator);

CMItem * cmRepositoryIteratorNext(CMIterator * iterator);

#define cmRepositoryIteratorHasNext(_iterator_)     ((_iterator_)->next != NULL)

#define cmRepositoryGetSize(_repo)      ((_repo && ((CMRepository *)(_repo))->isUsed) ? ((CMRepository * )(_repo))->itemSize : 0)

#endif /*_CMREPOSITORY_H_*/



