/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Codepage 437
 *--------------------------------------------------------------------
 * MODULE        : Common
 * DEPENDENCIES  :
 ********************************************************************/

#include "cmapi.h"
#include "cmcp.h"

#ifdef UD_NQ_CODEPAGE437

static const NQ_WCHAR a2u[0x100] = {
    /* 0.. 0x7F are identical to unicode */
    0x00c7, 0x00fc, 0x00e9, 0x00e2, 0x00e4, 0x00e0, 0x00e5, 0x00e7,
    0x00ea, 0x00eb, 0x00e8, 0x00ef, 0x00ee, 0x00ec, 0x00c4, 0x00c5,
    0x00c9, 0x00e6, 0x00c6, 0x00f4, 0x00f6, 0x00f2, 0x00fb, 0x00f9,
    0x00ff, 0x00d6, 0x00dc, 0x00a2, 0x00a3, 0x00a5, 0x20a7, 0x0192,
    0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x00f1, 0x00d1, 0x00aa, 0x00ba,
    0x00bf, 0x2310, 0x00ac, 0x00bd, 0x00bc, 0x00a1, 0x00ab, 0x00bb,
    0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2561, 0x2562, 0x2556,
    0x2555, 0x2563, 0x2551, 0x2557, 0x255d, 0x255c, 0x255b, 0x2510,
    0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x255e, 0x255f,
    0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x2567,
    0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552, 0x2553, 0x256b,
    0x256a, 0x2518, 0x250c, 0x2588, 0x2584, 0x258c, 0x2590, 0x2580,
    0x03b1, 0x00df, 0x0393, 0x03c0, 0x03a3, 0x03c3, 0x00b5, 0x03c4,
    0x03a6, 0x0398, 0x03a9, 0x03b4, 0x221e, 0x03c6, 0x03b5, 0x2229,
    0x2261, 0x00b1, 0x2265, 0x2264, 0x2320, 0x2321, 0x00f7, 0x2248,
    0x00b0, 0x2219, 0x00b7, 0x221a, 0x207f, 0x00b2, 0x25a0, 0x00a0
};

static NQ_WCHAR u2a_00[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* a */ 0xff, 0xad, 0x9b, 0x9c, 0x0f, 0x9d, 0xdd, 0x15, 0x22, 0x63, 0xa6, 0xae, 0xaa, 0x2d, 0x72, 0x5f,
/* b */ 0xf8, 0xf1, 0xfd, 0x33, 0x27, 0xe6, 0x14, 0xfa, 0x2c, 0x31, 0xa7, 0xaf, 0xac, 0xab, 0x5f, 0xa8,
/* c */ 0x41, 0x41, 0x41, 0x41, 0x8e, 0x8f, 0x92, 0x80, 0x45, 0x90, 0x45, 0x45, 0x49, 0x49, 0x49, 0x49,
/* d */ 0x44, 0xa5, 0x4f, 0x4f, 0x4f, 0x4f, 0x99, 0x78, 0x4f, 0x55, 0x55, 0x55, 0x9a, 0x59, 0x5f, 0xe1,
/* e */ 0x85, 0xa0, 0x83, 0x61, 0x84, 0x86, 0x91, 0x87, 0x8a, 0x82, 0x88, 0x89, 0x8d, 0xa1, 0x8c, 0x8b,
/* f */ 0x64, 0xa4, 0x95, 0xa2, 0x93, 0x6f, 0x94, 0xf6, 0x6f, 0x97, 0xa3, 0x96, 0x81, 0x79, 0x5f, 0x98
};

static NQ_WCHAR u2a_01[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* 0 */ 0x41, 0x61, 0x41, 0x61, 0x41, 0x61, 0x43, 0x63, 0x43, 0x63, 0x43, 0x63, 0x43, 0x63, 0x44, 0x64,
/* 1 */ 0x44, 0x64, 0x45, 0x65, 0x45, 0x65, 0x45, 0x65, 0x45, 0x65, 0x45, 0x65, 0x47, 0x67, 0x47, 0x67,
/* 2 */ 0x47, 0x67, 0x47, 0x67, 0x48, 0x68, 0x48, 0x68, 0x49, 0x69, 0x49, 0x69, 0x49, 0x69, 0x49, 0x69,
/* 3 */ 0x49, 0x69, 0x3f, 0x3f, 0x4a, 0x6a, 0x4b, 0x6b, 0x3f, 0x4c, 0x6c, 0x4c, 0x6c, 0x4c, 0x6c, 0x3f,
/* 4 */ 0x3f, 0x4c, 0x6c, 0x4e, 0x6e, 0x4e, 0x6e, 0x4e, 0x6e, 0x3f, 0x3f, 0x3f, 0x4f, 0x6f, 0x4f, 0x6f,
/* 5 */ 0x4f, 0x6f, 0x4f, 0x6f, 0x52, 0x72, 0x52, 0x72, 0x52, 0x72, 0x53, 0x73, 0x53, 0x73, 0x53, 0x73,
/* 6 */ 0x53, 0x73, 0x54, 0x74, 0x54, 0x74, 0x54, 0x74, 0x55, 0x75, 0x55, 0x75, 0x55, 0x75, 0x55, 0x75,
/* 7 */ 0x55, 0x75, 0x55, 0x75, 0x57, 0x77, 0x59, 0x79, 0x59, 0x5a, 0x7a, 0x5a, 0x7a, 0x5a, 0x7a, 0x3f,
/* 8 */ 0x62, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x44, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 9 */ 0x3f, 0x9f, 0x9f, 0x3f, 0x3f, 0x3f, 0x3f, 0x49, 0x3f, 0x3f, 0x6c, 0x3f, 0x3f, 0x3f, 0x3f, 0x4f,
/* a */ 0x4f, 0x6f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0xe4, 0x3f, 0x74, 0x3f, 0x3f, 0x54, 0x55,
/* b */ 0x75, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x7a, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* c */ 0x7c, 0x3f, 0x3f, 0x21, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x41, 0x61, 0x49,
/* d */ 0x69, 0x4f, 0x6f, 0x55, 0x75, 0x55, 0x75, 0x55, 0x75, 0x55, 0x75, 0x55, 0x75, 0x3f, 0x41, 0x61,
/* e */ 0x3f, 0x3f, 0x3f, 0x3f, 0x47, 0x67, 0x47, 0x67, 0x4b, 0x6b, 0x4f, 0x6f, 0x4f, 0x6f, 0x3f, 0x3f,
/* f */ 0x6a
};

static NQ_WCHAR u2a_02[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* b */                                                       0x27, 0x22, 0x3f, 0x27, 0x3f, 0x3f, 0x3f,
/* c */ 0x3f, 0x3f, 0x3f, 0x3f, 0x5e, 0x3f, 0x5e, 0x3f, 0x27, 0xc4, 0x27, 0x60, 0x3f, 0x5f, 0x3f, 0x3f,
/* d */ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0xf8, 0x3f, 0x7e
};

static NQ_WCHAR u2a_03[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* 0 */ 0x60, 0x27, 0x5e, 0x7e, 0xc4, 0x3f, 0x3f, 0x3f, 0x22, 0x3f, 0xf8, 0x3f, 0x3f, 0x3f, 0x22, 0x3f,
/* 1 */ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 2 */ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x2c, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 3 */ 0x3f, 0x5f, 0x5f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 9 */ 0x3f, 0xe0, 0x3f, 0xe2, 0xeb, 0xee, 0x3f, 0x3f, 0xe9, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* a */ 0xe3, 0x3f, 0x3f, 0xe4, 0xe7, 0x3f, 0xe8, 0x3f, 0x3f, 0xea, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* b */ 0x3f, 0xe0, 0xe1, 0x3f, 0xeb, 0xee, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0xe6, 0x3f, 0x3f, 0x3f,
/* c */ 0xe3, 0x3f, 0x3f, 0xe5, 0xe7, 0x3f, 0xed
};

static NQ_WCHAR u2a_20[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* 0 */ 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 1 */ 0x2d, 0x2d, 0x3f, 0x2d, 0x2d, 0x3f, 0x3f, 0x5f, 0x60, 0x27, 0x2c, 0x3f, 0x22, 0x22, 0x2c, 0x3f,
/* 2 */ 0x2b, 0xd8, 0x07, 0x3f, 0xfa, 0x3f, 0x2e, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 3 */ 0x25, 0x3f, 0x27, 0x3f, 0x3f, 0x60, 0x3f, 0x3f, 0x3f, 0x3c, 0x3e, 0x3f, 0x13, 0x3f, 0x3f, 0x3f,
/* 4 */ 0x3f, 0x3f, 0x3f, 0x3f, 0x2f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 5 */ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 6 */ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 7 */ 0xf8, 0x3f, 0x3f, 0x3f, 0x34, 0x35, 0x36, 0x37, 0x38, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0xfc,
/* 8 */ 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 9 */ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* a */ 0x3f, 0x3f, 0x3f, 0x3f, 0x9c, 0x3f, 0x3f, 0x9e
};

static NQ_WCHAR u2a_21[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* 0 */             0x43, 0x3f, 0x3f, 0x3f, 0x3f, 0x45, 0x3f, 0x3f, 0x67, 0x48, 0x48, 0x48, 0x68, 0x3f,
/* 1 */ 0x49, 0x49, 0x4c, 0x6c, 0x3f, 0x4e, 0x3f, 0x3f, 0x50, 0x50, 0x51, 0x52, 0x52, 0x52, 0x3f, 0x3f,
/* 2 */ 0x3f, 0x3f, 0x54, 0x3f, 0x5a, 0x3f, 0xea, 0x3f, 0x5a, 0x3f, 0x4b, 0x8f, 0x42, 0x43, 0x65, 0x65,
/* 3 */ 0x45, 0x46, 0x3f, 0x4d, 0x6f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 9 */ 0x1b, 0x18, 0x1a, 0x19, 0x1d, 0x12
};

static NQ_WCHAR u2a_22[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* 0 */                               0xed, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 1 */ 0x3f, 0xe4, 0x2d, 0xf1, 0x3f, 0x2f, 0x5c, 0x2a, 0xf8, 0xf9, 0xfb, 0x3f, 0x3f, 0x3f, 0xec, 0x1c,
/* 2 */ 0x3f, 0x3f, 0x3f, 0x7c, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0xef, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 3 */ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3a, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x7e, 0x3f, 0x3f, 0x3f,
/* 4 */ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0xf7, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 5 */ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 6 */ 0x3f, 0xf0, 0x3f, 0x3f, 0xf3, 0xf2, 0x3f, 0x3f, 0x3f, 0x3f, 0xae, 0xaf
};

static NQ_WCHAR u2a_23[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* 0 */             0x7f, 0x5e, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 1 */ 0xa9, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 2 */ 0xf4, 0xf5, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3c, 0x3e
};

static NQ_WCHAR u2a_25[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* 0 */ 0xc4, 0x3f, 0xb3, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0xda, 0x3f, 0x3f, 0x3f,
/* 1 */ 0xbf, 0x3f, 0x3f, 0x3f, 0xc0, 0x3f, 0x3f, 0x3f, 0xd9, 0x3f, 0x3f, 0x3f, 0xc3, 0x3f, 0x3f, 0x3f,
/* 2 */ 0x3f, 0x3f, 0x3f, 0x3f, 0xb4, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0xc2, 0x3f, 0x3f, 0x3f,
/* 3 */ 0x3f, 0x3f, 0x3f, 0x3f, 0xc1, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0xc5, 0x3f, 0x3f, 0x3f,
/* 4 */ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 5 */ 0xcd, 0xba, 0xd5, 0xd6, 0xc9, 0xb8, 0xb7, 0xbb, 0xd4, 0xd3, 0xc8, 0xbe, 0xbd, 0xbc, 0xc6, 0xc7,
/* 6 */ 0xcc, 0xb5, 0xb6, 0xb9, 0xd1, 0xd2, 0xcb, 0xcf, 0xd0, 0xca, 0xd8, 0xd7, 0xce, 0x3f, 0x3f, 0x3f,
/* 7 */ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 8 */ 0xdf, 0x3f, 0x3f, 0x3f, 0xdc, 0x3f, 0x3f, 0x3f, 0xdb, 0x3f, 0x3f, 0x3f, 0xdd, 0x3f, 0x3f, 0x3f,
/* 9 */ 0xde, 0xb0, 0xb1, 0xb2, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* a */ 0xfe, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x16, 0x3f, 0x3f, 0x3f,
/* b */ 0x3f, 0x3f, 0x1e, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x10, 0x3f, 0x1f, 0x3f, 0x3f, 0x3f,
/* c */ 0x3f, 0x3f, 0x3f, 0x3f, 0x11, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x09, 0x3f, 0x3f, 0x3f, 0x3f,
/* d */ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x08, 0x0a
};

static NQ_WCHAR u2a_26[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* 3 */                                                             0x01, 0x02, 0x0f, 0x3f, 0x3f, 0x3f,
/* 4 */ 0x0c, 0x3f, 0x0b, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 5 */ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
/* 6 */ 0x06, 0x3f, 0x3f, 0x05, 0x3f, 0x03, 0x04, 0x3f, 0x3f, 0x3f, 0x0d, 0x0e
};

static NQ_WCHAR u2a_30[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* 0 */ 0x20, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x09, 0x3c, 0x3e, 0xae, 0xaf, 0x3f, 0x3f, 0x3f, 0x3f,
/* 1 */ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x5b, 0x5d, 0x3f, 0x3f, 0x3f, 0x3f
};

static NQ_WCHAR u2a_FF[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* 0 */       0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
/* 1 */ 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
/* 2 */ 0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
/* 3 */ 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
/* 4 */ 0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
/* 5 */ 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e
};


NQ_INT
cp437UnicodeToAnsi(
    NQ_CHAR* outStr,
    NQ_UINT outLength,
    const NQ_WCHAR* inWStr,
    NQ_UINT inLength
    )
{
    const NQ_WCHAR* pW = inWStr;
    NQ_CHAR* pA = outStr;
    NQ_INT length = 0;
    NQ_UINT inNumOfCharacters;
    NQ_BOOL ignoreInLength = (inLength == CM_IGNORE_LENGTH);
    NQ_BOOL ignoreOutLength = (outLength == CM_IGNORE_LENGTH);

    inNumOfCharacters = inLength / sizeof(NQ_WCHAR);  /* calculate number of characters for source buffer */
    outLength--;                                      /* reserve place for trailing zero */
    if (outStr && inWStr)
    {
        for ( ; *pW && (ignoreInLength || (inNumOfCharacters > 0)) && (ignoreOutLength || (length < (NQ_INT)outLength)); pA++, pW++, inNumOfCharacters--, length++ )
        {
            /* extract Msb in wStr */
            NQ_BYTE wLsb, wMsb;
            cmSplitUnicode (*pW, &wMsb, &wLsb);

            *pA = 0x3f;

            switch (wMsb)
            {
                case 0x00:             
                    if (wLsb < 0x80)                    *pA = (NQ_CHAR)wLsb;
                    if (wLsb > 0x9F)                    *pA = (NQ_CHAR)u2a_00[wLsb - 0xA0];
                    break;
                case 0x01:
                    if (wLsb < 0xF1)                    *pA = (NQ_CHAR)u2a_01[wLsb];
                    break;
                case 0x02:
                    switch(wLsb)
                    {
                        case 0x61:                      *pA = (NQ_CHAR)0x67; break;
                        case 0x78:                      *pA = (NQ_CHAR)0xED; break;
                    }
                    if (wLsb > 0xB8 && wLsb < 0xDD)     *pA = (NQ_CHAR)u2a_02[wLsb - 0xB9];
                    break;
                case 0x03:
                    if (wLsb == 0x7E)                   *pA = (NQ_CHAR)0x3B;
                    if (wLsb < 0x33)                    *pA = (NQ_CHAR)u2a_03[wLsb];
                    if (wLsb > 0x90 && wLsb < 0xC7)     *pA = (NQ_CHAR)u2a_03[wLsb - 0x50];
                    break;   
                case 0x04:
                    if (wLsb == 0xBB)                   *pA = (NQ_CHAR)0x68;
                    break;
                case 0x05:
                    if (wLsb == 0x89)                   *pA = (NQ_CHAR)0x3A;
                    break;
                case 0x06:
                    if (wLsb == 0x6A)                   *pA = (NQ_CHAR)0x25;
                    break;
                case 0x20:
                    if (wLsb < 0xA8)                    *pA = (NQ_CHAR)u2a_20[wLsb];
                    if (wLsb == 0xDD)                   *pA = (NQ_CHAR)0x09;
                    break;
                case 0x21:
                    if (wLsb > 0x01 && wLsb < 0x35)     *pA = (NQ_CHAR)u2a_21[wLsb - 0x02];
                    if (wLsb > 0x8F && wLsb < 0x96)     *pA = (NQ_CHAR)u2a_21[wLsb - 0x52];
                    if (wLsb == 0xA8)                   *pA = (NQ_CHAR)0x17;
                    break;
                case 0x22:
                    if (wLsb > 0x04 && wLsb < 0x6C)     *pA = (NQ_CHAR)u2a_22[wLsb - 0x05];
                    if (wLsb == 0xC5)                   *pA = (NQ_CHAR)0xFA;
                    break; 
                case 0x23:
                    if (wLsb > 0x01 && wLsb < 0x2B)     *pA = (NQ_CHAR)u2a_23[wLsb - 0x02];
                    break;
                case 0x25:
                    if (wLsb < 0xDA)                    *pA = (NQ_CHAR)u2a_25[wLsb];
                    break; 
                case 0x26:
                    if (wLsb > 0x39 && wLsb < 0x6C)     *pA = (NQ_CHAR)u2a_26[wLsb - 0x3A];
                    break; 
                case 0x27:
                    switch(wLsb)
                    {
                        case 0x13:                      *pA = (NQ_CHAR)0xFB; break;
                        case 0x58:                      *pA = (NQ_CHAR)0x7C; 
                    }
                    break; 
                case 0x30:
                    if (wLsb < 0x1C)                    *pA = (NQ_CHAR)u2a_30[wLsb];
                    if (wLsb == 0xFB)                   *pA = (NQ_CHAR)0xFA;
                    break;   
                case 0xFF:
                    if (wLsb > 0x00 && wLsb < 0x5F)     *pA = (NQ_CHAR)u2a_FF[wLsb - 0x01];
                    break;                     
            }
        }
    }
    else
    {
        if (!outStr)
        {
            length = 0;
            goto Exit;
        }
    }

    /* Place trailing zero */
        *pA = '\0';

Exit:
    return length;
}
/*
NQ_INT
cp437AnsiToUnicode(
    NQ_WCHAR* outWStr,
    NQ_UINT outLength,
    const NQ_CHAR* inStr,
    NQ_UINT inLength
    )
{
    return cmCpSingleByteAnsiToUnicode(outWStr, outLength, inStr, inLength, a2u);
}
*/
NQ_INT
cp437ToUpper(
    NQ_CHAR* dst,
    const NQ_CHAR* src
    )
{
    *dst = syToupper(*src);
    return 1;
}

static const CMCodepage enc437 = {
    UD_NQ_CODEPAGE437,
    cp437UnicodeToAnsi,
    NULL,
    cp437ToUpper,
    NULL,
    NULL,
    a2u
};

const CMCodepage* cmCpInit437(
    void
    )
{
    return &enc437;
}

#endif
