/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Name Daemon Interface
 *--------------------------------------------------------------------
 * MODULE        : NQ
 * DEPENDENCIES  :
 ********************************************************************/

#ifndef _NDAPI_H_
#define _NDAPI_H_

#include "cmapi.h"
#include <ndadaptr.h>

/** @defgroup ndapi NetBIOS Daemon
 * @{
 */

/** Startup point for NetBIOS Daemon.
   @param sem  Pointer to semaphore
   @returns
   <i>NQ_SUCCESS</i> when the daemon has started and <i>NQ_FAIL</i>
   when it failed to start.                                         */
NQ_STATUS ndStart(
#if defined(SY_SEMAPHORE_AVAILABLE) || defined(DOXYGEN)
        SYSemaphore * sem
#endif /* SY_SEMAPHORE_AVAILABLE */
        );

/** Shutdown point for NetBIOS Daemon.
*/
void ndStop(void);

/** Notification about a change in the network configuration.
 * The application may call this function when the list of adapters changes or when wins servers are updated.
 * This call causes NetBIOS Daemon to reload the list of adapters and send new registrations to WINS servers.
 */
void ndNotifyConfigurationChange(NDAdapterInfo* adapter);

/** @} end of group ndapi NetBIOS Daemon */

#endif  /* _NDAPI_H_ */
