/*************************************************************************
 * Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *                     All Rights Reserved
 *
 * This item is the property of Visuality Systems, Ltd., and contains
 * confidential, proprietary, and trade-secret information. It may not
 * be transferred from the custody or control of Visuality Systems, Ltd.,
 * except as expressly authorized in writing by an officer of Visuality
 * Systems, Ltd. Neither this item nor the information it contains may
 * be used, transferred, reproduced, published, or disclosed, in whole
 * or in part, and directly or indirectly, except as expressly authorized
 * by an officer of Visuality Systems, Ltd., pursuant to written agreement.
 *
 *************************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : EPMAP
 *--------------------------------------------------------------------
 * MODULE        : Client, RPC
 * DEPENDENCIES  :
 *************************************************************************/

#ifndef _CCEPM_H_
#define _CCEPM_H_

#include "nqapi.h"
#include "ccapi.h"
#include "ccdcerpc.h"

/**
 * Get IP and port on server for specific RPC pipe.
 * EPMAP RPC over TCP communication is used.
 *  *
 * @param server        Server name
 * @param pipeDesc      Pointer to RPC pipe descriptor
 * @param ip            Pointer to result IP
 * @param port          Pointer to result port
 * @return NQ_SUCCESS or NQ_FAIL
 */
NQ_STATUS ccEpmapperGetPort(const NQ_WCHAR *server, const CCDcerpcPipeDescriptor *pipeDesc, NQ_IPADDRESS *ip, NQ_PORT *port);

#endif /* _CCEPM_H_ */
