/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : User-defined NQ configuration
 *--------------------------------------------------------------------
 * MODULE        : Linux - UD
 * DEPENDENCIES  :
 ********************************************************************/

#ifndef _UDCONFIG_H_
#define _UDCONFIG_H_

/* Those 2 lines are used to stringify the expansion of a macro argument */
#define NQ_STRINGIFY(x)     #x
#define NQ_TOSTRING(x)      NQ_STRINGIFY(x)

#ifndef CONFIGPATH
#define NQ_CONFIGPATH       "./config"
#else
#define NQ_CONFIGPATH       NQ_TOSTRING(CONFIGPATH)
#endif /* NQ_CONFIGPATH */
/*#define UD_PRINT_STARTUP_INFO */  /* print startup info */

/*
    Debug mode
    ----------

 Debug mode is differently defined in different compilers.
 NQ sources use the following condition blocks:

 #ifdef NQDEBUG
    <debug code>
 #endif

 */

/* #define NQDEBUG */

/* initialize UD module */

NQ_STATUS                 /* NQ_SUCCESS or NQ_FAIL */
udDefInit(
    void
    );

/* stop UD module */

void
udDefStop(
    void
    );


/* reset server parameters */

void
udDefResetServerParams(
    void
    );

/* get the system's Scope ID */

void
udDefGetScopeID(
    NQ_WCHAR *buffer        /* buffer for the result */
    );

/* get wins addresses information */

void              /* wins addresses in NBO or 0 */
udDefGetWins(
    NQ_WCHAR *pServers        /* The WINS servers IP addresses */
    );

/* get domain name */

void
udDefGetDomain(
    NQ_WCHAR *buffer,       /* buffer for the result */
    NQ_BOOL *isWorkgroup    /* TRUE if the name is a workgroup name */
    );

#if defined(UD_NQ_USETRANSPORTIPV4) || defined(UD_NQ_USETRANSPORTIPV6)
/* get DNS initialization parameters */

void
udDefGetDnsParams(
    NQ_WCHAR *domain,       /* The default domain target belongs to */
    NQ_WCHAR *server        /* The DNS server IP address */
    );
#endif /* defined(UD_NQ_USETRANSPORTIPV4) || defined(UD_NQ_USETRANSPORTIPV6) */

/* get authentication parameters for CC */
NQ_BOOL                     /* TRUE - got credentials, FALSE - failed */
udDefGetCredentials(
    const void* resource,   /* URI about to connect to */
    NQ_WCHAR* userName,     /* buffer for user name */
    NQ_WCHAR* password,     /* buffer for password */
    NQ_WCHAR* domain        /* buffer for domain name */
    );

/* get next share in the list of shares for Server (extended) */

NQ_BOOL                     /* TRUE - a share read FALSE - no more shares */
udDefGetNextShareEx(
    NQ_WCHAR* name,         /* buffer for share name */
    NQ_WCHAR* map,          /* buffer for the map path */
    NQ_BOOL* isPrinter,     /* 0 for file system, 1 for print queue */
    NQ_WCHAR* description,  /* buffer for the share description */
    NQ_BOOL* isEncrypted    /* 0 for regular share, 1 for encrypted share (SMB3) */
    );

/* get next mount in the list of mounted volumes for Client */

NQ_BOOL                     /* TRUE more volumes in the list, FALSE when no more volumes available */
udDefGetNextMount(
    NQ_WCHAR* name,         /* buffer for volume name */
    NQ_WCHAR* map           /* buffer for the map path */
    );

/* get message signing policy */

NQ_BOOL                     /* TRUE - when implemented FALSE - not implemented (use NQ default) */
udDefGetMessageSigningPolicy(
        NQ_INT* policy      /* 0 - disabled, 1 - enabled, 2 - required */
        );

/* get server global encryption */

NQ_BOOL                     /* TRUE - global encryption, FALSE - no global encryption */
udDefGetGlobalEncryption(
        void
        );

#ifdef UD_NQ_INCLUDESMBCAPTURE
/* whether to use internal capture */

NQ_BOOL                     /* TRUE  or FALSE */
udDefGetInternalCapture(
        void
        );

/* get base folder path of internal capture file */
void
udDefGetCaptureFileBaseFolder(
    NQ_CHAR* buffer,       /* buffer for the path */
    NQ_UINT  size          /* buffer size */
    );
#endif /* UD_NQ_INCLUDESMBCAPTURE */

/* whether to use internal trace */

NQ_BOOL                     /* TRUE  or FALSE */
udDefGetInternalTrace(
        void
        );

/* check password for a specific user */

NQ_INT              /* See values in udapi.h */
udDefGetPassword(
    const NQ_WCHAR* userName,   /* user name */
    NQ_CHAR* password,          /* buffer for password */
    NQ_BOOL* pwdIsHashed,       /* TRUE - password hashed, FALSE - plain text */
    NQ_UINT32* userNumber       /* >1000 for administrators */
    );

/* reads last system error and tries to convert it to an SMB error */

NQ_UINT32                   /* SMB error or 0 to use the default conversion */
udDefGetSmbError(
    void
    );

/* query user-defined security descriptor */

int                         /* returns descriptor length */
udDefGetSecurityDescriptor(
    NQ_INT file,            /* ID of an opened file */
    NQ_INT32 information,   /* descriptor to get */
    void* buffer            /* output buffer */
    );

/* write user-defined security descriptor */

NQ_INT                      /* returns 1 on success, 0 on error */
udDefSetSecurityDescriptor(
    NQ_INT file,            /* ID of an opened file */
    NQ_INT32 information,   /* descriptor to set */
    const void* buffer,     /* input buffer */
    NQ_COUNT len            /* descriptor length */
    );

/* get task priorities */

NQ_INT
udDefGetTaskPriorities(
    void
    );

/* get server comment string */

void
udDefGetServerComment(
    NQ_WCHAR *buffer        /* buffer for the result */
    );

/* get CIFS driver name */

void
udDefGetDriverName(
    NQ_CHAR *buffer         /* buffer for the result */
    );

#ifdef UD_NQ_INCLUDECODEPAGE

/* get the current code page */

NQ_INT
udDefGetCodePage(
    void
    );

/* set the current code page */

void
udDefSetCodePage(
    NQ_INT codePage
    );

#endif /* UD_NQ_INCLUDECODEPAGE */

/* allocate buffer in the user space */

NQ_BYTE*
udDefAllocateBuffer(
    NQ_INT idx,         /* buffer index zero based */
    NQ_COUNT numBufs,   /* total number of buffers to be allocated */
    NQ_UINT bufferSize  /* buffer size in bytes */
    );

#if defined(UD_CS_INCLUDESECURITYDESCRIPTORS) || defined(UD_CC_INCLUDESECURITYDESCRIPTORS) || defined (UD_CC_INCLUDEDOMAINMEMBERSHIP) || defined(UD_CS_INCLUDEPASSTHROUGH)

/* get unique ID for the current machine */

void
udDefGetComputerId(
    NQ_BYTE* buf        /* 12 - byte buffer to be filled with unique value */
    );

/* Get persistent security descriptor for share */

NQ_COUNT                        /* SD length or zero on error */
udDefLoadShareSecurityDescriptor(
    const NQ_WCHAR* shareName,  /* share name */
    NQ_BYTE* buffer,            /* buffer to read SD in */
    NQ_COUNT bufferLen          /* buffer length */
    );

/* Save persistent security descriptor for share */

void
udDefSaveShareSecurityDescriptor(
    const NQ_WCHAR* shareName,  /* share name */
    const NQ_BYTE* sd,          /* pointer to SD */
    NQ_COUNT sdLen              /* SD length */
    );

#ifdef UD_CS_INCLUDELOCALUSERMANAGEMENT

/* get number of local users */

NQ_COUNT                        /* number of local users */
udDefGetUserCount(
    void
    );

/* get user ID by name */

NQ_BOOL                         /* TRUE when user was found */
udDefGetUserRidByName(
    const NQ_WCHAR* name,       /* user name */
    NQ_UINT32* rid              /* buffer for user ID */
    );

/* get user name by ID */

NQ_BOOL                         /* TRUE when user was found */
udDefGetUserNameByRid(
    NQ_UINT32 rid,              /* user id */
    NQ_WCHAR* nameBuffer,       /* buffer for user name */
    NQ_WCHAR* fullNamebuffer    /* buffer for full user name */
    );

/* enumerate users */

NQ_BOOL                         /* TRUE when user was available */
udDefGetUserInfo(
    NQ_UINT index,              /* user index (zero based) */
    NQ_UINT32* rid,             /* user id */
    NQ_WCHAR* name,             /* buffer for user name */
    NQ_WCHAR* fullName,         /* buffer for full user name */
    NQ_WCHAR* description       /* buffer for full user name */
    );

/* modify user */

NQ_BOOL                        /* TRUE when user was added/modified */
udDefSetUserInfo(
    NQ_UINT32 rid,                  /* user RID */
    const NQ_WCHAR* name,           /* user name */
    const NQ_WCHAR* fullName,       /* full user name */
    const NQ_WCHAR* description,    /* buffer for full user name */
    const NQ_WCHAR* password        /* Unicode text password or NULL */
    );

/* add user */

NQ_BOOL                        /* TRUE when user was added/modified */
udDefCreateUser(
    const NQ_WCHAR* name,           /* user name */
    const NQ_WCHAR* fullName,       /* full user name */
    const NQ_WCHAR* description     /* user description */
    );

/* set user administrative rights */

NQ_BOOL                     /* TRUE when opration succeeded */
udDefSetUserAsAdministrator(
    NQ_UINT32 rid,          /* user RID */
    NQ_BOOL    isAdmin      /* TRUE to set user as administrator */
    );

/* remove user */

NQ_BOOL                     /* TRUE when user was deleted */
udDefDeleteUserByRid(
    NQ_UINT32 rid           /* user RID */
    );

#endif /* UD_CS_INCLUDELOCALUSERMANAGEMENT */

#endif /* defined(UD_CS_INCLUDESECURITYDESCRIPTORS) || defined(UD_CC_INCLUDESECURITYDESCRIPTORS) || defined (UD_CC_INCLUDEDOMAINMEMBERSHIP) || defined(UD_CS_INCLUDEPASSTHROUGH)*/


#ifdef UD_CS_INCLUDERPC_SRVSVC_EXTENSION

/* modify/create share information in a persistent store */

NQ_BOOL
udDefSaveShareInformation(
    const NQ_WCHAR* name,           /* share to modify or NULL for a new share */
    const NQ_WCHAR* newName,        /* new share name */
    const NQ_WCHAR* newMap,         /* new share path */
    const NQ_WCHAR* newDescription  /* new share description */
    );

/* remove share from the persistent store */

NQ_BOOL
udDefRemoveShare(
    const NQ_WCHAR* name            /* share to remove */
    );

#endif /* UD_CS_INCLUDERPC_SRVSVC_EXTENSION */

#ifdef UD_NQ_INCLUDEEVENTLOG

/*  event log */

void
udDefEventLog (
    NQ_UINT module,                 /* NQ module that originated this event */
    NQ_UINT eventClass,             /* event class */
    NQ_UINT type,                   /* event type */
    const NQ_WCHAR* userName,       /* name of the user */
    const NQ_IPADDRESS* pIp,        /* next side IP address */
    NQ_UINT32 status,               /* zero if the operation has succeeded or error code on failure
                                       for server event this code is the same that will be transmitted
                                       to the client
                                       for an NQ CIFS client event this value is the same
                                       that will be installed as system error */
    const NQ_BYTE* parameters       /* pointer to a structure that is filled with event data
                                       actual structure depends on event type */
    );

#endif /* UD_NQ_INCLUDEEVENTLOG */

/*
 *=====================================================================
 * DESCRIPTION: function that is used to set client's credentials.
 * --------------------------------------------------------------------
 * INPUT: user - user's name.
 *        pwd - user's password.
 *        domain - the domain in which the user is.
 * RETURNED VALUE: none.
 * NOTES: if NULL is supplied for domain name, than client's domain is set
 *        as default value. In order to use anonymous credentials pass empty
 *        strings: udSetCredentials("", "", ""). In order to use anonymous credentials
 *        with password pass empty strings and password: udSetCredentials("", passwordString, "").
 *=====================================================================
 */
void udSetCredentials (
        const char* user, 
        const char* pwd, 
        const char* domain
        );

void udSetCredentialsW (
        const NQ_WCHAR* user,
        const NQ_WCHAR* pwd,
        const NQ_WCHAR* domain
        );

#ifdef UD_CC_INCLUDEDOMAINMEMBERSHIP

NQ_BOOL
udDefGetComputerSecret(
    NQ_BYTE **secret
    );

NQ_BOOL
udDefGetComputerSecretByDomain(
    NQ_BYTE *secret,
    const NQ_WCHAR *domainDNS,
    NQ_WCHAR *domainNB
    );

void
udDefSetComputerSecret(
    NQ_BYTE *secret
    );

void
udDefSetComputerSecretByDomain(
    const NQ_BYTE *secret,
    const NQ_WCHAR *domainDNS,
    const NQ_WCHAR *domainNB
    );

#endif  /* UD_CC_INCLUDEDOMAINMEMBERSHIP */

void
udDefGetHostName(
    NQ_CHAR* buffer,
    NQ_UINT length
    );

#ifdef UD_NQ_INCLUDESMB1
NQ_BOOL
udDefGetClientSMB1Support(
    void
    );

NQ_STATUS
udDefSetServerSMB1Support(
        NQ_BOOL isSupport
    );
#endif /* UD_NQ_INCLUDESMB1 */

NQ_BOOL
udDefGetServerSMB1Support(
        void
        );

void
udDefGetLogFileBaseFolder(
    NQ_CHAR* buffer,
    NQ_UINT  size
    );

NQ_BOOL
udDefGetServerAnonymousAllowed(
        NQ_BOOL *access
        );

void
udDefGetMaxDiskSize(
        NQ_UINT32 *size
        );

#endif  /* _UDCONFIG_H_ */
