/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Trace common definitions. This file has 3 sections:
 *      1. External traces  - This section contains an external APIs that should be implemented by any means who seek to implement its own external logging system.
 *      2. Internal traces  - This section contains an internal APIs that belongs to the Visuality Systems company.
 *      3. Dummy traces     - This section contains an empty APIs as dummy APIs and this section should not be changed.
 *--------------------------------------------------------------------
 * MODULE        : Common
 * DEPENDENCIES  :
 ********************************************************************/

#ifndef _CMTRACE_H_
#define _CMTRACE_H_

#include "nqapi.h"
#include "cminternaltrace.h"
#include "sytrace.h"

#define CM_TRC_INCLUDE_ERRORS             /* define this parameter to include TRCERR and LOGERR traces */
#define CM_TRC_INCLUDE_CALLS              /* define this parameter to include TRCB, TRCE and LOGFB , LOGFE traces */
#define CM_TRC_INCLUDE_MESSAGES           /* define this parameter to include TRC, TRCxP and LOGMSG traces */
#define CM_TRC_INCLUDE_DUMPS              /* define this parameter to include TRCDUMP and LOGDUMP traces */
#define CM_TRC_INCLUDE_TASKS              /* define this parameter to include LOGSTART and LOGSTOP traces */

#ifdef UD_CM_LOG_THRESHOLD
#define CM_TRC_DEBUG_LEVEL          UD_CM_LOG_THRESHOLD   /* default traces level threshold */
#else /* UD_CM_LOG_THRESHOLD */
#define UD_CM_LOG_THRESHOLD         500   /* default traces level threshold */
#endif /* UD_CM_LOG_THRESHOLD */

#define CM_TRC_LEVEL_ASSERT         5     /* default level for LOGASSERT    */

/* levels for TRCERR: */
#define CM_TRC_LEVEL_LOW_ERROR      1001  /* low importance errors such as timeout in expected places*/
#define CM_TRC_LEVEL_ERROR          10    /* error   */
#define CM_TRC_LEVEL_WARNING        100   /* warning */

/* levels for LOGMSG, LOGDUMP, TRC, TRC1P, TRC2P, TRC3P: */
#define CM_TRC_LEVEL_MESS_ALWAYS    10    /* very important messages */
#define CM_TRC_LEVEL_MESS_NORMAL    200   /* intermediate messages   */
#define CM_TRC_LEVEL_MESS_COMMON    1000  /* intermediate less important messages */
#define CM_TRC_LEVEL_MESS_SOME      2000  /* less important messages */

/* levels for LOGFB, LOGFE, TRCB, TRCE: */
#define CM_TRC_LEVEL_FUNC_PROTOCOL  10    /* protocol or API functions */
#define CM_TRC_LEVEL_FUNC_COMMON    1000  /* very common functions     */
#define CM_TRC_LEVEL_INFO           1500  /* information functions     */
#define CM_TRC_LEVEL_FUNC_TOOL      2000  /* auxiliary functions       */

#ifndef CM_TRC_LEVEL_MEMORY
#define CM_TRC_LEVEL_MEMORY         (CM_TRC_DEBUG_LEVEL + 1)    /* memory dump traces, not reported by default
                                                                   to see only memory traces define CM_TRC_DEBUG_LEVEL = CM_TRC_LEVEL_MEMORY */
#endif /* CM_TRC_LEVEL_MEMORY */

#ifndef CM_TRC_LEVEL_REPOSITORY
#define CM_TRC_LEVEL_REPOSITORY     (CM_TRC_DEBUG_LEVEL + 1)    /* repository traces, not reported by default */
#endif /* CM_TRC_LEVEL_REPOSITORY */

#ifndef CM_TRC_LEVEL_CMLIST
#define CM_TRC_LEVEL_CMLIST         (CM_TRC_DEBUG_LEVEL + 1)    /* cmlist traces, not reported by default */
#endif /* CM_TRC_LEVEL_CMLIST */

#ifndef CM_TRC_LEVEL_SD
#define CM_TRC_LEVEL_SD             (CM_TRC_DEBUG_LEVEL + 1)    /* security descriptors traces, not reported by default */
#endif /* CM_TRC_LEVEL_SD */

#ifndef CM_TRC_LEVEL_TRANSPORT
#define CM_TRC_LEVEL_TRANSPORT      (CM_TRC_DEBUG_LEVEL + 1)    /* transport traces, not reported by default */
#endif /* CM_TRC_LEVEL_TRANSPORT */

#ifndef CM_TRC_LEVEL_CRYPT
#define CM_TRC_LEVEL_CRYPT          (CM_TRC_DEBUG_LEVEL + 1)    /* crypt traces, not reported by default */
#endif /* CM_TRC_LEVEL_CRYPT */

/* internal trace */
#ifdef UD_NQ_INCLUDETRACE

#ifdef UD_NQ_EXTERNALTRACE

#define LOGASSERT(_level, expr)      LOGERR(_level, "Assertion violation: " #expr); syAssert(expr);

#ifdef CM_TRC_INCLUDE_MESSAGES
#ifdef SY_C99_MACRO
#define TRC(_fmt, ...)               syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_MESS_NORMAL, SY_MSG_TYPE_MSG, _fmt, __VA_ARGS__)
#define TRC1P(_fmt, ...)             syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_MESS_NORMAL, SY_MSG_TYPE_MSG, _fmt, __VA_ARGS__)
#define TRC2P(_fmt, ...)             syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_MESS_NORMAL, SY_MSG_TYPE_MSG, _fmt, __VA_ARGS__)
#define TRC3P(_fmt, ...)             syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_MESS_NORMAL, SY_MSG_TYPE_MSG, _fmt, __VA_ARGS__)
#define LOGMSG(_level, _fmt, ...)    syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, SY_MSG_TYPE_MSG, _fmt, __VA_ARGS__)
#else
#define TRC(_fmt...)                 syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_MESS_NORMAL, SY_MSG_TYPE_MSG, ##_fmt)
#define TRC1P(_fmt...)               syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_MESS_NORMAL, SY_MSG_TYPE_MSG, ##_fmt)
#define TRC2P(_fmt...)               syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_MESS_NORMAL, SY_MSG_TYPE_MSG, ##_fmt)
#define TRC3P(_fmt...)               syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_MESS_NORMAL, SY_MSG_TYPE_MSG, ##_fmt)
#define LOGMSG(_level, _fmt...)      syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, SY_MSG_TYPE_MSG, ##_fmt)
#endif /* SY_C99_MACRO */
#else
#ifdef SY_C99_MACRO
#define TRC(_fmt, ...)
#define TRC1P(_fmt, ...)
#define TRC2P(_fmt, ...)
#define TRC3P(_fmt, ...)
#define LOGMSG(_level, _fmt, ...)
#else
#define TRC(_fmt...)
#define TRC1P(_fmt...)
#define TRC2P(_fmt...)
#define TRC3P(_fmt...)
#define LOGMSG(_level, _fmt...)
#endif /* SY_C99_MACRO */
#endif /* CM_TRC_INCLUDE_MESSAGES */

#ifdef CM_TRC_INCLUDE_ERRORS
#ifdef SY_C99_MACRO
#define TRCERR(_fmt, ...)            syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_ERROR, SY_MSG_TYPE_ERR, _fmt, __VA_ARGS__)
#define LOGERR(_level, _fmt, ...)    syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, SY_MSG_TYPE_ERR, _fmt, __VA_ARGS__)
#else
#define TRCERR(_fmt...)              syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_ERROR, SY_MSG_TYPE_ERR, ##_fmt)
#define LOGERR(_level, _fmt...)      syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, SY_MSG_TYPE_ERR, ##_fmt)
#endif /* SY_C99_MACRO */
#else
#ifdef SY_C99_MACRO
#define TRCERR(_fmt, ...)
#define LOGERR(_level, _fmt, ...)
#else
#define TRCERR(_fmt...)
#define LOGERR(_level, _fmt...)
#endif /* SY_C99_MACRO */
#endif /* CM_TRC_INCLUDE_ERRORS */

#ifdef CM_TRC_INCLUDE_CALLS
#define TRCB()                       syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_FUNC_TOOL, SY_MSG_TYPE_ENTER, "")
#define TRCE()                       syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_FUNC_TOOL, SY_MSG_TYPE_LEAVE, "")
#ifdef SY_C99_MACRO
#define LOGFB(_level, ...)           syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, SY_MSG_TYPE_ENTER, ""__VA_ARGS__)
#define LOGFE(_level, ...)           syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, SY_MSG_TYPE_LEAVE, ""__VA_ARGS__)
#else
#define LOGFB(_level, _fmt...)       syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, SY_MSG_TYPE_ENTER, ""_fmt)
#define LOGFE(_level, _fmt...)       syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, SY_MSG_TYPE_LEAVE, ""_fmt)
#endif /* SY_C99_MACRO */
#else
#define TRCB()
#define TRCE()
#ifdef SY_C99_MACRO
#define LOGFB(_level, ...)
#define LOGFE(_level, ...)
#else
#define LOGFB(_level, _fmt...)
#define LOGFE(_level, _fmt...)
#endif /* SY_C99_MACRO */
#endif /* CM_TRC_INCLUDE_CALLS */

#ifdef CM_TRC_INCLUDE_DUMPS
#define LOGDUMP(_level, _str, _addr, _len)   syTraceDump(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, _str, _addr, _len)
#define TRCDUMP(_str, _addr, _len)           syTraceDump(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_MESS_NORMAL, _str, _addr, _len)
#ifdef UD_NQ_USEIOVECS
#define LOGIODUMP(_level, _str, _addr, _len) syTraceIODump(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, _str, _addr, _len)
#else
#define LOGIODUMP(_level, _str, _addr, _len) LOGDUMP(_level, _str, _addr, _len)
#endif /* UD_NQ_USEIOVECS */
#else 
#define LOGDUMP(_level, _str, _addr, _len)
#define LOGIODUMP(_level, _str, _addr, _len)
#define TRCDUMP(_str, _addr, _len)
#endif /* CM_TRC_INCLUDE_DUMPS */

#ifdef CM_TRC_INCLUDE_TASKS
#define LOGSTART(_name)              syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, 0, SY_MSG_TYPE_START, _name)
#define LOGSTOP(_name)               syTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, 0, SY_MSG_TYPE_STOP, _name)
#else
#define LOGSTART(_name)
#define LOGSTOP(_name)
#endif /* CM_TRC_INCLUDE_TASKS */


#else /* end of UD_NQ_EXTERNALTRACE */
/* default internal trace */
#define NQ_TRACE_ISENABLED           if (0 != cmTraceThresholdGet())

#define LOGASSERT(_level, expr)      LOGERR(_level, "Assertion violation: " #expr); syAssert(expr);

#ifdef CM_TRC_INCLUDE_MESSAGES
#ifdef SY_C99_MACRO
#define LOGMSG(_level, ...)          NQ_TRACE_ISENABLED cmTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, ""__VA_ARGS__)
#define TRC(_fmt, ...)               NQ_TRACE_ISENABLED cmTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_MESS_NORMAL, _fmt, __VA_ARGS__)
#define TRC1P(_fmt, ...)             NQ_TRACE_ISENABLED cmTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_MESS_NORMAL, _fmt, __VA_ARGS__)
#define TRC2P(_fmt, ...)             NQ_TRACE_ISENABLED cmTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_MESS_NORMAL, _fmt, __VA_ARGS__)
#define TRC3P(_fmt, ...)             NQ_TRACE_ISENABLED cmTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_MESS_NORMAL, _fmt, __VA_ARGS__)
#else
#define LOGMSG(_level, _fmt...)      NQ_TRACE_ISENABLED cmTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, ##_fmt)
#define TRC(_fmt...)                 NQ_TRACE_ISENABLED cmTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_MESS_NORMAL, ##_fmt)
#define TRC1P(_fmt...)               NQ_TRACE_ISENABLED cmTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_MESS_NORMAL, ##_fmt)
#define TRC2P(_fmt...)               NQ_TRACE_ISENABLED cmTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_MESS_NORMAL, ##_fmt)
#define TRC3P(_fmt...)               NQ_TRACE_ISENABLED cmTraceMessage(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_MESS_NORMAL, ##_fmt)
#endif /* SY_C99_MACRO */
#else
#ifdef SY_C99_MACRO
#define LOGMSG(_level, _fmt,...)
#define TRC(f,...)
#define TRC1P(f,...)
#define TRC2P(f,...)
#define TRC3P(f,...)
#else
#define LOGMSG(_level, _fmt...)
#define TRC(f...)
#define TRC1P(f...)
#define TRC2P(f...)
#define TRC3P(f...)
#endif /* SY_C99_MACRO */
#endif /* CM_TRC_INCLUDE_MESSAGES */

#ifdef CM_TRC_INCLUDE_ERRORS
#ifdef SY_C99_MACRO
#define LOGERR(_level, ...)          NQ_TRACE_ISENABLED cmTraceError(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, ""__VA_ARGS__)
#define TRCERR(_fmt, ...)            NQ_TRACE_ISENABLED cmTraceError(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_ERROR, _fmt, __VA_ARGS__)
#else
#define LOGERR(_level, _fmt...)      NQ_TRACE_ISENABLED cmTraceError(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, ##_fmt)
#define TRCERR(_fmt...)              NQ_TRACE_ISENABLED cmTraceError(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_ERROR, ##_fmt)
#endif /* SY_C99_MACRO */
#else
#ifdef SY_C99_MACRO
#define LOGERR(_level, _fmt,...)
#define TRCERR(f,...)
#else
#define LOGERR(_level, _fmt...)
#define TRCERR(f...)
#endif /* SY_C99_MACRO */
#endif /* CM_TRC_INCLUDE_ERRORS */

#ifdef CM_TRC_INCLUDE_CALLS
#define TRCB()                       NQ_TRACE_ISENABLED cmTraceFuncEnter(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_FUNC_TOOL, "")
#define TRCE()                       NQ_TRACE_ISENABLED cmTraceFuncLeave(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_FUNC_TOOL, "")
#ifdef SY_C99_MACRO
#define LOGFB(_level, ...)           NQ_TRACE_ISENABLED cmTraceFuncEnter(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, ""__VA_ARGS__)
#define LOGFE(_level, ...)           NQ_TRACE_ISENABLED cmTraceFuncLeave(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, ""__VA_ARGS__)
#else
#define LOGFB(_level, _fmt...)       NQ_TRACE_ISENABLED cmTraceFuncEnter(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, ""_fmt)
#define LOGFE(_level, _fmt...)       NQ_TRACE_ISENABLED cmTraceFuncLeave(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, ""_fmt)
#endif /* SY_C99_MACRO */
#else
#define TRCB()
#define TRCE()
#ifdef SY_C99_MACRO
#define LOGFB(_level, ...)
#define LOGFE(_level, ...)
#else
#define LOGFB(_level, _fmt...)
#define LOGFE(_level, _fmt...)
#endif /* SY_C99_MACRO */
#endif /* CM_TRC_INCLUDE_CALLS */

#ifdef CM_TRC_INCLUDE_DUMPS
#define TRCDUMP(_str, _addr, _len)             NQ_TRACE_ISENABLED cmTraceDump(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, CM_TRC_LEVEL_MESS_NORMAL, _str, _addr, _len)
#define LOGDUMP(_level,_str, _addr, _len)      NQ_TRACE_ISENABLED cmTraceDump(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, _str, _addr, _len)
#ifdef UD_NQ_USEIOVECS
#define LOGIODUMP(_level, _str, _addr, _len)   NQ_TRACE_ISENABLED cmTraceIODump(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, _level, _str, _addr, _len)
#else
#define LOGIODUMP(_level, _str, _addr, _len)   NQ_TRACE_ISENABLED LOGDUMP(_level, _str, _addr, _len)
#endif /* UD_NQ_USEIOVECS */
#else
#define LOGDUMP(_level, _str, _addr, _len)
#define LOGIODUMP(_level, _str, _addr, _len)
#define TRCDUMP(_str, _addr, _len)
#endif /* CM_TRC_INCLUDE_DUMPS */

#ifdef CM_TRC_INCLUDE_TASKS
#define LOGSTART(_name)                        NQ_TRACE_ISENABLED cmTraceStart(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, 0, _name)
#define LOGSTOP(_name)                         NQ_TRACE_ISENABLED cmTraceStop(SY_LOG_FILE, SY_LOG_FUNCTION, SY_LOG_LINE, 0, _name)
#else
#define LOGSTART(_name)
#define LOGSTOP(_name)
#endif /* CM_TRC_INCLUDE_TASKS */

#endif /* end of default internal trace */
#else
#define LOGDUMP(_level, _str, _addr, _len)      /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define LOGIODUMP(_level, _str, _addr, _len)    /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define LOGASSERT(_level, expr)                 /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define LOGSTART(_name)                         /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define LOGSTOP(_name)                          /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define TRCB()                                  /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define TRCE()                                  /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define TRCDUMP(_str, _addr, _len)              /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#ifdef SY_C99_MACRO
#define LOGFB(_level, ...)                      /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define LOGFE(_level, ...)                      /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define LOGMSG(_level, _fmt, ...)               /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define LOGERR(_level, _fmt, ...)               /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define TRC(_fmt, ...)                          /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define TRC1P(_fmt, ...)                        /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define TRC2P(_fmt, ...)                        /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define TRC3P(_fmt, ...)                        /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define TRCERR(_fmt, ...)                       /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#else
#define LOGFB(_level, _fmt...)                  /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define LOGFE(_level, _fmt...)                  /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define LOGMSG(_level, _fmt...)                 /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define LOGERR(_level, _fmt...)                 /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define TRC(_fmt...)                            /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define TRC1P(_fmt...)                          /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define TRC2P(_fmt...)                          /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define TRC3P(_fmt...)                          /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#define TRCERR(_fmt...)                         /* DO NOT CHANGE THIS LINE, FOR EXTERNAL TRACES CHANGE UD_NQ_EXTERNALTRACE SECTION */
#endif /* SY_C99_MACRO */


#endif /* UD_NQ_INCLUDETRACE */


#endif /* _CMTRACE_H_ */
