/*************************************************************************
 * Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *                     All Rights Reserved
 *
 * This item is the property of Visuality Systems, Ltd., and contains
 * confidential, proprietary, and trade-secret information. It may not
 * be transferred from the custody or control of Visuality Systems, Ltd.,
 * except as expressly authorized in writing by an officer of Visuality
 * Systems, Ltd. Neither this item nor the information it contains may
 * be used, transferred, reproduced, published, or disclosed, in whole
 * or in part, and directly or indirectly, except as expressly authorized
 * by an officer of Visuality Systems, Ltd., pursuant to written agreement.
 *
 *************************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Common self IP operations
 *--------------------------------------------------------------------
 * MODULE        : Common
 * DEPENDENCIES  :
 *************************************************************************/

#ifndef _CMSELFIP_H_
#define _CMSELFIP_H_

#include "cmapi.h"

/* Description
   Starts this module.
   Returns
   TRUE on success, FALSE on failure.                          */
typedef struct 
{
    NQ_IPADDRESS ip;        /* IP address   either v4 or v6 */
    NQ_UINT32 bcast;        /* IPv4 broadcast address */
    NQ_UINT32 subnet;       /* IPv4 subnet address */
#ifdef CM_NQ_STORAGE
    NQ_UINT osIndex;        /* adapter index as in the OS */
    NQ_BOOL rdmaCapable;    /* TRUE when this adapter supports RDMA */
#endif
    NQ_IPADDRESS winsServers[UD_NQ_MAXWINSSERVERS * UD_NS_MAXADAPTERS]; /* Holds all the wins server that related to this CMSelfIp->ip using the subnet as mask */
#if defined(UD_NQ_USETRANSPORTIPV4) || defined(UD_NQ_USETRANSPORTIPV6)
    NQ_IPADDRESS dnsServers[UD_NQ_MAXDNSSERVERS * UD_NS_MAXADAPTERS];   /* Holds all the dns server that related to this CMSelfIp->ip using the subnet as mask */
#endif /* defined(UD_NQ_USETRANSPORTIPV4) || defined(UD_NQ_USETRANSPORTIPV6) */
    NQ_COUNT numWinsServers;                /* number of WINS servers */
    NQ_COUNT numDnsServers;                 /* number of DNS servers */
}
CMSelfIp;

/* Description
   Starts this module.
   Returns
   TRUE on success, FALSE on failure.                          */
NQ_BOOL cmSelfipStart(void);

/* Description
   Shutdown this module.
   Returns
   None */
void cmSelfipShutdown(void);

/* Description
   This function resets the process of self IP iteration. The next call to cmSelfipGetNext()
   will bring the first IP. 

   Returns
   None. */
void cmSelfipIterate(void);

/* Description
   This function iterates self IP addresses. 

   Returns
   Pointer to the next self IP address or NULL when there are no more addresses. */
const CMSelfIp * cmSelfipNext(void);

/*Description
        This function terminates the iterator after being used by cmSelfipNext */
void cmSelfipTerminate(void);

/* Description
   This function return pointer to zero ip address. */
NQ_IPADDRESS * cmSelfipGetZeroIp(void);

/* Description
   This function return pointer to any ip address version 4 */
NQ_IPADDRESS * cmSelfipGetAnyIpVersion4(void);

/* Description
   This function return pointer to local host ip version 4 */
NQ_IPADDRESS * cmSelfipGetLocalHostIp(void);

#ifdef UD_NQ_USETRANSPORTIPV6
/* Description
   This function return pointer to any ip address version 6 */
NQ_IPADDRESS * cmSelfipGetAnyIpVersion6(void);

/* Description
   This function return pointer to local host ip version 6 */
NQ_IPADDRESS * cmSelfipGetLocalHostIpVersion6(void);
#endif /* UD_NQ_USETRANSPORTIPV6 */

#endif  /* _CMSELFIP_H_ */

