/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Parameters
 *--------------------------------------------------------------------
 * MODULE        : Common
 * DEPENDENCIES  :
 ********************************************************************/

#ifndef _CMNBPARM_H_
#define _CMNBPARM_H_

/*
    NQ-wide parameters
    ------------------
 */

#define CM_NQ_PRODUCT_NAME "YNQ"            /* product name */

#define CM_DDNAME "VISUALITY NBT DD"        /* NetBIOS name for the DD daemon */

#define CM_SOFTWAREVERSIONMAJOR   1         /* Software versions major */
#define CM_SOFTWAREVERSIONMINOR   5         /* Build release number    */
#define CM_SOFTWAREVERSIONSUPPORT 1         /* Support release number  */
#define CM_SOFTWAREVERSIONDECSEPARATOR 10   /* Need to multiple the MINOR version and add the SUPPORT version */


/*
    NetBIOS parameters
    ------------------
 */

/* datagram buffer size and multiplex count */

#define     CM_NB_DATAGRAMBUFFERSIZE        1500
#define     CM_CS_MAXMPXCOUNT               10   /* should be supported by the TCP underlying system */
#ifdef UD_NS_ASYNCSEND
#define     CM_NB_NUMBUFFERS                4
#else
#define     CM_NB_NUMBUFFERS                2
#endif

/* algorithm parameters */

#define     CM_NB_BROADCASTTIMEOUT          1
#define     CM_NB_UNICASTREQRETRYTIMEOUT    2
#define     CM_NB_UNICASTREQRETRYCOUNT      2
#define     CM_NB_VERYBIGNBTIMEOUT          1 /* 1 sec */ /*(60*60) 1 hour */

/* network constants */

/* NetBIOS ports to send the outgoing packets to */
#define     CM_NB_NAMESERVICEPORT           137
#define     CM_NB_DATAGRAMSERVICEPORT       138
#define     CM_NB_SESSIONSERVICEPORT        139

/* TCP/IP port to send the outgoing packets to */
#define     CM_NB_SESSIONSERVICEPORTIP      445

/* NetBIOS ports to listen on */
#define     CM_IN_NAMESERVICEPORT           udGetPort(CM_NB_NAMESERVICEPORT)
#define     CM_IN_DATAGRAMSERVICEPORT       udGetPort(CM_NB_DATAGRAMSERVICEPORT)
#define     CM_IN_SESSIONSERVICEPORT        udGetPort(CM_NB_SESSIONSERVICEPORT)

/* Internal NetBIOS ports */
#define     CM_IN_INTERNALIPCPORT           udGetPort(UD_BR_INTERNALIPCPORT)
#define     CM_IN_INTERNALNSPORT            udGetPort(UD_NS_INTERNALNSPORT)
#define     CM_IN_INTERNALDSPORT            udGetPort(UD_NS_INTERNALDSPORT)

/* default values (if not specified in the config file) */

#define     CM_NB_DEFAULT_NODETYPE          "B"
#define     CM_NB_DEFAULT_SCOPEID           ""

/* client parameters */

#define CM_DIALECT_NT_LM_012       "NT LM 0.12"
#define CM_NATIVE_OS               "Windows 4.0"
#define CM_NATIVE_LANMAN           CM_NATIVE_OS

/* common values */

#define CM_USERNAMELENGTH       256

#define CM_MAXFILENAMELEN       UD_FS_FILENAMELEN

#define CM_IGNORE_LENGTH        (NQ_UINT)-1

#define CM_TRAILING_NULL        1

#define CM_LANMAN_LENGTH        64

#define CM_NQ_DELIMITER         ';'     /* delimiter to use for string that contain a list */

#define CM_NUMBER_OF_BYTES_IN_ONE_GIGA  (1 * 1024 * 1024 * 1024)

#endif  /* _CMNBPARM_H_ */
