/*********************************************************************
*
*           Copyright (c) 2021 by Visuality Systems, Ltd.
*
*********************************************************************
* FILE NAME     : $Workfile:$
* ID            : $Header:$
* REVISION      : $Revision:$
*--------------------------------------------------------------------
* DESCRIPTION   : AES-GCM implementation for internal usage
*--------------------------------------------------------------------
* MODULE        : auth - am
* DEPENDENCIES  : None
********************************************************************/
#ifndef _AMAESGCM_H_
#define _AMAESGCM_H_

/*====================================================================
 * PURPOSE: Encrypt plain text.(AES Block Encryption)
 *--------------------------------------------------------------------
 * PARAMS:
 *    IN    key    : pointer to encryption key; (16 bytes).
 *    IN    nonce    : pointer to nonce; 98 bites.
 *    IN    inText    : pointer to input text.
 *    IN    textLen    : input text length.
 *    OUT    outText    : pointer to output text(encrypted or decrypted)
 *
 * RETURNS:
 *    NONE
 *====================================================================
 */
void aesGcmEnc(const NQ_BYTE* key,
        const NQ_BYTE* nonce,
        const NQ_BYTE* inText,
        const NQ_UINT32 textLen,
        NQ_BYTE* outText
        );

#endif /* _AMAESGCM_H_ */
