/*************************************************************************
 * Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *                     All Rights Reserved
 *
 * This item is the property of Visuality Systems, Ltd., and contains
 * confidential, proprietary, and trade-secret information. It may not
 * be transferred from the custody or control of Visuality Systems, Ltd.,
 * except as expressly authorized in writing by an officer of Visuality
 * Systems, Ltd. Neither this item nor the information it contains may
 * be used, transferred, reproduced, published, or disclosed, in whole
 * or in part, and directly or indirectly, except as expressly authorized
 * by an officer of Visuality Systems, Ltd., pursuant to written agreement.
 *
 *************************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Authentication encryption operations
 *--------------------------------------------------------------------
 * MODULE        : Auth - AM
 * DEPENDENCIES  :
 *************************************************************************/

#ifndef _AMCRYPT_H_ 
#define _AMCRYPT_H_

#include "cmapi.h"
#include "amcredentials.h"

/* This structure describes encrypted values. It consists of LM and NTLM 
   hashes respectively. These hashes may be either old-style or V2 hashes.
    
   Hashes are used for logon while session keys are used for message signing and 
   other encryptions during the application session. Rules for session keys may differ
   from those for hashes. */
typedef struct {
    CMBlob pass1;           /* first (LM) encrypted password */
    CMBlob pass2;           /* second (NTLM) encrypted password */
    CMBlob macKey;          /* mac key, i.e., - for message signing */
    CMBlob response;        /* signing response */
} AMCrypt;  /* hashes */

/* Description
   Create encrypted hashes.
   Parameters
   credentials :  Credentials to use for encryption.
   crypt1 : first crypter
   crypt2 : second crypter
   encryptionKey : key to use for encryption.
   names : Blob of names as returned from server. This value may be NULL.
   timeStamp : Time stamp to be used in blob.
   crypt :        Pointer to the result structure. The blob data
                  pointers will point to newly allocated data
                  blocks. Application should deallocate them
                  later using <link amCryptDispose@AMCrypt *, amCryptDispose()>.
   Returns
   TRUE on success, FALSE on failure. This function may fail because of lack of memory.                                                                                        */
NQ_BOOL amCryptEncrypt(const AMCredentials * credentials, NQ_UINT crypt1, NQ_UINT crypt2, const NQ_BYTE * encryptionKey, CMBlob * names, NQ_UINT64 timeStamp, AMCrypt * crypt);

/* Description
   Convert ASCII credential to Unicode
   Parameters
   crypt : Pointer to the crypt structure. This structure is
           expected to be created in <link amCryptCreateHash2@AMCredentials *@AMCryptHash2 *, amCryptCreateHash2()>.
   Returns
   None.                                                                                                              */
void amCryptDispose(AMCrypt * crypt);

/* callback function for cryptors that may be changed to external ones */
void md4Internal(const NQ_BYTE * dataIn, NQ_BYTE * dataOut, NQ_COUNT length);
void md5Internal(const CMBlob * key, const CMBlob * key1, const CMIOBlob dataFragments[], NQ_COUNT numFragments, NQ_BYTE * buffer, NQ_COUNT bufferSize);
void hmacmd5Internal(const CMBlob * key, const CMBlob * key1, const CMIOBlob dataFragments[], NQ_COUNT numFragments, NQ_BYTE * buffer, NQ_COUNT bufferSize);
#ifdef UD_NQ_INCLUDESMB2
void sha256Internal(const CMBlob * key, const CMBlob * key1, const CMIOBlob dataFragments[], NQ_COUNT numFragments, NQ_BYTE * buffer, NQ_COUNT bufferSize);
#ifdef UD_NQ_INCLUDESMB3
void sha512Internal(const CMBlob * key, const CMBlob * key1, const CMIOBlob dataFragments[], NQ_COUNT numFragments, NQ_IOBufPos buffer, NQ_COUNT bufferSize, NQ_BYTE *sha512_CtxBuf);
void aes128cmacInternal(const CMBlob * key, const CMBlob * key1, const CMIOBlob dataFragments[], NQ_COUNT numFragments, NQ_BYTE * buffer, NQ_COUNT bufferSize);
void aes128ccmEncryptionInternal(const CMBlob * key, const CMBlob * key1, const CMIOBlob * prefix, CMIOBlob * message, NQ_BYTE * auth);
NQ_BOOL aes128ccmDecryptionInternal(const CMBlob * key, const CMBlob * key1, const CMIOBlob * prefix, CMIOBlob * message, const NQ_BYTE * auth);
void aes128GcmEncryptInternal(const CMBlob *key, const CMBlob *IV, const CMIOBlob *AAD, CMIOBlob *message, NQ_BYTE *auth, NQ_BYTE *keyBuffer, NQ_BYTE *encMsgBuffer);
NQ_BOOL aes128GcmDecryptInternal(const CMBlob *key, const CMBlob *key1, const CMIOBlob *prefix, CMIOBlob *message, const NQ_BYTE *auth, NQ_BYTE *keyBuffer, NQ_BYTE *encMsgBuffer);
#endif /* UD_NQ_INCLUDESMB3 */
#endif /* UD_NQ_INCLUDESMB2 */

#endif /* _AMCRYPT_H_ */
