/*************************************************************************
 * Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *                     All Rights Reserved
 *
 * This item is the property of Visuality Systems, Ltd., and contains
 * confidential, proprietary, and trade-secret information. It may not
 * be transferred from the custody or control of Visuality Systems, Ltd.,
 * except as expressly authorized in writing by an officer of Visuality
 * Systems, Ltd. Neither this item nor the information it contains may
 * be used, transferred, reproduced, published, or disclosed, in whole
 * or in part, and directly or indirectly, except as expressly authorized
 * by an officer of Visuality Systems, Ltd., pursuant to written agreement.
 *
 *************************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Authentication credentials operations
 *--------------------------------------------------------------------
 * MODULE        : Auth - AM
 * DEPENDENCIES  :
 *************************************************************************/

#include "amcredentials.h"

/* -- API functions -- */
void amCredentialsAsciiiToW(AMCredentials * to, const AMCredentialsA *from)
{
    cmAnsiToUnicode(to->domain.name, from->domain.name);
    cmWStrupr(to->domain.name);
    cmAnsiToUnicode(to->domain.realm, from->domain.realm);
    cmAnsiToUnicode(to->user, from->user); 
    cmAnsiToUnicode(to->password, from->password); 
    to->type = from->type;
}

void amCredentialsInitW(AMCredentials * creds, const NQ_WCHAR *domain, const NQ_WCHAR *user, const NQ_WCHAR *password, NQ_UINT type)
{
    if (creds)
    {
        syMemset(creds, 0, sizeof(*creds));
        cmWStrcpy(creds->domain.name, domain);
        cmWStrupr(creds->domain.name);
        cmWStrcpy(creds->domain.realm, domain);
        cmWStrupr(creds->domain.realm);
        cmWStrcpy(creds->user, user);
        if (type == AM_CREDENTIALS_PASSWORD_MD4)
            syMemcpy(creds->password, (const NQ_BYTE *)password, 16);
        else
            cmWStrcpy(creds->password, password);
        creds->type = type;
    }
}

void amCredentialsInitA(AMCredentialsA * creds, const NQ_CHAR *domain, const NQ_CHAR *user, const NQ_CHAR *password, NQ_UINT type)
{
    if (creds)
    {
        syMemset(creds, 0, sizeof(*creds));
        syStrcpy(creds->domain.name, domain);
        cmAStrupr(creds->domain.name);
        syStrcpy(creds->domain.realm, domain);
        cmAStrupr(creds->domain.realm);
        syStrcpy(creds->user, user);
        if (type == AM_CREDENTIALS_PASSWORD_MD4)
            syMemcpy(creds->password, (const NQ_BYTE *)password, 16);
        else
            syStrcpy(creds->password, password);
        creds->type = type;
    }
}
