#
# Compile commands
#

# Debug options
ifneq ($(or $(NQDEBUG),$(ASAN),$(TSAN)),) # ifdef NQDEBUG || ASAN || TSAN
	CCOPT=-g -O0
else
	CCOPT=-O3
endif # ifdef NQDEBUG || ASAN || TSAN

# OS-specific commands and flags
# ----------------------------------
# linux
ifdef ASAN
	CCOPT += -fsanitize=address -fno-omit-frame-pointer
endif #ASAN
ifdef TSAN
	CCOPT += -fsanitize=thread
endif #TSAN
	CC      = gcc
	AR      = ar r
	ARX		= ar -x
	LIB     = ranlib
	WRFLAGS = -Wall -Wconversion #-Wextra -Wsign-conversion -Wsign-compare -Wno-unused-parameter
	CCFLAGS = -D_GNU_SOURCE $(WRFLAGS) $(CCOPT) -nostdlib -fno-builtin -fno-defer-pop -c -pthread
	INCPATH += #-I/usr/include/heimdal
	LIBPATH = #-L/usr/lib64/heimdal #-L/usr/lib
	LINKER  = $(CROSS_COMPILE)gcc $(LIBPATH)
	SYSLIBS = -lc -lpthread -lxml2 #-lsasl2 -lkrb5 
ifdef ASAN
	SYSLIBS += -fsanitize=address 
endif #ASAN
ifdef TSAN
	SYSLIBS += -fsanitize=thread 
endif #TSAN

# ----------------------------------

# Common for all OS
RM      = rm -f
RMDIR   = rm -Rf
MKDIR	= mkdir
MAKEDEP = $(CC) -MM $(DEFS) $(INCPATH)
COMPILE = $(CC) $(CCFLAGS) $(INCPATH)
