/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Upper-level functions
 *--------------------------------------------------------------------
 * MODULE        : NQ
 * DEPENDENCIES  :
 ********************************************************************/

#ifndef _NQAPI_H_
#define _NQAPI_H_

#include "cmapi.h"

SY_STARTAPI

/** @defgroup nqapi NQ Common */

/** @defgroup nq_init_shut Initialization and Shutdown
 * @ingroup nqapi
 * @{
 */

/** This function is called to start NQ system.
   This function must initialize UD, SY and NS modules
   prior to calling to csStart() or ndStart() or ccInit().
   @returns
   NQ_SUCCESS or NQ_FAIL
   @see
   udInit() in file udapi.h,
   syInit() in file syapi.h,
   nsInitGuard() in file nsapi.h,
   csStart() in file csapi.h,
   ndStart() in file ndapi.h.
*/
NQ_INT nqStart(void);

/** This function is called to stop NQ system started by nqStart().
   @returns
   NQ_SUCCESS or NQ_FAIL
   @see
   nqStart()
*/
NQ_INT nqStop(void);

/** @} end of group nq_init_shut Initialization and Shutdown */

/** @defgroup nq_netbios NetBIOS Name Registration
 * @ingroup nqapi
 * @{
 */

/** This function is called to register an abstract NetBIOS name.
   An abstract name is registered in addition to the host name
   and is served as its alias.

   @param name  Pointer to the name to register as a NetBIOS name.
   @returns
   NQ_SUCCESS or NQ_FAIL
   @see
   nqReleaseNetBiosName()   */
NQ_STATUS nqRegisterNetBiosName(const NQ_CHAR* name);

/** This function is called to unregister an abstract NetBIOS
   name.

   @param name  Pointer to the name to release as a NetBIOS name.
   @returns
   NQ_SUCCESS or NQ_FAIL
      
   @note
   No check is made that the name to release was registered with
   a nqRegisterNetBiosName()
   call. It is possible to release the basic host name with this
   call.   
   
   @see
   nqRegisterNetBiosName()   */
NQ_STATUS nqReleaseNetBiosName(const NQ_CHAR* name);


/* *** NetBIOS name type and postfixes ****/

#define CM_NB_GROUP                         0x80
#define CM_NB_UNIQUE                        0x40

#define CM_NB_POSTFIX_WORKSTATION           0x0
#define CM_NB_POSTFIX_SERVER                0x20
#define CM_NB_POSTFIX_DOMAINMASTERBROWSER   0x1b
#define CM_NB_POSTFIX_DOMAINCONTROLLER      0x1c
#define CM_NB_POSTFIX_MASTERBROWSER         0x1d

/** This function is called to register an abstract NetBIOS name.
   An abstract name is registered in addition to the host name
   and is served as its alias. This is an extended version of 
   nqRegisterNetBiosName().

   @param name   Pointer to the name to register as a NetBIOS name.
   @param flags  Combination of flags to designate unique or group name
           and postfix (e.g. #CM_NB_UNIQUE|#CM_NB_POSTFIX_SERVER)
   @returns
   NQ_SUCCESS or NQ_FAIL
   @see
   nqReleaseNetBiosNameEx() */
   NQ_STATUS nqRegisterNetBiosNameEx(const NQ_CHAR* name, const NQ_BYTE flags);

/** This function is called to unregister an abstract NetBIOS
   name. This is an extended version of 
   nqReleaseNetBiosName().

   @param name   Pointer to the name to release as a NetBIOS name.
   @param flags  Combination of flags to designate unique or group name
   and postfix (e.g. #CM_NB_UNIQUE|#CM_NB_POSTFIX_SERVER)

   @returns
   NQ_SUCCESS or NQ_FAIL
      
   @note
   No check is made that the name to release was registered with
   a nqRegisterNetBiosNameEx()
   call. It is possible to release the basic host name with this
   call.
   
   @see
   nqRegisterNetBiosNameEx()   */
NQ_STATUS nqReleaseNetBiosNameEx(const NQ_CHAR* name, const NQ_BYTE flags);

/** @} end of group nq_netbios NetBIOS Name Registration */

#if defined(UD_NQ_INCLUDETRACE) || defined(DOXYGEN)

/** @defgroup nq_utils Utils
 *  @ingroup nqapi
 * @{ */

 /** This defines trace availability

   @param on   Trace availability (TRUE for On, FALSE for off).

   @note
     \* This function is only available when NQ was compiled with
       Internal Trace support as indicated by the UD_NQ_INCLUDETRACE
       parameter. */
void nqEnableTraceLog(NQ_BOOL on);

/** @} end of group nq_utils Utils */

#endif /* UD_NQ_INCLUDETRACE */

SY_ENDAPI

#endif  /* _NQAPI_H_ */
