
# ChangeLog

All notable changes to this project will be documented in this file.


## [YNQ-1.5.0]

### Added
- [Critical][Authentication, Server] Secure RPC channel support for passthrough logon with Active Directory, now used by default with AES encryption, traffic is sealed by default, controlled by UD_CC_NETLOGONENCRYPT parameter
- [Moderate][Server] UD_NB_CHECKCALLEDNAME_NOIP, fixing servers response to NBSS
- [Moderate][Server, Service, System, UserDefine] New feature UD_CS_INCLUDEEXTERNALNOTIFY for monitoring filesystem events in underlying file system, provides better SMB Notify functionality. (Linux and Nucleus)
- [Moderate][Common, NetBios, Network, System, UserDefine] The ability to define a list of WINS servers in cm_cfg.txt file, Added a list of WINS and DNS servers to AdapterInfo,
 NDAdapterInfo and CMSelfIp and fixed all related APIs
- [Low][Documentation] Evaluation documents for iOS and MacOS
- [Low][Documentation] VxWorks client & server Evaluation Package docs
- [Low][Documentation] Added API List Changes MD files
- [Low][Makefile] TSAN (thread sanitizer) support into Makefile
- [Low][Common, Network] Parsing module and unified internal list convention when returning a number of strings in one buffer, now using semicolon delimiter
- [Low][Common, Network, Resolver] Resolver: added new argument numOfSentRequest to requestByName and requestByIp resolving methods, this argument return the number of requests that were sent successfully
- [Low][Client Example (App)] Nqapp: example for WS-Discovery for printers and computers on local network

### Changed
- [Low][UserDefine] Avoid defining definitions that depends on UD_ND_INCLUDENBDAEMON when it is not defined

### Fixed
- [Critical][Server] Parsing Srvsvc NetShareAdd request that contains NULL pointers
- [Critical][Server] Fixed server crash when receiving unsupported control command
- [Critical][Common, Resolver] SF after receiving of DNS response has failed, fixed wrong status of receive DNS response function
- [Critical][Server] Segmentation fault when saving share information into cs_cfg.txt
- [Critical][Common, Resolver] Compilation error on WinCE due to wrong casting
- [Critical][Corporate, Server] WinCE compilation for corporate server
- [Critical][Client] Client: SF that happens during user logon when UD_NQ_INCLUDESMB311 is not defined
- [High][Authentication, Server] SMB1 Negotiate Servers response had garbaged session key field, might cause Windows client to close the connection
- [High][Client, UserDefine] Wrong search patter and wrong condition to check if secret file opened successfully (Windows platform only)
- [High][System] VxWorks mutex mechanism to use proper types
- [High][Server] When GLOBALENCRYPTION=TRUE SMB1 clients were able to connect to YNQ Server
- [High][Authentication, Client] Failure to properly switch to NTLM authentication mechanism in case when Kerberos mechanism has returned an error
- [High][NetBios] When sending NetBIOS name query response, first report the IPs from the subnet same as request
- [High][Server] Server wrongly parses Negotiate response when SMB3 not define resulting in rejecting Clients connection
- [High][Makefile] Makefile support for VxWorks 6.9
- [High][Server, UserDefine] Reload server config file parameters when restarting server via server control tool
- [High][Server, UserDefine] UdSaveShareInformation() was removing the share record from cs_cfg.txt instead of updating
- [Moderate][Server] SrvsvcNetShareGetInfo() wrong response related to sec. descriptors and not valid levels
- [Moderate][Server] Srvsvc NetShareEnum malformed response
- [Moderate][Server] Compilation errors regarding IPV4 & IPV6
- [Moderate][Common] Avoid allocating large buffers if their size is smaller than medium
- [Moderate][Server] Memory leak when deleting user session via srvsvc pipe
- [Moderate][Server] Wrong security descriptor length is set during share set information, thus empty security descriptor is saved in share_sd.txt file
- [Moderate][Client Example (App)] Unreleased memory in nqapp when ND doesnt stop
- [Moderate][Common] Renamed arguments and changed description of cmWStrncpy(). Fixed places that call cmWStrncpy() with destination buffer size instead of number of character to copy.
- [Low][NetBios] VxWorks compilation warnings related to NBD in server main files
- [Low][Authentication, Server] Initialization of signing state for connection in Server SMB1 wasnt true/false, but arbitrary value instead
- [Low][Server] Compilation error undefined references when UD_CS_INCLUDERPC_SRVSVC_EXTENSION is not defined
- [Low][Control] Fixed server control tool to indicate failure in case of timeout
- [Low][System] Fixed compilation warning in syDtEndPacket()
- [Low][Authentication, Common, Ldap, System, UserDefine] Coverity issues
- [Low][Server, System] Fix compilation warnings in NQ Server

### Known Issues
- [Moderate][Control, Server] Adding share of type printer via the control tool of NQ Server is not persistent
- [Low][Server, System] Auto-refresh of folder content might not always work over SMB1 (Linux with inotify)
- [Low][Server] Auto-refresh on print queue might not always work