/*********************************************************************
 *
 *          Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Implementation of the EXTERNAL NOTIFY CHANGE mechanism
 *--------------------------------------------------------------------
 * MODULE        : Linux - SY
 * DEPENDENCIES  :
 ********************************************************************/

#ifndef SYEXNOTIFY_H_
#define SYEXNOTIFY_H_

#include "cmlist.h"
#include "cmapi.h"

typedef struct{
    CMItem    item;              /* List item. */
    NQ_WCHAR  name[CM_BUFFERLENGTH(NQ_WCHAR, UD_FS_FILENAMELEN)];  /* file\directory path*/
    NQ_HANDLE  fileCtx;       /* file watch descriptor for external notify.*/
    NQ_INT32  regNum;        /* number of registration to file */
} SYWFile;

/* The following value is used in NOTIFY CHANGE as a completion filter for file information */
#define COMPLETION_FILTER   SMB_NOTIFYCHANGE_ATTRIBUTES | SMB_NOTIFYCHANGE_LAST_WRITE | SMB_NOTIFYCHANGE_LAST_ACCESS | SMB_NOTIFYCHANGE_CREATION | SMB_NOTIFYCHANGE_SIZE

#define EXNOTIFY_FAIL  -1
#define EXNOTIFY_MAX_TIMEOUT  -1

typedef void (*NotifyImmediatelyCallback)(const NQ_WCHAR *fileName, NQ_UINT32 action, NQ_UINT32 filter);

NQ_STATUS syExNotifyInit(NotifyImmediatelyCallback callback);

void syExNoitfyExit(void);

SYWFile *syExNotifyAddWatch(NQ_WCHAR *path);

void syExNotifyRemoveWatch(SYWFile *wFile);

void syExNotifyMonitor(void);

void handleEvents(void);

void syExNotifyExit(void);

#endif /* SYEXNOTIFY_H_ */
