/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Starting up CIFS Server Daemon + NetBios daemon
 *--------------------------------------------------------------------
 * MODULE        : Linux
 * DEPENDENCIES  :
 ********************************************************************/

#include <signal.h>
#include <sys/resource.h>

#include "nsapi.h"
#ifdef UD_NQ_INCLUDECIFSCLIENT
#include "ccapi.h"
#endif /* UD_NQ_INCLUDECIFSCLIENT */
#ifdef UD_NQ_INCLUDECIFSSERVER
#include "csapi.h"
#endif /* UD_NQ_INCLUDECIFSSERVER */
#ifdef UD_ND_INCLUDENBDAEMON
#include "ndapi.h"

#ifdef SY_SEMAPHORE_AVAILABLE
SYSemaphore  NBSyncSem;                             /* allow main thread to wait for NB Daemon initialization and termination */
#else /* SY_SEMAPHORE_AVAILABLE */
#define NDCS_WAIT_FOR_ND_DAEMON              2      /* time in seconds to wait for ND Daemon to perform initialization or termination */
#endif /* SY_SEMAPHORE_AVAILABLE */

static void startNetbiosMain(void)
{
    ndStart(
#ifdef SY_SEMAPHORE_AVAILABLE
            &NBSyncSem
#endif /* SY_SEMAPHORE_AVAILABLE */
            );
#ifdef SY_SEMAPHORE_AVAILABLE
    sySemaphoreGive(NBSyncSem);
#endif /* SY_SEMAPHORE_AVAILABLE */
}
#endif /* UD_ND_INCLUDENBDAEMON */

static void sigTermHandler(int signumber)
{
#ifdef UD_NQ_INCLUDECIFSSERVER
    csStop();
#endif /* UD_NQ_INCLUDECIFSSERVER */
}

static void sigPipeHandler(int signumber)
{
}

int main(int argc, char** argv)
{
    int result = -1;
#ifdef UD_ND_INCLUDENBDAEMON
    SYThread NBThread = 0;

#ifdef SY_SEMAPHORE_AVAILABLE
    if (NQ_FAIL == sySemaphoreCreate(&NBSyncSem, 0))
    {
        goto Exit;
    }
#endif /* SY_SEMAPHORE_AVAILABLE */
#endif /* UD_ND_INCLUDENBDAEMON */

    signal(SIGTERM, &sigTermHandler);
    signal(SIGPIPE, &sigPipeHandler);

#if defined(UD_NQ_INCLUDECIFSSERVER) || defined(UD_ND_INCLUDENBDAEMON)

    if (!syInit())
    {
        goto Exit1;
    }

    if (NQ_FAIL == udInit())
    {
        goto Exit2;
    }

    nsInitGuard();      /* prepare for using NS */

#ifdef UD_ND_INCLUDENBDAEMON
    syThreadStart(FALSE, NQ_THREAD_PRIORITY_NONE, &NBThread, startNetbiosMain, FALSE);
#ifdef SY_SEMAPHORE_AVAILABLE
    sySemaphoreTake(NBSyncSem);
#else  /* SY_SEMAPHORE_AVAILABLE */
    /* allow some time for ND to initialize */
    sySleep(NDCS_WAIT_FOR_ND_DAEMON);
#endif /* SY_SEMAPHORE_AVAILABLE */
#endif /* UD_ND_INCLUDENBDAEMON */

#ifdef UD_NQ_INCLUDECIFSCLIENT
    if (FALSE == ccInit(NULL))
    {
        goto Exit3;
    }
#endif /* UD_NQ_INCLUDECIFSCLIENT */

#ifdef UD_NQ_INCLUDECIFSSERVER
    result = csStart();
#endif /* UD_NQ_INCLUDECIFSSERVER */

#ifdef UD_NQ_INCLUDECIFSCLIENT
    ccShutdown();
Exit3:
#endif /* UD_NQ_INCLUDECIFSCLIENT */
#ifdef UD_ND_INCLUDENBDAEMON
    if (0 != NBThread)
    {
        ndStop();
#ifdef SY_SEMAPHORE_AVAILABLE
        sySemaphoreTake(NBSyncSem);
#else /* SY_SEMAPHORE_AVAILABLE */
        /* allow some time for ND to terminate */
        sySleep(NDCS_WAIT_FOR_ND_DAEMON);
#endif /* SY_SEMAPHORE_AVAILABLE */
        syThreadDestroy(NBThread);
    }
#endif /* UD_ND_INCLUDENBDAEMON */
    nsExitGuard();
    udStop();
Exit2:
    syStop();
Exit1:
#if defined(UD_ND_INCLUDENBDAEMON) && defined(SY_SEMAPHORE_AVAILABLE)
    /* release semaphore before deleting just in case it isn't released yet */
    sySemaphoreGive(NBSyncSem);
    sySemaphoreDelete(NBSyncSem);
Exit:
#endif /* defined(UD_ND_INCLUDENBDAEMON) && defined(SY_SEMAPHORE_AVAILABLE) */
#endif  /* defined(UD_NQ_INCLUDECIFSSERVER) || defined(UD_ND_INCLUDENBDAEMON) */

    return result;
}

