/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Starting up CIFS Server Daemon
 *--------------------------------------------------------------------
 * MODULE        : Linux
 * DEPENDENCIES  :
 ********************************************************************/

#include <signal.h>
#include <sys/resource.h>

#include "nsapi.h"
#ifdef UD_NQ_INCLUDECIFSCLIENT
#include "ccapi.h"
#endif /* UD_NQ_INCLUDECIFSCLIENT */
#ifdef UD_NQ_INCLUDECIFSSERVER
#include "csapi.h"
#endif /* UD_NQ_INCLUDECIFSSERVER */

static void sigTermHandler(int signumber)
{
#ifdef UD_NQ_INCLUDECIFSSERVER
    csStop();
#endif /* UD_NQ_INCLUDECIFSSERVER */
}

static void sigPipeHandler(int signumber)
{
}

int main(int argc, char** argv)
{
    int result = -1;

    signal(SIGTERM, &sigTermHandler);
    signal(SIGPIPE, &sigPipeHandler);

#ifdef UD_NQ_INCLUDECIFSSERVER
    udInit();           /* new UD */
    syInit();
    nsInitGuard();      /* prepare for using NS */
#ifdef UD_NQ_INCLUDECIFSCLIENT
    if (!ccInit(NULL))
    {
        goto Exit;
    }
#endif /* UD_NQ_INCLUDECIFSCLIENT */

    result = csStart();
#ifdef UD_NQ_INCLUDECIFSCLIENT
    ccShutdown();
Exit:
#endif /* UD_NQ_INCLUDECIFSCLIENT */
    nsExitGuard();
    syStop();
    udStop();
#endif /* UD_NQ_INCLUDECIFSSERVER */

    return result;
}
