/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Unicode string manipulation
 *--------------------------------------------------------------------
 * MODULE        : Common
 * DEPENDENCIES  :
 ********************************************************************/

#ifndef _CMUNICOD_H_
#define _CMUNICOD_H_

#include "cmapi.h"

#define cmWideCharToMultiByte   cmUnicodeToAnsi
#define cmMultiByteToWideChar   cmAnsiToUnicode

/* equivalents to the ansiString ANSI functions */

NQ_UINT
cmWStrlen(
    const NQ_WCHAR* s
    );

void
cmWStrcpy(
    NQ_WCHAR* to,
    const NQ_WCHAR* from
    );

void
cmWStrcat(
    NQ_WCHAR* to,
    const NQ_WCHAR* from
    );

NQ_UINT
cmWStrncpy(
    NQ_WCHAR* to,
    const NQ_WCHAR* from,
    NQ_UINT n
    );

NQ_INT
cmWStrcmp(
    const NQ_WCHAR* s1,
    const NQ_WCHAR* s2
    );

NQ_INT
cmWStrncmp(
    const NQ_WCHAR* s1,
    const NQ_WCHAR* s2,
    NQ_UINT n
    );

NQ_INT
cmWStricmp(
    const NQ_WCHAR* s1,
    const NQ_WCHAR* s2
    );

NQ_INT
cmWStrincmp(
    const NQ_WCHAR* s1,
    const NQ_WCHAR* s2,
    NQ_UINT n
    );

NQ_WCHAR*
cmWStrchr(
    const NQ_WCHAR* s,
    NQ_WCHAR c
    );

NQ_WCHAR*
cmWStrtok(
    NQ_WCHAR* str,
    const NQ_WCHAR* delimiters
    );

NQ_WCHAR*
cmWStrrchr(
    const NQ_WCHAR* s,
    NQ_WCHAR c
    );

void
cmUnicodeToAnsi(
    NQ_CHAR *outStr,
    const NQ_WCHAR* inWStr
    );

void
cmAnsiToUnicode(
    NQ_WCHAR *outWStr,
    const NQ_CHAR *inStr
    );

void
cmUnicodeToAnsiN(
    NQ_CHAR *outStr,
    NQ_UINT outLength,
    const NQ_WCHAR* outWStr,
    NQ_UINT inLength
    );

void
cmAnsiToUnicodeN(
    NQ_WCHAR* outWStr,
    NQ_UINT outLength,
    const NQ_CHAR *inStr,
    NQ_UINT inLength
    );

NQ_CHAR*
cmWDump(
    const NQ_WCHAR* inWStr
    );

void
cmWStrupr(
    NQ_WCHAR* s
    );

NQ_INT
cmWToupper(
    NQ_WCHAR *to,
    const NQ_WCHAR *from
    );

#ifdef UD_NQ_USEIOVECS
NQ_INT
cmIOWStrcpyV2F(
    NQ_WCHAR* to,
    NQ_IOVecPosition iobuf /* from current IOBUF position */
    );
NQ_UINT
cmIOWStrlen(
    NQ_IOVecPosition iobuf
    );
#endif

#endif  /* _CMUNICOD_H_ */
