/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Codepage UTF-8
 *--------------------------------------------------------------------
 * MODULE        : Common
 * DEPENDENCIES  :
 ********************************************************************/

#include "cmapi.h"
#include "cmcp.h"
#include "syopsyst.h"


#ifdef UD_NQ_CODEPAGEUTF8

static NQ_INT
cp8Utf8ToUtf16LE(
    NQ_WCHAR* outWStr,
    NQ_UINT outLength,
    const NQ_CHAR* inStr,
    NQ_UINT inLength
    )
{
    syUTF8ToUnicodeN(outWStr, outLength, inStr, inLength);
    return (NQ_INT)cmWStrlen(outWStr);
}

static NQ_INT
cp8Utf16LEToUtf8(
    NQ_CHAR* outStr,
    NQ_UINT outLength,
    const NQ_WCHAR* inWStr,
    NQ_UINT inLength
    )
{
    syUnicodeToUTF8N(outStr, outLength, inWStr, inLength);
    return (NQ_INT)syStrlen(outStr);
}

static NQ_INT
cpUtf8ToUpper(
    NQ_CHAR* dst,
    const NQ_CHAR* src
    )
{
    *dst = syToupper(*src);
    return 1;
}

const static CMCodepage encUTF8 = {
    UD_NQ_CODEPAGEUTF8,
    cp8Utf16LEToUtf8,
    cp8Utf8ToUtf16LE,
    cpUtf8ToUpper,
    NULL,
    NULL,
    NULL
};

const CMCodepage* cmCpInitUtf8(
    void
    )
{
    return initCodePageUTF8() ? &encUTF8 : NULL;
}


#endif

