/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Codepage 858 - Multilingual Latin I + Euro sign
 *--------------------------------------------------------------------
 * MODULE        : Common
 * DEPENDENCIES  :
 ********************************************************************/

#include "cmapi.h"
#include "cmcp.h"

#ifdef UD_NQ_CODEPAGE858

const static NQ_WCHAR a2u[0x100] = {
    /* 0.. 0x7F are identical to unicode */
    0x00c7, 0x00fc, 0x00e9, 0x00e2, 0x00e4, 0x00e0, 0x00e5, 0x00e7,
    0x00ea, 0x00eb, 0x00e8, 0x00ef, 0x00ee, 0x00ec, 0x00c4, 0x00c5,
    0x00c9, 0x00e6, 0x00c6, 0x00f4, 0x00f6, 0x00f2, 0x00fb, 0x00f9,
    0x00ff, 0x00d6, 0x00dc, 0x00f8, 0x00a3, 0x00d8, 0x00d7, 0x0192,
    0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x00f1, 0x00d1, 0x00aa, 0x00ba,
    0x00bf, 0x00ae, 0x00ac, 0x00bd, 0x00bc, 0x00a1, 0x00ab, 0x00bb,
    0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x00c1, 0x00c2, 0x00c0,
    0x00a9, 0x2563, 0x2551, 0x2557, 0x255d, 0x00a2, 0x00a5, 0x2510,
    0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x00e3, 0x00c3,
    0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x00a4,
    0x00f0, 0x00d0, 0x00ca, 0x00cb, 0x00c8, 0x20ac, 0x00cd, 0x00ce,
    0x00cf, 0x2518, 0x250c, 0x2588, 0x2584, 0x00a6, 0x00cc, 0x2580,
    0x00d3, 0x00df, 0x00d4, 0x00d2, 0x00f5, 0x00d5, 0x00b5, 0x00fe,
    0x00de, 0x00da, 0x00db, 0x00d9, 0x00fd, 0x00dd, 0x00af, 0x00b4,
    0x00ad, 0x00b1, 0x2017, 0x00be, 0x00b6, 0x00a7, 0x00f7, 0x00b8,
    0x00b0, 0x00a8, 0x00b7, 0x00b9, 0x00b3, 0x00b2, 0x25a0, 0x00a0
};

static const NQ_WCHAR u2a_00[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* a */ 0xff, 0xad, 0xbd, 0x9c, 0xcf, 0xbe, 0xdd, 0xf5, 0xf9, 0xb8, 0xa6, 0xae, 0xaa, 0xf0, 0xa9, 0xee,
/* b */ 0xf8, 0xf1, 0xfd, 0xfc, 0xef, 0xe6, 0xf4, 0xfa, 0xf7, 0xfb, 0xa7, 0xaf, 0xac, 0xab, 0xf3, 0xa8,
/* c */ 0xb7, 0xb5, 0xb6, 0xc7, 0x8e, 0x8f, 0x92, 0x80, 0xd4, 0x90, 0xd2, 0xd3, 0xde, 0xd6, 0xd7, 0xd8,
/* d */ 0xd1, 0xa5, 0xe3, 0xe0, 0xe2, 0xe5, 0x99, 0x9e, 0x9d, 0xeb, 0xe9, 0xea, 0x9a, 0xed, 0xe8, 0xe1,
/* e */ 0x85, 0xa0, 0x83, 0xc6, 0x84, 0x86, 0x91, 0x87, 0x8a, 0x82, 0x88, 0x89, 0x8d, 0xa1, 0x8c, 0x8b,
/* f */ 0xd0, 0xa4, 0x95, 0xa2, 0x93, 0xe4, 0x94, 0xf6, 0x9b, 0x97, 0xa3, 0x96, 0x81, 0xec, 0xe7, 0x98
};

static const NQ_WCHAR u2a_25[] = {
/*       0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     f */
/* 0 */ 0xc4, 0x00, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0x00, 0x00, 0x00,
/* 1 */ 0xbf, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0xd9, 0x00, 0x00, 0x00, 0xc3, 0x00, 0x00, 0x00,
/* 2 */ 0x00, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x00, 0x00, 0x00,
/* 3 */ 0x00, 0x00, 0x00, 0x00, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc5, 0x00, 0x00, 0x00,
/* 4 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 5 */ 0xcd, 0xba, 0x00, 0x00, 0xc9, 0x00, 0x00, 0xbb, 0x00, 0x00, 0xc8, 0x00, 0x00, 0xbc, 0x00, 0x00,
/* 6 */ 0xcc, 0x00, 0x00, 0xb9, 0x00, 0x00, 0xcb, 0x00, 0x00, 0xca, 0x00, 0x00, 0xce, 0x00, 0x00, 0x00,
/* 7 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 8 */ 0xdf, 0x00, 0x00, 0x00, 0xdc, 0x00, 0x00, 0x00, 0xdb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 9 */ 0x00, 0xb0, 0xb1, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* a */ 0xfe
};


static NQ_INT
cp858UnicodeToAnsi(
    NQ_CHAR* outStr,
    NQ_UINT outLength,
    const NQ_WCHAR* inWStr,
    NQ_UINT inLength
    )
{
    const NQ_WCHAR* pW = inWStr;
    NQ_CHAR* pA = outStr;
    NQ_INT length = 0;
    NQ_UINT inNumOfCharacters;
    NQ_BOOL ignoreInLength = (inLength == CM_IGNORE_LENGTH);
    NQ_BOOL ignoreOutLength = (outLength == CM_IGNORE_LENGTH);

    inNumOfCharacters = inLength / sizeof(NQ_WCHAR);  /* calculate number of characters for source buffer */
    outLength--;                                      /* reserve place for trailing zero */
    if (outStr && inWStr)
    {
        for ( ; *pW && (ignoreInLength || (inNumOfCharacters > 0)) && (ignoreOutLength || (length < outLength)); pA++, pW++, inNumOfCharacters--, length++ )
        {
            /* extract Msb in wStr */
            NQ_BYTE wLsb, wMsb;
            cmSplitUnicode (*pW, &wMsb, &wLsb);

            *pA = 0x00;

            switch (wMsb)
            {
            case 0x00:
                if (wLsb < 0xA0)  *pA = (NQ_CHAR)wLsb;
                else *pA = (NQ_CHAR)u2a_00[wLsb-0xA0];
                break;
            case 0x01:
                if (wLsb == 0x92) *pA = (NQ_CHAR)0x9f; break;
                break;
            case 0x20:
                switch (wLsb)
                {
                case 0xac: *pA = (NQ_CHAR)0xd5; break;
                case 0x17: *pA = (NQ_CHAR)0xf2;
                }
                break;
            case 0x25:
                if (wLsb <= 0xa0) *pA = (NQ_CHAR)u2a_25[wLsb];
                break;
            }
            if (*pA == 0x00) /* wrong unicode */
                break;
        }
    }
    else
    {
        if (!outStr)
        {
            length = 0;
            goto Exit;
        }
    }

    /* Place trailing zero */
        *pA = '\0';

Exit:
    return length;
}
/*
static NQ_INT
cp858AnsiToUnicode(
    NQ_WCHAR* outWStr,
    NQ_UINT outLength,
    const NQ_CHAR* inStr,
    NQ_UINT inLength
    )
{
    return cmCpSingleByteAnsiToUnicode(outWStr, outLength, inStr, inLength, a2u);
}
*/

static NQ_INT
cp858ToUpper(
    NQ_CHAR* dst,
    const NQ_CHAR* src
    )
{
    *dst = syToupper(*src);
    return 1;
}

static const CMCodepage enc858 = {
    UD_NQ_CODEPAGE858,
    cp858UnicodeToAnsi,
    NULL,
    cp858ToUpper,
    NULL,
    NULL,
    a2u
};

const CMCodepage* cmCpInit858(
    void
    )
{
    return &enc858;
}

#endif
