/*************************************************************************
 * Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *                     All Rights Reserved
 *
 * This item is the property of Visuality Systems, Ltd., and contains
 * confidential, proprietary, and trade-secret information. It may not
 * be transferred from the custody or control of Visuality Systems, Ltd.,
 * except as expressly authorized in writing by an officer of Visuality
 * Systems, Ltd. Neither this item nor the information it contains may
 * be used, transferred, reproduced, published, or disclosed, in whole
 * or in part, and directly or indirectly, except as expressly authorized
 * by an officer of Visuality Systems, Ltd., pursuant to written agreement.
 *
 *************************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : Authentication credentials operations
 *--------------------------------------------------------------------
 * MODULE        : Auth - AM
 * DEPENDENCIES  :
 *************************************************************************/

#ifndef _AMCREDENTIALS_H_ 
#define _AMCREDENTIALS_H_

#include "amapi.h"

/* Description
   Convert ASCII credentials to Unicode
   Parameters
   to : Unicode destination.
   from : ASCII source.
   Returns
   None.
 */
void amCredentialsAsciiiToW(AMCredentials * to, const AMCredentialsA *from);

/* Description
   Init UNICODE credentials
   Parameters
   creds : pointer to credentials struct to initialize.
   domain : domain name.
   user : username.
   password: password
   type : password type.
   Returns
   None.
 */
void amCredentialsInitW(AMCredentials * creds, const NQ_WCHAR *domain, const NQ_WCHAR *user, const NQ_WCHAR *password, NQ_UINT type);

/* Description
   Init ASCII credentials
   Parameters
   creds : pointer to credentials struct to initialize.
   domain : domain name.
   user : username.
   password: password
   type : password type.
   Returns
   None.
 */
void amCredentialsInitA(AMCredentialsA * creds, const NQ_CHAR *domain, const NQ_CHAR *user, const NQ_CHAR *password, NQ_UINT type);

#endif /* _AMCREDENTIALS_H_ */
