#
# Common Makefile for building NQ and sample application
#
.PHONY: all

# Source files
# ---------------
# Should define BUILD_SRC in the Makefile of a folder in which you wish to compile specific sources,
# and not the entire folder.
# See 'service/<os>' and 'app' folders' makefiles for examples.
ifdef BUILD_SRC
SRCS := $(BUILD_SRC)
else
SRCS := $(wildcard *.c)
endif

# Config file
include $(PATHDEFMK)

# Compile commands
include $(OSDEFMK)

# Object and dependency files
OBJS    := $(addprefix $(OBJDIR)/, $(SRCS:.c=.o))
DEPS    := $(addprefix $(DEPDIR)/, $(SRCS:.c=.d))

# Dependency files folder
DEP_DIR := $(shell $(MKDIR) -p $(DEPDIR))

# Object files folder
OBJ_DIR := $(shell $(MKDIR) -p $(OBJDIR))

# Library files folder
LIB_DIR := $(shell $(MKDIR) -p $(LIBDIR))

# Targets
all: $(DEPS) $(OBJS) $(LIBNAME)

# Library build rule --- linux vxworks nucleus---
$(LIBNAME): $(DEPDIR) $(DEPS) $(OBJS)
	@echo Creating library $@...
	@$(AR) $@ $(OBJS)
	@$(LIB) $@

# Object build rule
$(OBJS): $(OBJDIR)/%.o: %.c $(DEPDIR)/%.d
#	@echo Compiling $<...
	@$(COMPILE) $(DEFS) $(DEBUGDEF) $(TRACEDEF) $(TRACELVLDEF) $< -o $@

# Dependencies rule
$(DEPS): $(DEPDIR)/%.d: %.c
#	@echo Creating dependencies for $<...
	@$(MAKEDEP) $< -o temp
	@sed 's,\($*\)\.o[ :]*,\1.o $@ : ,g' < temp > $@
	@$(RM) temp

ifeq ($(MAKECMDGOALS),all)
-include $(DEPS)
endif
