/*********************************************************************
 *
 *           Copyright (c) 2021 by Visuality Systems, Ltd.
 *
 *********************************************************************
 * FILE NAME     : $Workfile:$
 * ID            : $Header:$
 * REVISION      : $Revision:$
 *--------------------------------------------------------------------
 * DESCRIPTION   : CIFS Client domain related operations
 *--------------------------------------------------------------------
 * MODULE        : rpc - domain
 * DEPENDENCIES  : None
 ********************************************************************/

#include "udapi.h"
#include "amapi.h"

NQ_BOOL ccDomainStart(void);

void ccDomainShutdown(void);

/* net logon (ANSI) over smb */

NQ_BOOL ccNetLogonA(                          /* TRUE if success, FAIL otherwise */
    const NQ_CHAR *domain,                    /* domain name */
    const NQ_CHAR *username,                  /* user name */
    const NQ_CHAR *workstation,               /* client computer name */
    const NQ_CHAR *own,                       /* own computer name */
    const NQ_BYTE serverChallenge[8],         /* server challenge */
    const NQ_BYTE *lmPasswd,                  /* pointer to LM password */
    NQ_UINT16 lmPasswdLen,                    /* LM password length */
    const NQ_BYTE *ntlmPasswd,                /* pointer to NTLM password */
    NQ_UINT16 ntlmPasswdLen,                  /* NTLM password length */
    const AMCredentialsA *admin,              /* domain administrator credentials */
    const NQ_BYTE secret[16],                 /* domain secret */ 
    NQ_BOOL isExtendedSecurity,               /* whether extended security is used */
    const NQ_WCHAR * dnsList,                 /* semicolon delimited list of DNS servers */
    const NQ_CHAR *domainDNS,                 /* DNS domain name */
    NQ_BYTE userSessionKey[16],               /* user session key */
    CMSdAccessToken * accessToken             /* user access token */
    );

/* net logon (Unicode) over smb */

NQ_BOOL ccNetLogon(                           /* TRUE if success, FAIL otherwise */
    const NQ_WCHAR *domain,                   /* domain name */
    const NQ_WCHAR *username,                 /* user name */
    const NQ_WCHAR *workstation,              /* client computer name */
    const NQ_WCHAR *own,                      /* own computer name */
    const NQ_BYTE serverChallenge[8],         /* server challenge */
    const NQ_BYTE *lmPasswd,                  /* pointer to LM password */
    NQ_UINT16 lmPasswdLen,                    /* LM password length */
    const NQ_BYTE *ntlmPasswd,                /* pointer to NTLM password */
    NQ_UINT16 ntlmPasswdLen,                  /* NTLM password length */
    const AMCredentials *admin,               /* domain administrator credentials*/
    const NQ_BYTE secret[16],                 /* domain secret */     
    NQ_BOOL isExtendedSecurity,               /* whether extended security is used */
    const NQ_WCHAR * dnsList,                 /* semicolon delimited list of DNS servers */
    const NQ_WCHAR *domainDNS,                /* DNS domain name */
    NQ_BYTE userSessionKey[16],               /* user session key */
    CMSdAccessToken * accessToken             /* user access token */
    );

/* net logon (Unicode) over rpc */

NQ_BOOL ccNetLogonEx(                         /* TRUE if success, FAIL otherwise */
    const NQ_WCHAR *domain,                   /* domain name */
    const NQ_WCHAR *username,                 /* user name */
    const NQ_WCHAR *workstation,              /* client computer name */
    const NQ_WCHAR *own,                      /* own computer name */
    const NQ_BYTE serverChallenge[8],         /* server challenge */
    const NQ_BYTE *lmPasswd,                  /* pointer to LM password */
    NQ_UINT16 lmPasswdLen,                    /* LM password length */
    const NQ_BYTE *ntlmPasswd,                /* pointer to NTLM password */
    NQ_UINT16 ntlmPasswdLen,                  /* NTLM password length */
    const AMCredentials *admin,               /* domain administrator credentials*/
    const NQ_BYTE secret[16],                 /* domain secret */
    NQ_BOOL isExtendedSecurity,               /* whether extended security is used */
    const NQ_WCHAR * dnsList,                 /* semicolon delimited list of DNS servers */
    const NQ_WCHAR *domainDNS,                /* DNS domain name */
    NQ_BYTE userSessionKey[16],               /* user session key */
    CMSdAccessToken * accessToken             /* user access token */
    );
