
# Visuality Systems YNQ project

---

### YNQ is a pure C implementation of the SMB file sharing protocol portable to any OS.


### Package directory structure

 - YNQ-1.5.0                    - YNQ folder:
    - NQ Docs                   - NQ Documentation files.   
    - NQ Library Reference      - NQ Library reference by modules.
    - Password Utility          - Password utility source code and documentation (YNQ Server only).
    - Visuality-YNQ             - YNQ source code and configuration files folder:
        - src                   - This folder contains the source code structure.
        - config                - This folder contains the configuration files.
 - changeLog.md                 - General changelog file.
 - changeLog.xlsx               - Detailed changelog file.
 - README.md                    - This readme file.

### Prerequisites for Server 

- Root privileges to run the daemons
- Kernel must support Kerberos (MIT or HEIMDAL) to run YNQ client with Kerberos authentication, for installation instructions see https://web.mit.edu/kerberos/, https://github.com/heimdal/heimdal

For detailed information on the features above see NQ Server Evaluation Package document in NQ Docs folder


### Prerequisites for Client

- Root privileges to run the daemons
- Kernel must support FUSE to run YNQ FS driver, for installation instructions see https://github.com/libfuse/libfuse
- Kernel must support Kerberos (MIT or HEIMDAL) to run YNQ client with Kerberos authentication, for installation instructions see https://web.mit.edu/kerberos/, https://github.com/heimdal/heimdal
- Kernel must support Libxml2 to run YNQ Client WS-Discovery, for installation instructions see http://xmlsoft.org/index.html
- Kernel must support Ldap to run YNQ Client Ldap Publishing, for installation instructions see http://www.openldap.org
- Mac OS must support coreutils to use Makefile, for installation instructions see http://macappstore.org/coreutils/

For detailed information on the features above see NQ Client Evaluation Package document in NQ Docs folder

### Compiling

For compiling this project use the following command:

make -C src <flags> <label>

<flags> - the Makefile supports the following flags (not mandatory):

    - NQDEBUG       - Enables Debug
    - NQTRACE       - Enables Traces (with default level 1000)
    - NQTRACELVL    - Sets Traces level (10 - 2000)
    - NQCAPTURE     - Enables Internal Capture
    
<label> - The lables defined in the `src/Makefile` file (mandatory, differs per package).

Examples:

    /* NetBIOS Daemon */
    make -C src NQTRACE=1 NQTRACELVL=10 NQCAPTURE=1 nqnd
    
    /* YNQ Client Demo Application */
    make -C src clean nqappall
    
    /* YNQ Corporate Server with NetBIOS Daemon */
    make -C src NQTRACE=1 nqndcs
    
### License

YNQ project is licensed under a commercial license.

