package com.cogniance.acs.util.exception;

public class ACSException extends Exception {
    public ACSException(Throwable cause) {
        super(cause);
    }

    public ACSException(String message, Object... argsAndCause) {
        super(buildMessage(message, argsAndCause), getCause(argsAndCause));
    }

    protected static String buildMessage(String message, Object... args) {
        if (args == null) {
            args = new Object[]{null};
        }
        if ((args.length == 0) || (args.length == 1 && args[0] instanceof Throwable)) {
            return message;
        }
        return String.format(message, args);
    }

    protected static Throwable getCause(Object... args) {
        if (args == null || args.length == 0) {
            return null;
        }
        return args[args.length - 1] instanceof Throwable ? (Throwable) args[args.length - 1] : null;
    }
}
