package com.cogniance.acs.messaging.unimplemented;

import com.cogniance.acs.messaging.AbstractMessage;
import com.cogniance.acs.messaging.api.CPERequest;
import com.cogniance.acs.messaging.params.FaultStruct;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

import static com.cogniance.acs.util.soap.SOAPUtils.getChildElement;
import static com.cogniance.acs.util.soap.SOAPUtils.getChildElementValue;

/**
 * Informs of the completion of a file transfer.
 */
public class AutonomousTransferComplete extends AbstractMessage implements CPERequest {
	private String announceURL;
	private String transferURL;
	private boolean isDownload;
	private String fileType;
	private Integer fileSize;
	private String targetFileName;
	private FaultStruct faultStruct;
	private String startTime;
	private String completeTime;
	
	public AutonomousTransferComplete() {
		super("AutonomousTransferComplete");
		this.faultStruct = new FaultStruct();
	}

    @Override
    protected void parseSOAPBody(SOAPBodyElement body) throws SOAPException {
        this.fileType = getChildElementValue(body, "FileType");
        this.fileSize = Integer.parseInt(getChildElementValue(body, "FileSize"));
        this.targetFileName = getChildElementValue(body, "TargetFileName");
        SOAPElement fCode = getChildElement(body, "FaultStruct");
        if(fCode != null) {
            this.faultStruct.setFaultCode(Integer.parseInt(getChildElementValue(fCode, "FaultCode")));
            this.faultStruct.setFaultString(getChildElementValue(fCode, "FaultString"));
        }
        this.startTime = getChildElementValue(body, "StartTime");
        this.completeTime = getChildElementValue(body, "CompleteTime");
    }

    public String getAnnounceURL() {
		return announceURL;
	}

	public void setAnnounceURL(String announceURL) {
		this.announceURL = announceURL;
	}

	public String getTransferURL() {
		return transferURL;
	}

	public void setTransferURL(String transferURL) {
		this.transferURL = transferURL;
	}

	public boolean isDownload() {
		return isDownload;
	}

	public void setDownload(boolean isDownload) {
		this.isDownload = isDownload;
	}

	public String getFileType() {
		return fileType;
	}

	public void setFileType(String fileType) {
		this.fileType = fileType;
	}

	public Integer getFileSize() {
		return fileSize;
	}

	public void setFileSize(Integer fileSize) {
		this.fileSize = fileSize;
	}

	public String getTargetFileName() {
		return targetFileName;
	}

	public void setTargetFileName(String targetFileName) {
		this.targetFileName = targetFileName;
	}

	public FaultStruct getFaultStruct() {
		return faultStruct;
	}

	public void setFaultStruct(FaultStruct faultStruct) {
		this.faultStruct = faultStruct;
	}

	public String getStartTime() {
		return startTime;
	}

	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}

	public String getCompleteTime() {
		return completeTime;
	}

	public void setCompleteTime(String completeTime) {
		this.completeTime = completeTime;
	}
}
