package com.cogniance.acs.messaging.params;

import com.google.common.base.Objects;

import javax.xml.soap.SOAPElement;

import static com.cogniance.acs.util.soap.SOAPUtils.getChildElement;
import static com.google.common.base.Objects.equal;
import static com.google.common.base.Objects.toStringHelper;

/**
 * Holds information about a CPE, this information can be used to uniquely identify it.
 */
public class DeviceId {
    private final String manufacturer;
    private final String oui;
    private final String productClass;
    private final String serialNumber;

    public DeviceId(String manufacturer, String oui, String productClass, String serialNumber) {
        this.manufacturer = manufacturer;
        this.oui = oui;
        this.productClass = productClass;
        this.serialNumber = serialNumber;
    }

    public String getManufacturer() {
        return manufacturer;
    }

    public String getOui() {
        return oui;
    }

    public String getProductClass() {
        return productClass;
    }

    public String getSerialNumber() {
        return serialNumber;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(manufacturer, oui, productClass, serialNumber);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DeviceId)) {
            return false;
        }
        DeviceId other = (DeviceId) obj;
        return equal(manufacturer, other.manufacturer) &&
                equal(oui, other.oui) &&
                equal(productClass, other.productClass) &&
                equal(serialNumber, other.serialNumber);
    }

    @Override
    public String toString() {
        return toStringHelper(this)
                .add("Manufacturer", manufacturer)
                .add("OUI", oui)
                .add("Product class", productClass)
                .add("Serial number", serialNumber)
                .toString();
    }

    public static DeviceId from(SOAPElement deviceIdElement) {
        return new DeviceId(
                getChildElement(deviceIdElement, "Manufacturer").getValue(),
                getChildElement(deviceIdElement, "OUI").getValue(),
                getChildElement(deviceIdElement, "ProductClass").getValue(),
                getChildElement(deviceIdElement, "SerialNumber").getValue()
        );
    }
}
