package com.cogniance.acs.messaging;


import com.cogniance.acs.messaging.api.ACSRequest;
import com.cogniance.acs.messaging.params.SetParameterAttributesStruct;
import com.cogniance.acs.messaging.util.DataTypes;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import java.util.ArrayList;
import java.util.Iterator;

import static com.cogniance.acs.messaging.util.DataTypes.formatBoolean;
import static com.cogniance.acs.messaging.util.DataTypes.formatInt;

/**
 * Used to set attributes for a parameter.
 */
public class SetParameterAttributes extends AbstractMessage implements ACSRequest {
	private ArrayList<SetParameterAttributesStruct> parameterList;
	
	public SetParameterAttributes() {
		super("SetParameterAttributes");
		this.parameterList = new ArrayList<SetParameterAttributesStruct>();
	}

    @Override
    protected void fillSOAPBody(SOAPBodyElement body) throws SOAPException {
        SOAPElement param = body.addChildElement(SOAP_FACTORY.createName("ParameterList"));
        param.setAttribute(AbstractMessage.SOAP_ENC+":arrayType", "cwmp:SetParameterAttributesStruct[" + this.parameterList.size() + "]");
        for (SetParameterAttributesStruct spas : this.parameterList) {
            SOAPElement pStruct = param.addChildElement("SetParameterAttributesStruct");
            pStruct.addChildElement("Name").setValue(spas.getName());
            pStruct.addChildElement("NotificationChange").setValue(formatBoolean(spas.isNotificationChange()));
            pStruct.addChildElement("Notification").setValue(formatInt(spas.getNotification()));
            pStruct.addChildElement("AccessListChange").setValue(formatBoolean(spas.isAccessListChange()));

            SOAPElement accessList = pStruct.addChildElement(SOAP_FACTORY.createName("AccessList"));
            accessList.setAttribute(AbstractMessage.SOAP_ENC + ":arrayType", "xsd:string[" + spas.getAccessList().size() + "]");
            for (String access : spas.getAccessList()) {
                accessList.addChildElement("string").setValue(access);
            }
        }
    }

    // TODO

    public ArrayList<SetParameterAttributesStruct> getParameterList() {
        return parameterList;
    }

    public void setParameterList(ArrayList<SetParameterAttributesStruct> parameterList) {
        this.parameterList = parameterList;
    }
}
