package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.api.CPEResponse;
import com.cogniance.acs.messaging.params.ParameterInfoStruct;
import com.cogniance.acs.util.exception.ACSRuntimeException;
import com.cogniance.acs.util.soap.SOAPUtils;

import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import static com.cogniance.acs.messaging.params.ParameterInfoStruct.AccessMode.READ_ONLY;
import static com.cogniance.acs.messaging.params.ParameterInfoStruct.AccessMode.WRITABLE;
import static com.cogniance.acs.messaging.util.DataTypes.parseBoolean;
import static com.cogniance.acs.util.soap.SOAPUtils.getChildElementValue;

/**
 * Response with the parameter names.
 */
public class GetParameterNamesResponse extends AbstractMessage implements CPEResponse {
    private final List<ParameterInfoStruct> parameterList = new ArrayList<ParameterInfoStruct>();

    public GetParameterNamesResponse() {
        super("GetParameterNamesResponse");
    }

    @Override
    protected void parseSOAPBody(SOAPBodyElement body) throws SOAPException {
        parameterList.clear();

        Iterator paramListIt = SOAPUtils.getChildElement(body, "ParameterList").getChildElements(SOAP_FACTORY.createName("ParameterInfoStruct"));
        while (paramListIt.hasNext()) {
            SOAPElement prm = (SOAPElement) paramListIt.next();
            String name = getChildElementValue(prm, Names.Name);
            Boolean isWritable = parseBoolean(getChildElementValue(prm, Names.Writable));

            this.parameterList.add(new ParameterInfoStruct(name, isWritable ? WRITABLE : READ_ONLY));
        }
    }

    public List<ParameterInfoStruct> getParameterList() {
        return parameterList;
    }

    private static class Names {

        private static final Name Name;
        private static final Name Writable;

        static {
            try {
                Name = SOAP_FACTORY.createName("Name");
                Writable = SOAP_FACTORY.createName("Writable");
            } catch (SOAPException e) {
                throw new ACSRuntimeException("SOAP initialization failed.", e);
            }
        }
    }
}
