package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.api.ACSRequest;

import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

/**
 * Remove a particular instance of an object.
 */
public class DeleteObject extends AbstractMessage implements ACSRequest {
    private String objectName;
    private String parameterKey;

    public DeleteObject() {
        super("DeleteObject");
    }

    @Override
    protected void fillSOAPBody(SOAPBodyElement body) throws SOAPException {
        SOAPElement oName = body.addChildElement(SOAP_FACTORY.createName("ObjectName"));
        oName.setValue(this.objectName);
        SOAPElement pKey = body.addChildElement(SOAP_FACTORY.createName("ParameterKey"));
        pKey.setValue(this.parameterKey);
    }

}
