package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.api.CPEResponse;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;

import static com.cogniance.acs.util.soap.SOAPUtils.getChildElement;
import static com.cogniance.acs.util.soap.SOAPUtils.getChildElementValue;

/**
 * Response of how the creation went.
 */
public class AddObjectResponse extends AbstractMessage implements CPEResponse {
	private Integer instanceNumber;
	private Integer status;
	
	public AddObjectResponse() {
		super("AddObjectResponse");
	}

    @Override
    protected void parseSOAPBody(SOAPBodyElement body) throws SOAPException {
        instanceNumber = Integer.parseInt(getChildElementValue(body, "InstanceNumber"));
        status = Integer.parseInt(getChildElementValue(body, "Status"));
    }

    public Integer getInstanceNumber() {
        return instanceNumber;
    }

    public void setInstanceNumber(Integer instanceNumber) {
        this.instanceNumber = instanceNumber;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
