package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.api.ACSRequest;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import java.util.ArrayList;
import java.util.List;

/**
 * Used to read the attributes of one or more parameters.
 */
public class GetParameterAttributes extends AbstractMessage implements ACSRequest {
    private final List<String> parameterNames = new ArrayList<String>();

    public GetParameterAttributes() {
        super("GetParameterAttributes");
    }

    @Override
    protected void fillSOAPBody(SOAPBodyElement body) throws SOAPException {
        SOAPElement param = body.addChildElement(SOAP_FACTORY.createName("ParameterNames"));
        param.setAttribute(SOAP_ENC + ":arrayType", "xsd:string[" + this.parameterNames.size() + "]");
        for (String name : this.parameterNames) {
            param.addChildElement("string").setValue(name);
        }
    }

    public void addParameter(String parameter) {
        if (!this.parameterNames.contains(parameter))
            this.parameterNames.add(parameter);
    }

    public List<String> getParameterNames() {
        return parameterNames;
    }
}
