package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.api.CPEResponse;
import com.cogniance.acs.util.soap.SOAPUtils;

import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;

import static com.cogniance.acs.util.soap.SOAPUtils.getChildElementValue;

/**
 * Inform about the deletion, success or not.
 */
public class DeleteObjectResponse extends AbstractMessage implements CPEResponse {
	private Integer status;
	
	public DeleteObjectResponse() {
		super("DeleteObjectResponse");
	}

    @Override
    protected void parseSOAPBody(SOAPBodyElement body) throws SOAPException {
        this.setStatus(Integer.parseInt(getChildElementValue(body, "Status")));
    }

    public void setStatus(Integer status) {
		this.status = status;
	}

	public Integer getStatus() {
		return status;
	}

}
