package com.cogniance.acs.server.api;

import java.util.List;
import java.util.concurrent.TimeUnit;

public interface Device {

    // Data accessors

    String getSerial();

    String getConnectionRequestUrl();

    void setConnectionRequestUrl(String connectionRequestUrl);

    String getConnectionRequestLogin();

    void setConnectionRequestLogin(String login);

    String getConnectionRequestPassword();

    void setConnectionRequestPassword(String password);

    String getACSLogin();

    String getACSPassword();

    // User API

    List<String> listProtocolViolations();

    boolean isInSession();

    Session getCurrentSession();

    Session awaitSession(long timeout, TimeUnit timeUnit) throws AwaitTimeoutException, InterruptedException;

    void awaitSessionFinished(long timeout, TimeUnit timeUnit) throws AwaitTimeoutException, InterruptedException;

    Session initiateSession(long timeout, TimeUnit timeUnit) throws InterruptedException, AwaitTimeoutException;

    void sendConnectionRequest();
}

