package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.api.CPEResponse;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;

import static com.cogniance.acs.util.soap.SOAPUtils.getChildElementValue;

public class UploadResponse extends AbstractMessage implements CPEResponse {
    private Integer status;
    private String startTime;
    private String completeTime;

    public UploadResponse() {
        super("UploadResponse");
    }

    @Override
    protected void parseSOAPBody(SOAPBodyElement body) throws SOAPException {
        this.status = Integer.parseInt(getChildElementValue(body, "Status"));
        this.startTime = getChildElementValue(body, "StartTime");
        this.completeTime = getChildElementValue(body, "CompleteTime");
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getCompleteTime() {
        return completeTime;
    }

    public void setCompleteTime(String completeTime) {
        this.completeTime = completeTime;
    }
}
