package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.api.ACSRequest;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

import static com.google.common.base.Objects.firstNonNull;

/**
 * Make the CPE to upload a file.
 */
public class Upload extends AbstractMessage implements ACSRequest {
	private String commandKey;
	private String fileType;
	private String url;
	private String username;
	private String password;
	private Integer delaySeconds;
	
	public Upload() {
		super("Upload");
	}

    @Override
    protected void fillSOAPBody(SOAPBodyElement body) throws SOAPException {
        body.addChildElement(SOAP_FACTORY.createName("CommandKey")).setValue(this.commandKey);
        body.addChildElement(SOAP_FACTORY.createName("FileType")).setValue(this.fileType);
        body.addChildElement(SOAP_FACTORY.createName("URL")).setValue(this.url);
        body.addChildElement(SOAP_FACTORY.createName("Username")).setValue(firstNonNull(this.username, ""));
        body.addChildElement(SOAP_FACTORY.createName("Password")).setValue(firstNonNull(this.password, ""));
        body.addChildElement(SOAP_FACTORY.createName("DelaySeconds")).setValue(String.valueOf(firstNonNull(this.delaySeconds, 0)));

    }

	public String getCommandKey() {
		return commandKey;
	}

	public void setCommandKey(String commandKey) {
		this.commandKey = commandKey;
	}

	public String getFileType() {
		return fileType;
	}

	public void setFileType(String fileType) {
		this.fileType = fileType;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public Integer getDelaySeconds() {
		return delaySeconds;
	}

	public void setDelaySeconds(Integer delaySeconds) {
		this.delaySeconds = delaySeconds;
	}
}
