package com.cogniance.acs.messaging;


import com.cogniance.acs.messaging.api.CPERequest;
import com.cogniance.acs.messaging.params.FaultStruct;
import com.cogniance.acs.messaging.util.DataType;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

import java.util.Date;

import static com.cogniance.acs.util.soap.SOAPUtils.getChildElement;
import static com.cogniance.acs.util.soap.SOAPUtils.getChildElementValue;

/**
 * Used to indicate if a file transfer were successful or not.
 */
public class TransferComplete extends AbstractMessage implements CPERequest {
    private String commandKey;
    private FaultStruct faultStruct;
    private Date startTime;
    private Date completeTime;

    public TransferComplete() {
        super("TransferComplete");
    }

    @Override
    protected void parseSOAPBody(SOAPBodyElement body) throws SOAPException {
        this.commandKey = getChildElementValue(body, "CommandKey");
        SOAPElement fCode = getChildElement(body, "FaultStruct");
        if (fCode != null) {
            faultStruct = new FaultStruct();
            faultStruct.setFaultCode(Integer.parseInt(getChildElementValue(fCode, "FaultCode")));
            faultStruct.setFaultString(getChildElementValue(fCode, "FaultString"));
        } else {
            faultStruct = null;
        }
        this.startTime = DataType.DATE.parse(getChildElementValue(body, "StartTime"));
        this.completeTime = DataType.DATE.parse(getChildElementValue(body, "CompleteTime"));
    }

    public String getCommandKey() {
        return commandKey;
    }

    public void setCommandKey(String commandKey) {
        this.commandKey = commandKey;
    }

    public FaultStruct getFaultStruct() {
        return faultStruct;
    }

    public void setFaultStruct(FaultStruct faultStruct) {
        this.faultStruct = faultStruct;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getCompleteTime() {
        return completeTime;
    }

    public void setCompleteTime(Date completeTime) {
        this.completeTime = completeTime;
    }
}
